/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.catalina.CredentialHandler;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class DigestCredentialHandlerBase
implements CredentialHandler {
    protected static final StringManager sm = StringManager.getManager(DigestCredentialHandlerBase.class);
    public static final int DEFAULT_SALT_LENGTH = 32;
    private int iterations = this.getDefaultIterations();
    private int saltLength = this.getDefaultSaltLength();
    private final Object randomLock = new Object();
    private volatile Random random = null;
    private boolean logInvalidStoredCredentials = false;

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public void setSaltLength(int n) {
        this.saltLength = n;
    }

    public boolean getLogInvalidStoredCredentials() {
        return this.logInvalidStoredCredentials;
    }

    public void setLogInvalidStoredCredentials(boolean bl) {
        this.logInvalidStoredCredentials = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String mutate(String string) {
        Object object;
        byte[] byArray = null;
        int n = this.getIterations();
        int n2 = this.getSaltLength();
        if (n2 == 0) {
            byArray = new byte[]{};
        } else if (n2 > 0) {
            if (this.random == null) {
                object = this.randomLock;
                synchronized (object) {
                    if (this.random == null) {
                        this.random = new SecureRandom();
                    }
                }
            }
            byArray = new byte[n2];
            this.random.nextBytes(byArray);
        }
        object = this.mutate(string, byArray, n);
        if (object == null) {
            return null;
        }
        if (n2 == 0 && n == 1) {
            return object;
        }
        return HexUtils.toHexString((byte[])byArray) + '$' + n + '$' + (String)object;
    }

    protected boolean matchesSaltIterationsEncoded(String string, String string2) {
        byte[] byArray;
        if (string2 == null) {
            this.logInvalidStoredCredentials(null);
            return false;
        }
        int n = string2.indexOf(36);
        int n2 = string2.indexOf(36, n + 1);
        if (n < 0 || n2 < 0) {
            this.logInvalidStoredCredentials(string2);
            return false;
        }
        String string3 = string2.substring(0, n);
        int n3 = Integer.parseInt(string2.substring(n + 1, n2));
        String string4 = string2.substring(n2 + 1);
        try {
            byArray = HexUtils.fromHexString((String)string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logInvalidStoredCredentials(string2);
            return false;
        }
        String string5 = this.mutate(string, byArray, n3, HexUtils.fromHexString((String)string4).length * 8);
        if (string5 == null) {
            return false;
        }
        return DigestCredentialHandlerBase.equals(string4, string5, true);
    }

    private void logInvalidStoredCredentials(String string) {
        if (this.logInvalidStoredCredentials) {
            this.getLog().warn((Object)sm.getString("credentialHandler.invalidStoredCredential", new Object[]{string}));
        }
    }

    protected int getDefaultSaltLength() {
        return 32;
    }

    protected abstract String mutate(String var1, byte[] var2, int var3);

    protected String mutate(String string, byte[] byArray, int n, int n2) {
        return this.mutate(string, byArray, n);
    }

    public abstract void setAlgorithm(String var1) throws NoSuchAlgorithmException;

    public abstract String getAlgorithm();

    protected abstract int getDefaultIterations();

    protected abstract Log getLog();

    public static boolean equals(String string, String string2, boolean bl) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        int n = string.length();
        int n2 = string2.length();
        if (n2 == 0) {
            return n == 0;
        }
        int n3 = 0;
        n3 |= n - n2;
        for (int i = 0; i < n; ++i) {
            int n4 = (i - n2 >>> 31) * i;
            char c = string.charAt(i);
            char c2 = string2.charAt(n4);
            if (bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            n3 |= c ^ c2;
        }
        return n3 == 0;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        return MessageDigest.isEqual(byArray, byArray2);
    }
}

