"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
exports.execute = execute;
const checker_js_1 = require("../../checker.js");
const common_js_1 = require("./common.js");
function create() {
    return {
        title: "Remove optional semicolons",
        command: "DOT.removeSemicolons",
        arguments: undefined,
    };
}
function execute(doc, sourceFile, cmd) {
    if (!isRemoveSemicolonsCommand(cmd))
        return undefined;
    const g = sourceFile.graph;
    if (!g)
        return undefined;
    const semicolons = (0, checker_js_1.findOptionalSemicolons)(g);
    const edits = semicolons.map(s => {
        const end = s.end;
        const start = end - 1;
        return (0, common_js_1.createChangeToEdit)(doc.positionAt(start), doc.positionAt(end), "");
    });
    return {
        label: "Remove optional semicolons",
        edit: {
            changes: {
                [doc.uri]: edits,
            },
        },
    };
}
function isRemoveSemicolonsCommand(cmd) {
    return (cmd.command === "DOT.removeSemicolons" &&
        (!cmd.arguments || cmd.arguments.length === 0 || cmd.arguments.every(e => e === undefined)));
}
//# sourceMappingURL=RemoveSemicolons.js.map