﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/customer-profiles/CustomerProfilesRequest.h>
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>

#include <utility>

namespace Aws {
namespace CustomerProfiles {
namespace Model {

/**
 */
class GetEventStreamRequest : public CustomerProfilesRequest {
 public:
  AWS_CUSTOMERPROFILES_API GetEventStreamRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetEventStream"; }

  AWS_CUSTOMERPROFILES_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique name of the domain.</p>
   */
  inline const Aws::String& GetDomainName() const { return m_domainName; }
  inline bool DomainNameHasBeenSet() const { return m_domainNameHasBeenSet; }
  template <typename DomainNameT = Aws::String>
  void SetDomainName(DomainNameT&& value) {
    m_domainNameHasBeenSet = true;
    m_domainName = std::forward<DomainNameT>(value);
  }
  template <typename DomainNameT = Aws::String>
  GetEventStreamRequest& WithDomainName(DomainNameT&& value) {
    SetDomainName(std::forward<DomainNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the event stream provided during create operations.</p>
   */
  inline const Aws::String& GetEventStreamName() const { return m_eventStreamName; }
  inline bool EventStreamNameHasBeenSet() const { return m_eventStreamNameHasBeenSet; }
  template <typename EventStreamNameT = Aws::String>
  void SetEventStreamName(EventStreamNameT&& value) {
    m_eventStreamNameHasBeenSet = true;
    m_eventStreamName = std::forward<EventStreamNameT>(value);
  }
  template <typename EventStreamNameT = Aws::String>
  GetEventStreamRequest& WithEventStreamName(EventStreamNameT&& value) {
    SetEventStreamName(std::forward<EventStreamNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainName;

  Aws::String m_eventStreamName;
  bool m_domainNameHasBeenSet = false;
  bool m_eventStreamNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace CustomerProfiles
}  // namespace Aws
