/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.CompressionException;
import com.zeroc.Ice.IllegalMessageSizeException;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;

public class BZip2 {
    private static boolean _checked = false;
    private static Constructor<?> _bzInputStreamCtor;
    private static Constructor<?> _bzOutputStreamCtor;

    public static Buffer compress(Buffer buf, int headerSize, int compressionLevel) {
        assert (BZip2.supported());
        int uncompressedLen = buf.size() - headerSize;
        int compressedLen = (int)((double)uncompressedLen * 1.01 + 600.0);
        byte[] compressed = new byte[compressedLen];
        byte[] data = null;
        int offset = 0;
        try {
            data = buf.b.array();
            offset = buf.b.arrayOffset();
        }
        catch (Exception ex) {
            data = new byte[buf.size()];
            buf.position(0);
            buf.b.get(data);
        }
        try {
            BufferedOutputStream bos = new BufferedOutputStream(compressed);
            Object[] args = new Object[]{bos, compressionLevel};
            OutputStream os = (OutputStream)_bzOutputStreamCtor.newInstance(args);
            os.write(data, offset + headerSize, uncompressedLen);
            os.close();
            compressedLen = bos.pos();
        }
        catch (Exception ex) {
            throw new CompressionException("bzip2 compression failure", ex);
        }
        if (compressedLen >= uncompressedLen) {
            return null;
        }
        Buffer r = new Buffer(false);
        r.resize(headerSize + 4 + compressedLen, false);
        r.position(0);
        r.b.put(data, offset, headerSize);
        r.b.putInt(buf.size());
        r.b.put(compressed, 0, compressedLen);
        return r;
    }

    public static Buffer uncompress(Buffer buf, int headerSize, int messageSizeMax) {
        assert (BZip2.supported());
        buf.position(headerSize);
        int uncompressedSize = buf.b.getInt();
        if (uncompressedSize <= headerSize) {
            throw new IllegalMessageSizeException();
        }
        if (uncompressedSize > messageSizeMax) {
            Ex.throwMemoryLimitException(uncompressedSize, messageSizeMax);
        }
        int compressedLen = buf.size() - headerSize - 4;
        byte[] compressed = null;
        int offset = 0;
        try {
            compressed = buf.b.array();
            offset = buf.b.arrayOffset();
        }
        catch (Exception ex) {
            compressed = new byte[buf.size()];
            buf.position(0);
            buf.b.get(compressed);
        }
        Buffer r = new Buffer(false);
        r.resize(uncompressedSize, false);
        try {
            int n;
            ByteArrayInputStream bais = new ByteArrayInputStream(compressed, offset + headerSize + 4, compressedLen);
            Object[] args = new Object[]{bais};
            InputStream is = (InputStream)_bzInputStreamCtor.newInstance(args);
            r.position(headerSize);
            byte[] arr = new byte[8192];
            while ((n = is.read(arr)) != -1) {
                r.b.put(arr, 0, n);
            }
            is.close();
        }
        catch (Exception ex) {
            throw new CompressionException("bzip2 uncompression failure", ex);
        }
        r.position(0);
        r.b.put(compressed, offset, headerSize);
        return r;
    }

    public static synchronized boolean supported() {
        if (!_checked) {
            _checked = true;
            try {
                Class[] types = new Class[1];
                Class<?> cls = Util.findClass("org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream", null);
                if (cls != null) {
                    types[0] = InputStream.class;
                    _bzInputStreamCtor = cls.getDeclaredConstructor(types);
                }
                if ((cls = Util.findClass("org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream", null)) != null) {
                    types = new Class[]{OutputStream.class, Integer.TYPE};
                    _bzOutputStreamCtor = cls.getDeclaredConstructor(types);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _bzInputStreamCtor != null && _bzOutputStreamCtor != null;
    }

    private static class BufferedOutputStream
    extends OutputStream {
        private byte[] _data;
        private int _pos;

        BufferedOutputStream(byte[] data) {
            this._data = data;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
            assert (this._data.length - this._pos >= b.length);
            System.arraycopy(b, 0, this._data, this._pos, b.length);
            this._pos += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            assert (this._data.length - this._pos >= len);
            System.arraycopy(b, off, this._data, this._pos, len);
            this._pos += len;
        }

        @Override
        public void write(int b) throws IOException {
            assert (this._data.length - this._pos >= 1);
            this._data[this._pos] = (byte)b;
            ++this._pos;
        }

        int pos() {
            return this._pos;
        }
    }
}

