/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.join;

import java.util.List;
import org.opensearch.search.SearchHit;
import org.opensearch.sql.legacy.executor.join.ElasticJoinExecutor;
import org.opensearch.sql.legacy.query.planner.HashJoinQueryPlanRequestBuilder;
import org.opensearch.sql.legacy.query.planner.core.QueryPlanner;
import org.opensearch.transport.client.Client;

class QueryPlanElasticExecutor
extends ElasticJoinExecutor {
    private final QueryPlanner queryPlanner;

    QueryPlanElasticExecutor(Client client, HashJoinQueryPlanRequestBuilder request) {
        super(client, request);
        this.queryPlanner = request.plan();
    }

    @Override
    protected List<SearchHit> innerRun() {
        List<SearchHit> result = this.queryPlanner.execute();
        this.populateMetaResult();
        return result;
    }

    private void populateMetaResult() {
        this.metaResults.addTotalNumOfShards(this.queryPlanner.getMetaResult().getTotalNumOfShards());
        this.metaResults.addSuccessfulShards(this.queryPlanner.getMetaResult().getSuccessfulShards());
        this.metaResults.addFailedShards(this.queryPlanner.getMetaResult().getFailedShards());
        this.metaResults.updateTimeOut(this.queryPlanner.getMetaResult().isTimedOut());
    }
}

