# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "policy assignment list",
)
class List(AAZCommand):
    """Retrieve all applicable policy assignments.

    Retrieve the list of all policy assignments applicable to the given subscription or management group.

    :example: List policy assignments that apply to a resource group
        az policy assignment list --resource-group TestResourceGroup --filter atScope() --expand LatestDefinitionVersion, EffectiveDefinitionVersion

    :example: List policy assignments that apply to a management group
        az policy assignment list --management-group TestManagementGroup --filter atScope()

    :example: List policy assignments that apply to a subscription
        az policy assignment list --filter atScope()
    """

    _aaz_info = {
        "version": "2024-05-01",
        "resources": [
            ["mgmt-plane", "/providers/microsoft.management/managementgroups/{}/providers/microsoft.authorization/policyassignments", "2024-05-01"],
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.authorization/policyassignments", "2024-05-01"],
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.authorization/policyassignments", "2024-05-01"],
        ]
    }

    AZ_SUPPORT_PAGINATION = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_paging(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.management_group = AAZStrArg(
            options=["--management-group"],
            help={"short-summary": "The management group.", "long-summary": "Indicates that policy assignments whose scope covers the management group with the given name are to be listed."},
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            help={"short-summary": "The resource group.", "long-summary": "Indicates that policy assignments whose scope covers the resource group with the given name are to be listed."},
        )
        _args_schema.expand = AAZStrArg(
            options=["--expand"],
            help={"short-summary": "Additional properties to include in output", "long-summary": "Comma-separated list of additional properties to include in the command output. Supported values are 'LatestDefinitionVersion, EffectiveDefinitionVersion'."},
        )
        _args_schema.filter = AAZStrArg(
            options=["--filter"],
            help={"short-summary": "Filter list results.", "long-summary": "The filter to limit list results. Valid values are: 'atScope()', 'atExactScope()', 'atScopeAndBelow()' or 'policyDefinitionId eq '{value}''. If filter is not provided, no filtering is performed. If filter atScope() is provided, the returned list includes all policy assignments that apply to the given scope, which is everything in the unfiltered list except those applied to sub scopes contained within the given scope. If filter atExactScope() is provided, the returned list includes all policy assignments at the given scope.  If filter atScopeAndBelow() is provided, the returned list includes all policy assignments at the given scope and those in sub scopes contained within the given scope. If filter policyDefinitionId eq '{value}' is provided, the returned list includes all policy assignments of the policy definition whose id is {value}."},
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        condition_0 = has_value(self.ctx.args.management_group)
        condition_1 = has_value(self.ctx.subscription_id) and has_value(self.ctx.args.resource_group) is not True
        condition_2 = has_value(self.ctx.args.resource_group) and has_value(self.ctx.subscription_id)
        if condition_0:
            self.PolicyAssignmentsListForManagementGroup(ctx=self.ctx)()
        if condition_1:
            self.PolicyAssignmentsList(ctx=self.ctx)()
        if condition_2:
            self.PolicyAssignmentsListForResourceGroup(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        next_link = self.deserialize_output(self.ctx.vars.instance.next_link)
        return result, next_link

    class PolicyAssignmentsListForManagementGroup(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policyAssignments",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "managementGroupId", self.ctx.args.management_group,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$expand", self.ctx.args.expand,
                ),
                **self.serialize_query_param(
                    "$filter", self.ctx.args.filter,
                ),
                **self.serialize_query_param(
                    "api-version", "2024-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
            )
            _schema_on_200.value = AAZListType()

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.identity = AAZIdentityObjectType()
            _element.location = AAZStrType()
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            identity = cls._schema_on_200.value.Element.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200.value.Element.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.assignment_type = AAZStrType(
                serialized_name="assignmentType",
            )
            properties.definition_version = AAZStrType(
                serialized_name="definitionVersion",
            )
            properties.description = AAZStrType()
            properties.display_name = AAZStrType(
                serialized_name="displayName",
            )
            properties.effective_definition_version = AAZStrType(
                serialized_name="effectiveDefinitionVersion",
                flags={"read_only": True},
            )
            properties.enforcement_mode = AAZStrType(
                serialized_name="enforcementMode",
            )
            properties.latest_definition_version = AAZStrType(
                serialized_name="latestDefinitionVersion",
                flags={"read_only": True},
            )
            properties.metadata = AAZDictType()
            properties.non_compliance_messages = AAZListType(
                serialized_name="nonComplianceMessages",
            )
            properties.not_scopes = AAZListType(
                serialized_name="notScopes",
            )
            properties.overrides = AAZListType()
            properties.parameters = AAZDictType()
            properties.policy_definition_id = AAZStrType(
                serialized_name="policyDefinitionId",
            )
            properties.resource_selectors = AAZListType(
                serialized_name="resourceSelectors",
            )
            properties.scope = AAZStrType(
                flags={"read_only": True},
            )

            metadata = cls._schema_on_200.value.Element.properties.metadata
            metadata.Element = AAZAnyType()

            non_compliance_messages = cls._schema_on_200.value.Element.properties.non_compliance_messages
            non_compliance_messages.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.non_compliance_messages.Element
            _element.message = AAZStrType(
                flags={"required": True},
            )
            _element.policy_definition_reference_id = AAZStrType(
                serialized_name="policyDefinitionReferenceId",
            )

            not_scopes = cls._schema_on_200.value.Element.properties.not_scopes
            not_scopes.Element = AAZStrType()

            overrides = cls._schema_on_200.value.Element.properties.overrides
            overrides.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.overrides.Element
            _element.kind = AAZStrType()
            _element.selectors = AAZListType()
            _element.value = AAZStrType()

            selectors = cls._schema_on_200.value.Element.properties.overrides.Element.selectors
            selectors.Element = AAZObjectType()
            _ListHelper._build_schema_selector_read(selectors.Element)

            parameters = cls._schema_on_200.value.Element.properties.parameters
            parameters.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.parameters.Element
            _element.value = AAZAnyType()

            resource_selectors = cls._schema_on_200.value.Element.properties.resource_selectors
            resource_selectors.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.resource_selectors.Element
            _element.name = AAZStrType()
            _element.selectors = AAZListType()

            selectors = cls._schema_on_200.value.Element.properties.resource_selectors.Element.selectors
            selectors.Element = AAZObjectType()
            _ListHelper._build_schema_selector_read(selectors.Element)

            system_data = cls._schema_on_200.value.Element.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200

    class PolicyAssignmentsList(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyAssignments",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$expand", self.ctx.args.expand,
                ),
                **self.serialize_query_param(
                    "$filter", self.ctx.args.filter,
                ),
                **self.serialize_query_param(
                    "api-version", "2024-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
            )
            _schema_on_200.value = AAZListType()

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.identity = AAZIdentityObjectType()
            _element.location = AAZStrType()
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            identity = cls._schema_on_200.value.Element.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200.value.Element.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.assignment_type = AAZStrType(
                serialized_name="assignmentType",
            )
            properties.definition_version = AAZStrType(
                serialized_name="definitionVersion",
            )
            properties.description = AAZStrType()
            properties.display_name = AAZStrType(
                serialized_name="displayName",
            )
            properties.effective_definition_version = AAZStrType(
                serialized_name="effectiveDefinitionVersion",
                flags={"read_only": True},
            )
            properties.enforcement_mode = AAZStrType(
                serialized_name="enforcementMode",
            )
            properties.latest_definition_version = AAZStrType(
                serialized_name="latestDefinitionVersion",
                flags={"read_only": True},
            )
            properties.metadata = AAZDictType()
            properties.non_compliance_messages = AAZListType(
                serialized_name="nonComplianceMessages",
            )
            properties.not_scopes = AAZListType(
                serialized_name="notScopes",
            )
            properties.overrides = AAZListType()
            properties.parameters = AAZDictType()
            properties.policy_definition_id = AAZStrType(
                serialized_name="policyDefinitionId",
            )
            properties.resource_selectors = AAZListType(
                serialized_name="resourceSelectors",
            )
            properties.scope = AAZStrType(
                flags={"read_only": True},
            )

            metadata = cls._schema_on_200.value.Element.properties.metadata
            metadata.Element = AAZAnyType()

            non_compliance_messages = cls._schema_on_200.value.Element.properties.non_compliance_messages
            non_compliance_messages.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.non_compliance_messages.Element
            _element.message = AAZStrType(
                flags={"required": True},
            )
            _element.policy_definition_reference_id = AAZStrType(
                serialized_name="policyDefinitionReferenceId",
            )

            not_scopes = cls._schema_on_200.value.Element.properties.not_scopes
            not_scopes.Element = AAZStrType()

            overrides = cls._schema_on_200.value.Element.properties.overrides
            overrides.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.overrides.Element
            _element.kind = AAZStrType()
            _element.selectors = AAZListType()
            _element.value = AAZStrType()

            selectors = cls._schema_on_200.value.Element.properties.overrides.Element.selectors
            selectors.Element = AAZObjectType()
            _ListHelper._build_schema_selector_read(selectors.Element)

            parameters = cls._schema_on_200.value.Element.properties.parameters
            parameters.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.parameters.Element
            _element.value = AAZAnyType()

            resource_selectors = cls._schema_on_200.value.Element.properties.resource_selectors
            resource_selectors.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.resource_selectors.Element
            _element.name = AAZStrType()
            _element.selectors = AAZListType()

            selectors = cls._schema_on_200.value.Element.properties.resource_selectors.Element.selectors
            selectors.Element = AAZObjectType()
            _ListHelper._build_schema_selector_read(selectors.Element)

            system_data = cls._schema_on_200.value.Element.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200

    class PolicyAssignmentsListForResourceGroup(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/policyAssignments",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$expand", self.ctx.args.expand,
                ),
                **self.serialize_query_param(
                    "$filter", self.ctx.args.filter,
                ),
                **self.serialize_query_param(
                    "api-version", "2024-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
            )
            _schema_on_200.value = AAZListType()

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.identity = AAZIdentityObjectType()
            _element.location = AAZStrType()
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            identity = cls._schema_on_200.value.Element.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200.value.Element.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.assignment_type = AAZStrType(
                serialized_name="assignmentType",
            )
            properties.definition_version = AAZStrType(
                serialized_name="definitionVersion",
            )
            properties.description = AAZStrType()
            properties.display_name = AAZStrType(
                serialized_name="displayName",
            )
            properties.effective_definition_version = AAZStrType(
                serialized_name="effectiveDefinitionVersion",
                flags={"read_only": True},
            )
            properties.enforcement_mode = AAZStrType(
                serialized_name="enforcementMode",
            )
            properties.latest_definition_version = AAZStrType(
                serialized_name="latestDefinitionVersion",
                flags={"read_only": True},
            )
            properties.metadata = AAZDictType()
            properties.non_compliance_messages = AAZListType(
                serialized_name="nonComplianceMessages",
            )
            properties.not_scopes = AAZListType(
                serialized_name="notScopes",
            )
            properties.overrides = AAZListType()
            properties.parameters = AAZDictType()
            properties.policy_definition_id = AAZStrType(
                serialized_name="policyDefinitionId",
            )
            properties.resource_selectors = AAZListType(
                serialized_name="resourceSelectors",
            )
            properties.scope = AAZStrType(
                flags={"read_only": True},
            )

            metadata = cls._schema_on_200.value.Element.properties.metadata
            metadata.Element = AAZAnyType()

            non_compliance_messages = cls._schema_on_200.value.Element.properties.non_compliance_messages
            non_compliance_messages.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.non_compliance_messages.Element
            _element.message = AAZStrType(
                flags={"required": True},
            )
            _element.policy_definition_reference_id = AAZStrType(
                serialized_name="policyDefinitionReferenceId",
            )

            not_scopes = cls._schema_on_200.value.Element.properties.not_scopes
            not_scopes.Element = AAZStrType()

            overrides = cls._schema_on_200.value.Element.properties.overrides
            overrides.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.overrides.Element
            _element.kind = AAZStrType()
            _element.selectors = AAZListType()
            _element.value = AAZStrType()

            selectors = cls._schema_on_200.value.Element.properties.overrides.Element.selectors
            selectors.Element = AAZObjectType()
            _ListHelper._build_schema_selector_read(selectors.Element)

            parameters = cls._schema_on_200.value.Element.properties.parameters
            parameters.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.parameters.Element
            _element.value = AAZAnyType()

            resource_selectors = cls._schema_on_200.value.Element.properties.resource_selectors
            resource_selectors.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.resource_selectors.Element
            _element.name = AAZStrType()
            _element.selectors = AAZListType()

            selectors = cls._schema_on_200.value.Element.properties.resource_selectors.Element.selectors
            selectors.Element = AAZObjectType()
            _ListHelper._build_schema_selector_read(selectors.Element)

            system_data = cls._schema_on_200.value.Element.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200


class _ListHelper:
    """Helper class for List"""

    _schema_selector_read = None

    @classmethod
    def _build_schema_selector_read(cls, _schema):
        if cls._schema_selector_read is not None:
            _schema["in"] = cls._schema_selector_read["in"]
            _schema.kind = cls._schema_selector_read.kind
            _schema.not_in = cls._schema_selector_read.not_in
            return

        cls._schema_selector_read = _schema_selector_read = AAZObjectType()

        selector_read = _schema_selector_read
        selector_read["in"] = AAZListType()
        selector_read.kind = AAZStrType()
        selector_read.not_in = AAZListType(
            serialized_name="notIn",
        )

        in_ = _schema_selector_read["in"]
        in_.Element = AAZStrType()

        not_in = _schema_selector_read.not_in
        not_in.Element = AAZStrType()

        _schema["in"] = cls._schema_selector_read["in"]
        _schema.kind = cls._schema_selector_read.kind
        _schema.not_in = cls._schema_selector_read.not_in


__all__ = ["List"]
