/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.io;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;

/**
 * DefaultCsvLineParserTest
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id$
 */
public class DefaultCsvLineParserTest extends TestCase {
	
	private DefaultCsvLineParser parser = null;
	

	protected void setUp() throws Exception {
		super.setUp();
		
		this.parser = new DefaultCsvLineParser();
	}

	
	protected void tearDown() throws Exception {
		super.tearDown();
		
		this.parser = null;
	}

	
	/*
	 * 'jp.sourceforge.webframe.io.DefaultCsvLineParser.parse(String, String, String[])' test method
	 */
	public void testParse() throws Exception {
		String csvLine = "This:is:CSV:line:string.";
		String delim = ":";
		String[] itemNames = new String[]{
			"first",
			"second",
			"third",
			"fourth",
			"fifth"
		};
		
		// 1. Normal
		this.parser.setDelim(delim);
		this.parser.setItemNames(itemNames);
		Map actual = this.parser.parse(csvLine);
		
		Map expected = new HashMap();
		expected.put("first", "This");
		expected.put("second", "is");
		expected.put("third", "CSV");
		expected.put("fourth", "line");
		expected.put("fifth", "string.");
		
		assertEquals(expected, actual);
		
		// 2. Exceptional
		try {
			String malFormedLine = "This:is:invalid:CSV:line:string.";
			actual = this.parser.parse(malFormedLine);
			fail("Test failed.");
		}
		catch (LineMalformedException e) {
			// success.
			System.out.println(e.getMessage());
		}
	}

}
