/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import junit.framework.TestCase;

/**
 * TracTicketBeanTest
 *
 * @author Yomei Komiya
 *
 * $Id$
 */
public class TracTicketBeanTest extends TestCase {

	private TracTicketBean tracTicketBean;

	
	protected void setUp() throws Exception {
		super.setUp();
		
		this.tracTicketBean = new TracTicketBeanMock();
	}

	
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	
	/*
	 * 'jp.sourceforge.webframe.compass.entity.TracTicketBean.buildIdentifier()' test method
	 */
	public void testBuildIdentifier() {
		String resourceContext = "http://localhost/trac/home/ticket/";
		String localIdentifier = "256";
		this.tracTicketBean.setResourceContext(resourceContext);
		this.tracTicketBean.setLocalIdentifier(localIdentifier);
		this.tracTicketBean.buildIdentifier();
		
		assertEquals(
				resourceContext + localIdentifier,
				this.tracTicketBean.getIdentifier());
	}

}
