/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.velocity.tools.struts;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts.Globals;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.ModuleUtils;
import org.apache.velocity.tools.struts.StrutsUtils;

/**
 * ExtendedStrutsUtils
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id$
 */
public class ExtendedStrutsUtils extends StrutsUtils {

	public static String getActionMappingURL(
			ServletContext application,
			HttpServletRequest request,
			String module,
			String action) {

		String contextPath = request.getContextPath();
		StringBuffer value = new StringBuffer();
		// Avoid setting two slashes at the beginning of an action:
		//  the length of contextPath should be more than 1
		//  in case of non-root context, otherwise length==1 (the slash)
		if (contextPath.length() > 1) value.append(contextPath);

		ModuleConfig moduleConfig
			= ModuleUtils.getInstance().getModuleConfig(
					module, request, request.getSession().getServletContext());

		if ((moduleConfig != null)) {
			value.append(moduleConfig.getPrefix());
		}

		// Use our servlet mapping, if one is specified
		String servletMapping =
			(String)application.getAttribute(Globals.SERVLET_KEY);

		if (servletMapping != null) {

			String queryString = null;
			int question = action.indexOf("?");
			if (question >= 0) {
				queryString = action.substring(question);
			}

			String actionMapping = getActionMappingName(action);
			if (servletMapping.startsWith("*.")) {
				value.append(actionMapping);
				value.append(servletMapping.substring(1));
			}
			else if (servletMapping.endsWith("/*")) {
				value.append(
						servletMapping.substring(0, servletMapping.length() - 2));
				value.append(actionMapping);
			}
			else if (servletMapping.equals("/")) {
				value.append(actionMapping);
			}
			if (queryString != null) {
				value.append(queryString);
			}
		}
		// Otherwise, assume extension mapping is in use and extension is
		// already included in the action property
		else {
			if (!action.startsWith("/")) {
				value.append("/");
			}
			value.append(action);
		}

		return value.toString();
	}

}
