﻿using System;
using System.Collections.Generic;
using System.Text;
using FDK;
using System.Drawing;
using System.Runtime.InteropServices;

namespace DTXMania
{
	internal class CAct演奏スコア共通 : CActivity
	{
		// プロパティ

		protected STDGBVALUE<long> nスコアの増分;
		protected STDGBVALUE<double> n現在の本当のスコア;
		protected STDGBVALUE<long> n現在表示中のスコア;
		protected long n進行用タイマ;
		protected CTexture txScore;
        protected CTexture txScoreAdd_1P;
        protected CCounter ctTimer;

        protected STスコア[] stScore;
        protected int n現在表示中のAddScore;

        [StructLayout( LayoutKind.Sequential )]
        protected struct STスコア
        {
            public bool b使用中;
            public bool b表示中;
            public bool bBonusScore;
            public CCounter ctTimer;
            public int nAddScore;
        }

        [StructLayout(LayoutKind.Sequential)]
        private struct ST文字位置
        {
            public char ch;
            public Point pt;
        }
        private ST文字位置[] stFont;


		// コンストラクタ

		public CAct演奏スコア共通()
		{
            ST文字位置[] st文字位置Array = new ST文字位置[11];
            ST文字位置 st文字位置 = new ST文字位置();
            st文字位置.ch = '0';
            st文字位置.pt = new Point(0, 0);
            st文字位置Array[0] = st文字位置;
            ST文字位置 st文字位置2 = new ST文字位置();
            st文字位置2.ch = '1';
            st文字位置2.pt = new Point(24, 0);
            st文字位置Array[1] = st文字位置2;
            ST文字位置 st文字位置3 = new ST文字位置();
            st文字位置3.ch = '2';
            st文字位置3.pt = new Point(48, 0);
            st文字位置Array[2] = st文字位置3;
            ST文字位置 st文字位置4 = new ST文字位置();
            st文字位置4.ch = '3';
            st文字位置4.pt = new Point(72, 0);
            st文字位置Array[3] = st文字位置4;
            ST文字位置 st文字位置5 = new ST文字位置();
            st文字位置5.ch = '4';
            st文字位置5.pt = new Point(96, 0);
            st文字位置Array[4] = st文字位置5;
            ST文字位置 st文字位置6 = new ST文字位置();
            st文字位置6.ch = '5';
            st文字位置6.pt = new Point(120, 0);
            st文字位置Array[5] = st文字位置6;
            ST文字位置 st文字位置7 = new ST文字位置();
            st文字位置7.ch = '6';
            st文字位置7.pt = new Point(144, 0);
            st文字位置Array[6] = st文字位置7;
            ST文字位置 st文字位置8 = new ST文字位置();
            st文字位置8.ch = '7';
            st文字位置8.pt = new Point(168, 0);
            st文字位置Array[7] = st文字位置8;
            ST文字位置 st文字位置9 = new ST文字位置();
            st文字位置9.ch = '8';
            st文字位置9.pt = new Point(192, 0);
            st文字位置Array[8] = st文字位置9;
            ST文字位置 st文字位置10 = new ST文字位置();
            st文字位置10.ch = '9';
            st文字位置10.pt = new Point(216, 0);
            st文字位置Array[9] = st文字位置10;
            this.stFont = st文字位置Array;

            this.stScore = new STスコア[ 256 ];
			base.b活性化してない = true;
		}


		// メソッド

		public double Get( E楽器パート part )
		{
			return this.n現在の本当のスコア[ (int) part ];
		}
		public void Set( E楽器パート part, double nScore )
		{
            //現状、TAIKOパートでの演奏記録を結果ステージに持っていけないので、ドラムパートにも加算することでお茶を濁している。
            if( part == E楽器パート.TAIKO )
                part = E楽器パート.DRUMS;

			int nPart = (int) part;
			if( this.n現在の本当のスコア[ nPart ] != nScore )
			{
				this.n現在の本当のスコア[ nPart ] = nScore;
				this.nスコアの増分[ nPart ] = (long) ( ( (double) ( this.n現在の本当のスコア[ nPart ] - this.n現在表示中のスコア[ nPart ] ) ) / 20.0 );
				this.nスコアの増分.Guitar = (long) ( ( (double) ( this.n現在の本当のスコア[ nPart ] - this.n現在表示中のスコア[ nPart ] ) ) );
				if( this.nスコアの増分[ nPart ] < 1L )
				{
					this.nスコアの増分[ nPart ] = 1L;
				}
			}

            if( part == E楽器パート.DRUMS )
                part = E楽器パート.TAIKO;

			nPart = (int) part;
			if( this.n現在の本当のスコア[ nPart ] != nScore )
			{
				this.n現在の本当のスコア[ nPart ] = nScore;
				this.nスコアの増分[ nPart ] = (long) ( ( (double) ( this.n現在の本当のスコア[ nPart ] - this.n現在表示中のスコア[ nPart ] ) ) / 20.0 );
                this.nスコアの増分.Guitar = (long) ( ( (double) ( this.n現在の本当のスコア[ nPart ] - this.n現在表示中のスコア[ nPart ] ) ) );
				if( this.nスコアの増分[ nPart ] < 1L )
				{
					this.nスコアの増分[ nPart ] = 1L;
				}
			}
            
		}
		/// <summary>
		/// 点数を加える(各種AUTO補正つき)
		/// </summary>
		/// <param name="part"></param>
		/// <param name="bAutoPlay"></param>
		/// <param name="delta"></param>
		public void Add( E楽器パート part, STAUTOPLAY bAutoPlay, long delta )
		{
			double rev = 1.0;
			switch ( part )
			{
				#region [ Unknown ]
				case E楽器パート.UNKNOWN:
					throw new ArgumentException();
				#endregion
				#region [ Drums ]
				case E楽器パート.DRUMS:
					if ( !CDTXMania.ConfigIni.bドラムが全部オートプレイである )
					{
						#region [ Auto BD ]
						if ( bAutoPlay.BD == true )
						{
							rev /= 2;
						}
						#endregion
					}
					break;
				#endregion
				#region [ Gutiar ]
				case E楽器パート.GUITAR:
					if ( !CDTXMania.ConfigIni.bギターが全部オートプレイである )
					{
						#region [ Auto Wailing ]
						if ( bAutoPlay.GtW )
						{
							rev /= 2;
						}
						#endregion
						#region [ Auto Pick ]
						if ( bAutoPlay.GtPick )
						{
							rev /= 3;
						}
						#endregion
						#region [ Auto Neck ]
						if ( bAutoPlay.GtR || bAutoPlay.GtG || bAutoPlay.GtB )
						{
							rev /= 4;
						}
						#endregion
					}
					break;
				#endregion
				#region [ Bass ]
				case E楽器パート.BASS:
					if ( !CDTXMania.ConfigIni.bベースが全部オートプレイである )
					{
						#region [ Auto Wailing ]
						if ( bAutoPlay.BsW )
						{
							rev /= 2;
						}
						#endregion
						#region [ Auto Pick ]
						if ( bAutoPlay.BsPick )
						{
							rev /= 3;
						}
						#endregion
						#region [ Auto Neck ]
						if ( bAutoPlay.BsR || bAutoPlay.BsG || bAutoPlay.BsB )
						{
							rev /= 4;
						}
						#endregion
					}
					break;
				#endregion
			}
            this.ctTimer = new CCounter( 0, 500, 1, CDTXMania.Timer );

            for( int sc = 0; sc < 1; sc++ )
            {
                for( int i = 0; i < 256; i++ )
                {
                    if( this.stScore[ i ].b使用中 == false )
                    {
                        this.stScore[ i ].b使用中 = true;
                        this.stScore[ i ].b表示中 = true;
                        this.stScore[ i ].nAddScore = (int)delta;
                        this.stScore[ i ].ctTimer = new CCounter( 0, 500, 1, CDTXMania.Timer );
                        this.stScore[i].bBonusScore = false;
                        this.n現在表示中のAddScore++;
                        break;
                    }
                }
            }

			this.Set( part, this.Get( part ) + delta * rev );
		}

        public void BonusAdd()
        {
            for( int sc = 0; sc < 1; sc++ )
            {
                for( int i = 0; i < 256; i++ )
                {
                    if( this.stScore[ i ].b使用中 == false )
                    {
                        this.stScore[ i ].b使用中 = true;
                        this.stScore[ i ].b表示中 = true;
                        this.stScore[ i ].nAddScore = 10000;
                        this.stScore[ i ].ctTimer = new CCounter( 0, 500, 1, CDTXMania.Timer );
                        this.stScore[i].bBonusScore = true;
                        this.n現在表示中のAddScore++;
                        break;
                    }
                }
            }

            this.Set( E楽器パート.TAIKO, this.Get( E楽器パート.TAIKO ) + 10000 );
        }

		// CActivity 実装

		public override void On活性化()
		{
			this.n進行用タイマ = -1;
			for( int i = 0; i < 4; i++ )
			{
				this.n現在表示中のスコア[ i ] = 0L;
				this.n現在の本当のスコア[ i ] = 0L;
				this.nスコアの増分[ i ] = 0L;
			}
            for( int sc = 0; sc < 256; sc++ )
            {
                this.stScore[ sc ].b使用中 = false;
                this.stScore[ sc ].ctTimer = new CCounter();
                this.stScore[ sc ].nAddScore = 0;
                this.stScore[sc].bBonusScore = false;
            }

            this.n現在表示中のAddScore = 0;

            this.ctTimer = new CCounter();
			base.On活性化();
		}
		public override void OnManagedリソースの作成()
		{
			if( !base.b活性化してない )
			{
				this.txScore = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Score_number.png" ) );
                this.txScoreAdd_1P = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Score_number_Add.png" ) );
				base.OnManagedリソースの作成();
			}
		}
		public override void OnManagedリソースの解放()
		{
			if( !base.b活性化してない )
			{
				CDTXMania.tテクスチャの解放( ref this.txScore );
                CDTXMania.tテクスチャの解放( ref this.txScoreAdd_1P );
				base.OnManagedリソースの解放();
			}
		}

        protected void t小文字表示( int x, int y, string str, int mode )
        {
            foreach( char ch in str )
            {
                for( int i = 0; i < this.stFont.Length; i++ )
                {
                    if( this.stFont[ i ].ch == ch )
                    {
                        Rectangle rectangle = new Rectangle(this.stFont[i].pt.X, this.stFont[i].pt.Y, 24, 34);
                        switch( mode )
                        {
                            case 0:
                                if( this.txScore != null )
                                {
                                    this.txScore.t2D描画( CDTXMania.app.Device, x, y, rectangle );
                                }
                                break;
                            case 1:
                                if( this.txScoreAdd_1P != null )
                                {
                                    this.txScoreAdd_1P.t2D描画( CDTXMania.app.Device, x, y, rectangle );
                                }
                                break;
                        }
                        break;
                    }
                }
                x += 20;
            }
        }
	}
}
