/*
 * Decompiled with CFR 0.152.
 */
package com.japaricraft.japaricraftmod.mob;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlackCerulean
extends EntityMob {
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("japaricraftmod", "entitys/blackcerulean");
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityBlackCerulean.class, (DataSerializer)DataSerializers.field_187198_h);
    private float clientSideStandAnimation0;
    private float clientSideStandAnimation;
    private int warningSoundTicks;
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);

    public EntityBlackCerulean(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.9f, 3.8f);
        this.field_70728_aV = 20;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMeleeAndStompAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(160.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(28.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.5);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187764_dj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187760_dh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187758_dg;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.5f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_187596_cD, 1.1f, 1.0f);
            this.warningSoundTicks = 40;
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)Boolean.FALSE);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_175678_i(new BlockPos((Entity)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.clientSideStandAnimation0 = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? MathHelper.func_76131_a((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public void func_70665_d(DamageSource source, float amount) {
        super.func_70665_d(source, amount);
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    private boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    private void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    protected void func_70619_bc() {
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 8.0f);
        }
        super.func_70619_bc();
    }

    @SideOnly(value=Side.CLIENT)
    public float getStandingAnimationScale(float p_189795_1_) {
        return (this.clientSideStandAnimation0 + (this.clientSideStandAnimation - this.clientSideStandAnimation0) * p_189795_1_) / 6.0f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public class AIMeleeAndStompAttack
    extends EntityAIAttackMelee {
        public EntityBlackCerulean cerulean;

        public AIMeleeAndStompAttack(EntityBlackCerulean blackCerulean) {
            super((EntityCreature)blackCerulean, 1.05, true);
            this.cerulean = blackCerulean;
        }

        protected void func_190102_a(EntityLivingBase p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 40;
                if (EntityBlackCerulean.this.field_70146_Z.nextInt(8) == 0) {
                    int hitY = MathHelper.func_76128_c((double)(this.cerulean.func_174813_aQ().field_72338_b - 0.5));
                    int maxDistance = 6;
                    WorldServer world = (WorldServer)this.cerulean.field_70170_p;
                    this.cerulean.func_184185_a(SoundEvents.field_187539_bB, 2.0f, 1.0f + this.cerulean.func_70681_au().nextFloat() * 0.1f);
                    int distance = 3;
                    double spread = Math.PI * 2;
                    int arcLen = MathHelper.func_76143_f((double)((double)distance * spread));
                    double minY = this.cerulean.func_174813_aQ().field_72338_b;
                    double maxY = this.cerulean.func_174813_aQ().field_72337_e;
                    for (int i = 0; i < arcLen; ++i) {
                        IBlockState block;
                        int hitZ;
                        int hitX;
                        BlockPos pos;
                        double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread;
                        double vx = Math.cos(theta);
                        double vz = Math.sin(theta);
                        double px = this.cerulean.field_70165_t + vx * (double)distance;
                        double pz = this.cerulean.field_70161_v + vz * (double)distance;
                        float factor = 1.0f - (float)distance / 6.0f;
                        AxisAlignedBB selection = new AxisAlignedBB(px - 1.5, minY, pz - 1.5, px + 1.5, maxY, pz + 1.5);
                        List hit = world.func_72872_a(Entity.class, selection);
                        for (Entity entity : hit) {
                            if (entity == this.cerulean || entity instanceof EntityFallingBlock) continue;
                            if (entity instanceof EntityLivingBase) {
                                entity.func_70097_a(DamageSource.field_82729_p, factor * 5.0f + 1.0f);
                            }
                            double magnitude = world.field_73012_v.nextDouble() * 0.15 + 0.1;
                            entity.field_70159_w += vx * (double)factor * magnitude;
                            if (entity.field_70122_E) {
                                entity.field_70181_x += 0.1 + (double)factor * 0.15;
                            }
                            entity.field_70179_y += vz * (double)factor * magnitude;
                        }
                        if (world.field_73012_v.nextBoolean() && world.func_175623_d((pos = new BlockPos(hitX = MathHelper.func_76128_c((double)px), hitY, hitZ = MathHelper.func_76128_c((double)pz))).func_177984_a()) && (block = world.func_180495_p(pos)).func_185904_a() != Material.field_151579_a && block.func_185898_k() && block != Blocks.field_150357_h) {
                            EntityFallingBlock fallingBlock = new EntityFallingBlock((World)world, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
                            fallingBlock.field_70159_w = 0.0;
                            fallingBlock.field_70181_x = 0.4 + (double)factor * 0.2;
                            fallingBlock.field_70179_y = 0.0;
                            fallingBlock.field_145812_b = 2;
                            world.func_72838_d((Entity)fallingBlock);
                            world.func_175698_g(pos);
                            int amount = 6 + world.field_73012_v.nextInt(10);
                            int stateId = Block.func_176210_f((IBlockState)block);
                            while (amount-- > 0) {
                                double cx = px + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0;
                                double cy = this.cerulean.func_174813_aQ().field_72338_b + 0.1 + (double)world.field_73012_v.nextFloat() * 0.3;
                                double cz = pz + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0;
                                world.func_175739_a(EnumParticleTypes.BLOCK_CRACK, cx, cy, cz, 0, vx, 0.4 + (double)(world.field_73012_v.nextFloat() * 0.2f), vz, 1.0, new int[]{stateId});
                            }
                        }
                        if (!world.field_73012_v.nextBoolean()) continue;
                        int amount = world.field_73012_v.nextInt(5);
                        while (amount-- > 0) {
                            double velX = vx * 0.075;
                            double velY = (double)factor * 0.3 + 0.025;
                            double velZ = vz * 0.075;
                            world.func_175739_a(EnumParticleTypes.CLOUD, px + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, this.cerulean.func_174813_aQ().field_72338_b + 0.1 + (double)world.field_73012_v.nextFloat() * 1.5, pz + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, 0, velX, velY, velZ, 1.0, new int[0]);
                        }
                    }
                }
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
                EntityBlackCerulean.this.setStanding(false);
            } else if (p_190102_2_ <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    EntityBlackCerulean.this.setStanding(false);
                    this.field_75439_d = 40;
                }
                if (this.field_75439_d <= 10) {
                    EntityBlackCerulean.this.setStanding(true);
                    EntityBlackCerulean.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 40;
                EntityBlackCerulean.this.setStanding(false);
            }
        }

        public void func_75251_c() {
            EntityBlackCerulean.this.setStanding(false);
            super.func_75251_c();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 15.0f + attackTarget.field_70130_N;
        }
    }
}

