/* }EXEBhȄdˍ킹 */

#include "bootpack.h"
#include <stdio.h>

#define SHEET_USE		1

typedef void(*sheet_setx)(struct SHTCTL *ctl, struct SHEET *sht, unsigned int *buf, char *vram, int vx, int vy, int bx, int by);

sheet_setx put_pixelx;

struct SHTCTL *shtctl_init(struct MEMMAN *memman, unsigned char *vram, int xsize, int ysize)
{
	struct SHTCTL *ctl;
	int i;
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	if (binfo->vmode == 8) put_pixelx = sheet_set8;
	if (binfo->vmode == 16) put_pixelx = sheet_set16;
	if (binfo->vmode == 24) put_pixelx = sheet_set24;
	if (binfo->vmode == 32) put_pixelx = sheet_set32;
	
	ctl = (struct SHTCTL *) memman_alloc_4k(memman, sizeof (struct SHTCTL));
	if (ctl == 0) {
		goto err;
	}
	ctl->map = (unsigned char *) memman_alloc_4k(memman, xsize * ysize);
	if (ctl->map == 0) {
		memman_free_4k(memman, (int) ctl, sizeof (struct SHTCTL));
		goto err;
	}
	ctl->vram = vram;
	ctl->xsize = xsize;
	ctl->ysize = ysize;
	ctl->top = -1; /* V[g͈ꖇȂ */
	for (i = 0; i < MAX_SHEETS; i++) {
		ctl->sheets0[i].flags = 0; /* gp}[N */
		ctl->sheets0[i].ctl = ctl; /* L^ */
	}
err:
	return ctl;
}

struct SHEET *sheet_alloc(struct SHTCTL *ctl)
{
	struct SHEET *sht;
	int i;
	for (i = 0; i < MAX_SHEETS; i++) {
		if (ctl->sheets0[i].flags == 0) {
			sht = &ctl->sheets0[i];
			sht->flags = SHEET_USE; /* gp}[N */
			sht->height = -1; /* \ */
			sht->task = 0;	/* ŕ@\gȂ */
			return sht;
		}
	}
	return 0;	/* SẴV[ggp */
}

void sheet_setbuf(struct SHEET *sht, unsigned int *buf, int xsize, int ysize, int col_inv)
{
	sht->buf = buf;
	sht->bxsize = xsize;
	sht->bysize = ysize;
	sht->col_inv = col_inv;
	return;
}

void sheet_setbuf2(struct SHEET *sht, unsigned int buf_addr, int xsize, int ysize, int col_inv)
{
	struct CONSOLE *cons;
	cons = sht->task->cons;
	sht->buf = (unsigned int *)buf_addr;
	char debug[60];
	sprintf(debug, "sheet: \n sht->buf: 0x%08x\n buf_addr: 0x%08x\n", sht->buf, buf_addr);
	cons_putstr0(cons, debug);
	sht->bxsize = xsize;
	sht->bysize = ysize;
	sht->col_inv = col_inv;
	return;
}

void sheet_refreshmap(struct SHTCTL *ctl, int vx0, int vy0, int vx1, int vy1, int h0)
{
	int h, bx, by, vx, vy, bx0, by0, bx1, by1, sid4, *p;
	unsigned int *buf;
	unsigned char sid, *map = ctl->map;
	struct SHEET *sht;
	if (vx0 < 0) { vx0 = 0; }
	if (vy0 < 0) { vy0 = 0; }
	if (vx1 > ctl->xsize) { vx1 = ctl->xsize; }
	if (vy1 > ctl->ysize) { vy1 = ctl->ysize; }
	for (h = h0; h <= ctl->top; h++) {
		sht = ctl->sheets[h];
		sid = sht - ctl->sheets0; /* ԒnZĂԍƂėp */
		buf = sht->buf;
		bx0 = vx0 - sht->vx0;
		by0 = vy0 - sht->vy0;
		bx1 = vx1 - sht->vx0;
		by1 = vy1 - sht->vy0;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sht->bxsize) { bx1 = sht->bxsize; }
		if (by1 > sht->bysize) { by1 = sht->bysize; }
		if (sht->col_inv == -1) {
			if ((sht->vx0 & 3) == 0 && (bx0 & 3) == 0 && (bx1 & 3) == 0) {
				/* FȂp̍Łi4oCg^j */
				bx1 = (bx1 - bx0) / 4; /* MOV */
				sid4 = sid | sid << 8 | sid << 16 | sid << 24;
				for (by = by0; by < by1; by++) {
					vy = sht->vy0 + by;
					vx = sht->vx0 + bx0;
					p = (int *) &map[vy * ctl->xsize + vx];
					for (bx = 0; bx < bx1; bx++) {
						p[bx] = sid4;
					}
				}
			} else {
				/* FȂp̍Łi1oCg^j */
				for (by = by0; by < by1; by++) {
					vy = sht->vy0 + by;
					for (bx = bx0; bx < bx1; bx++) {
						vx = sht->vx0 + bx;
						map[vy * ctl->xsize + vx] = sid;
					}
				}
			}
		} else {
			/* F̈ʔ */
			for (by = by0; by < by1; by++) {
				vy = sht->vy0 + by;
				for (bx = bx0; bx < bx1; bx++) {
					vx = sht->vx0 + bx;
					if (buf[by * sht->bxsize + bx] != sht->col_inv) {
						map[vy * ctl->xsize + vx] = sid;
					}
				}
			}
		}
	}
	return;
}

void sheet_set8(struct SHTCTL *ctl, struct SHEET *sht, unsigned int *buf, char *vram, int vx, int vy, int bx, int by) {
	int r, g, b;
	
	col2rgb(buf[by * sht->bxsize + bx], &r, &g, &b);
	vram[vy * ctl->xsize + vx] = rgb2pal_8(r, g, b, bx, by);
}

void sheet_set16(struct SHTCTL *ctl, struct SHEET *sht, unsigned int *buf, char *vram, int vx, int vy, int bx, int by) {
	int r, g, b;
	
	col2rgb(buf[by * sht->bxsize + bx], &r, &g, &b);
	((short *)vram)[vy * ctl->xsize + vx] = rgb2pal_16(r, g, b);
}

void sheet_set24(struct SHTCTL *ctl, struct SHEET *sht, unsigned int *buf, char *vram, int vx, int vy, int bx, int by) {
	int r, g, b;
	int v = (vy * ctl->xsize + vx) * 3;
	
	col2rgb(buf[by * sht->bxsize + bx], &r, &g, &b);
	vram[v + 0] = b;
	vram[v + 1] = g;
	vram[v + 2] = r;
}

void sheet_set32(struct SHTCTL *ctl, struct SHEET *sht, unsigned int *buf, char *vram, int vx, int vy, int bx, int by) {
	((int *)vram)[vy * ctl->xsize + vx] = buf[by * sht->bxsize + bx];
}

void sheet_refreshsub(struct SHTCTL *ctl, int vx0, int vy0, int vx1, int vy1, int h0, int h1)
{
	int h, bx, by, vx, vy, bx0, by0, bx1, by1;
	unsigned int *buf;
	unsigned char *vram = ctl->vram, *map = ctl->map, sid;
	struct SHEET *sht;
	
	/* refresh͈͂ʊOɂ͂ݏoĂ␳ */
	if (vx0 < 0) { vx0 = 0; }
	if (vy0 < 0) { vy0 = 0; }
	if (vx1 > ctl->xsize) { vx1 = ctl->xsize; }
	if (vy1 > ctl->ysize) { vy1 = ctl->ysize; }
	for (h = h0; h <= h1; h++) {
		sht = ctl->sheets[h];
		buf = sht->buf;
		sid = sht - ctl->sheets0;
		/* vx0`vy1gāAbx0`by1tZ */
		bx0 = vx0 - sht->vx0;
		by0 = vy0 - sht->vy0;
		bx1 = vx1 - sht->vx0;
		by1 = vy1 - sht->vy0;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sht->bxsize) { bx1 = sht->bxsize; }
		if (by1 > sht->bysize) { by1 = sht->bysize; }
		for (by = by0; by < by1; by++) {
			vy = sht->vy0 + by;
			for (bx = bx0; bx < bx1; bx++) {
				vx = sht->vx0 + bx;
				if (map[vy * ctl->xsize + vx] == sid) {
					put_pixelx(ctl,sht,buf,vram,vx,vy,bx,by);
				}
			}
		}
	}
	return;
}

void sheet_updown(struct SHEET *sht, int height)
{
	struct SHTCTL *ctl = sht->ctl;
	int h, old = sht->height; /* ݒO̍L */

	/* w肪Ⴗ⍂AC */
	if (height > ctl->top + 1) {
		height = ctl->top + 1;
	}
	if (height < -1) {
		height = -1;
	}
	sht->height = height; /* ݒ */

	/* ȉ͎sheets[]̕בւ */
	if (old > height) {	/* ȑOႭȂ */
		if (height >= 0) {
			/* Ԃ̂̂グ */
			for (h = old; h > height; h--) {
				ctl->sheets[h] = ctl->sheets[h - 1];
				ctl->sheets[h]->height = h;
			}
			ctl->sheets[height] = sht;
			sheet_refreshmap(ctl, sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, height + 1);
			sheet_refreshsub(ctl, sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, height + 1, old);
		} else {	/* \ */
			if (ctl->top > old) {
				/* ɂȂĂ̂낷 */
				for (h = old; h < ctl->top; h++) {
					ctl->sheets[h] = ctl->sheets[h + 1];
					ctl->sheets[h]->height = h;
				}
			}
			ctl->top--; /* \̉̂ŁAԏ̍ */
			sheet_refreshmap(ctl, sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, 0);
			sheet_refreshsub(ctl, sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, 0, old - 1);
		}
	} else if (old < height) {	/* ȑOȂ */
		if (old >= 0) {
			/* Ԃ̂̂ */
			for (h = old; h < height; h++) {
				ctl->sheets[h] = ctl->sheets[h + 1];
				ctl->sheets[h]->height = h;
			}
			ctl->sheets[height] = sht;
		} else {	/* \Ԃ\Ԃ */
			/* ɂȂ̂グ */
			for (h = ctl->top; h >= height; h--) {
				ctl->sheets[h + 1] = ctl->sheets[h];
				ctl->sheets[h + 1]->height = h + 1;
			}
			ctl->sheets[height] = sht;
			ctl->top++; /* \̉̂ŁAԏ̍ */
		}
		sheet_refreshmap(ctl, sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, height);
		sheet_refreshsub(ctl, sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, height, height);
	}
	return;
}

void sheet_refresh(struct SHEET *sht, int bx0, int by0, int bx1, int by1)
{
	if (sht->height >= 0) { /* \ȂAV̏ɉĉʂ` */
		sheet_refreshsub(sht->ctl, sht->vx0 + bx0, sht->vy0 + by0, sht->vx0 + bx1, sht->vy0 + by1, sht->height, sht->height);
	}
	return;
}

void sheet_slide(struct SHEET *sht, int vx0, int vy0)
{
	struct SHTCTL *ctl = sht->ctl;
	int old_vx0 = sht->vx0, old_vy0 = sht->vy0;
	sht->vx0 = vx0;
	sht->vy0 = vy0;
	if (sht->height >= 0) { /* \ȂAV̏ɉĉʂ` */
		sheet_refreshmap(ctl, old_vx0, old_vy0, old_vx0 + sht->bxsize, old_vy0 + sht->bysize, 0);
		sheet_refreshmap(ctl, vx0, vy0, vx0 + sht->bxsize, vy0 + sht->bysize, sht->height);
		sheet_refreshsub(ctl, old_vx0, old_vy0, old_vx0 + sht->bxsize, old_vy0 + sht->bysize, 0, sht->height - 1);
		sheet_refreshsub(ctl, vx0, vy0, vx0 + sht->bxsize, vy0 + sht->bysize, sht->height, sht->height);
	}
	return;
}

void sheet_free(struct SHEET *sht)
{
	if (sht->height >= 0) {
		sheet_updown(sht, -1); /* \Ȃ܂\ɂ */
	}
	sht->flags = 0; /* gp}[N */
	return;
}
