#include "bootpack.h"
#include <string.h>

struct IME {
	int halfnum;
	int kananum;
	char half[8];
	unsigned char kana[16];
};

extern struct SHEET *key_win;
extern struct SHTCTL *shtctl;
struct SHEET *sht_ime;
struct IME ime_table[] = {
	{ 1, 2, "a  ", "" },
	{ 1, 2, "i  ", "" },
	{ 1, 2, "u  ", "" },
	{ 1, 2, "e  ", "" },
	{ 1, 2, "o  ", "" },
	{ 2, 2, "ka ", "" },
	{ 2, 2, "ki ", "" },
	{ 2, 2, "ku ", "" },
	{ 2, 2, "ke ", "" },
	{ 2, 2, "ko ", "" },
	{ 2, 2, "sa ", "" },
	{ 2, 2, "si ", "" },
	{ 2, 2, "su ", "" },
	{ 2, 2, "se ", "" },
	{ 2, 2, "so ", "" },
	{ 2, 2, "ta ", "" },
	{ 2, 2, "ti ", "" },
	{ 2, 2, "tu ", "" },
	{ 2, 2, "te ", "" },
	{ 2, 2, "to ", "" },
	{ 2, 2, "na ", "" },
	{ 2, 2, "ni ", "" },
	{ 2, 2, "nu ", "" },
	{ 2, 2, "ne ", "" },
	{ 2, 2, "no ", "" },
	{ 2, 2, "ha ", "" },
	{ 2, 2, "hi ", "" },
	{ 2, 2, "hu ", "" },
	{ 2, 2, "he ", "" },
	{ 2, 2, "ho ", "" },
	{ 2, 2, "ma ", "" },
	{ 2, 2, "mi ", "" },
	{ 2, 2, "mu ", "" },
	{ 2, 2, "me ", "" },
	{ 2, 2, "mo ", "" },
	{ 2, 2, "ya ", "" },
	{ 2, 2, "yu ", "" },
	{ 2, 2, "yo ", "" },
	{ 2, 2, "ra ", "" },
	{ 2, 2, "ri ", "" },
	{ 2, 2, "ru ", "" },
	{ 2, 2, "re ", "" },
	{ 2, 2, "ro ", "" },
	{ 2, 2, "wa ", "" },
	{ 2, 2, "wo ", "" },
	{ 2, 2, "nn ", "" },
	{ 2, 2, "da ", "" },
	{ 2, 2, "di ", "" },
	{ 2, 2, "du ", "" },
	{ 2, 2, "de ", "" },
	{ 2, 2, "do ", "" },
	{ 2, 2, "pa ", "" },
	{ 2, 2, "pi ", "" },
	{ 2, 2, "pu ", "" },
	{ 2, 2, "pe ", "y" },
	{ 2, 2, "po ", "" },
	{ 2, 2, "ba ", "" },
	{ 2, 2, "bi ", "" },
	{ 2, 2, "bu ", "" },
	{ 2, 2, "be ", "" },
	{ 2, 2, "bo ", "" },
	{ 2, 2, "ga ", "" },
	{ 2, 2, "gi ", "" },
	{ 2, 2, "gu ", "" },
	{ 2, 2, "ge ", "" },
	{ 2, 2, "go ", "" },
	{ 2, 2, "za ", "" },
	{ 2, 2, "zi ", "" },
	{ 2, 2, "zu ", "" },
	{ 2, 2, "ze ", "" },
	{ 2, 2, "zo ", "" },
	{ 2, 2, "la ", "" },
	{ 2, 2, "li ", "" },
	{ 2, 2, "lu ", "" },
	{ 2, 2, "le ", "" },
	{ 2, 2, "lo ", "" },
	{ 3, 2, "lya", "" },
	{ 3, 2, "lyu", "" },
	{ 3, 2, "lyo", "" },
	{ 3, 2, "ltu", "" },
	{ 4, 12, "ktkr", "(߁)!!" },
	{ 6, 12, "sbn", "(LEցEM)" },
	{ 6, 12, "skn", "(MEցEL)" },
	{ 3, 4, "kya", "" },
	{ 3, 4, "kyi", "" },
	{ 3, 4, "kyu", "" },
	{ 3, 4, "kye", "" },
	{ 3, 4, "kyo", "" },
	{ 3, 4, "sya", "" },
	{ 3, 4, "syi", "" },
	{ 3, 4, "syu", "" },
	{ 3, 4, "sye", "" },
	{ 3, 4, "syo", "" },
	{ 3, 4, "tya", "" },
	{ 3, 4, "tyi", "" },
	{ 3, 4, "tyu", "" },
	{ 3, 4, "tye", "" },
	{ 3, 4, "tyo", "" },
	{ 3, 4, "nya", "ɂ" },
	{ 3, 4, "nyi", "ɂ" },
	{ 3, 4, "nyu", "ɂ" },
	{ 3, 4, "nye", "ɂ" },
	{ 3, 4, "nyo", "ɂ" },
	{ 3, 4, "hya", "Ђ" },
	{ 3, 4, "hyi", "Ђ" },
	{ 3, 4, "hyu", "Ђ" },
	{ 3, 4, "hye", "Ђ" },
	{ 3, 4, "hyo", "Ђ" },
	{ 3, 4, "mya", "݂" },
	{ 3, 4, "myi", "݂" },
	{ 3, 4, "myu", "݂" },
	{ 3, 4, "mye", "݂" },
	{ 3, 4, "myo", "݂" },
	{ 3, 4, "rya", "" },
	{ 3, 4, "ryi", "股" },
	{ 3, 4, "ryu", "" },
	{ 3, 4, "rye", "肥" },
	{ 3, 4, "ryo", "" },
	{ 3, 4, "zya", "" },
	{ 3, 4, "zyi", "" },
	{ 3, 4, "zyu", "" },
	{ 3, 4, "zye", "" },
	{ 3, 4, "zyo", "" },
	{ 3, 4, "gya", "" },
	{ 3, 4, "gyi", "" },
	{ 3, 4, "gyu", "" },
	{ 3, 4, "gye", "" },
	{ 3, 4, "gyo", "" },
	{ 3, 4, "jya", "" },
	{ 3, 4, "jyi", "" },
	{ 3, 4, "jyu", "" },
	{ 3, 4, "jye", "" },
	{ 3, 4, "jyo", "" },
	{ 3, 4, "bya", "т" },
	{ 3, 4, "byi", "т" },
	{ 3, 4, "byu", "т" },
	{ 3, 4, "bye", "т" },
	{ 3, 4, "byo", "т" },
	{ 1, 2, ".  ", "B" },
	{ 1, 2, ",  ", "A" },
	{ 1, 2, "-  ", "[" },
	{ 1, 2, "^  ", "O" },
	{ 1, 2, "/  ", "E" },
	{ 1, 2, ";  ", "G" },
	{ 1, 2, ":  ", "F" },
	{ 1, 2, "[  ", "u" },
	{ 1, 2, "]  ", "v" },
	{ 1, 2, "\  ", "" },
	{ 1, 2, "@  ", "" },
	{ 1, 2, "1  ", "P" },
	{ 1, 2, "2  ", "Q" },
	{ 1, 2, "3  ", "R" },
	{ 1, 2, "4  ", "S" },
	{ 1, 2, "5  ", "T" },
	{ 1, 2, "6  ", "U" },
	{ 1, 2, "7  ", "V" },
	{ 1, 2, "8  ", "W" },
	{ 1, 2, "9  ", "X" },
	{ 1, 2, "0  ", "O" },
	{ 1, 2, "!  ", "I" },
	{ 1, 2, "\"  ", "h" },
	{ 1, 2, "#  ", "" },
	{ 1, 2, "$  ", "" },
	{ 1, 2, "%  ", "" },
	{ 1, 2, "&  ", "" },
	{ 1, 2, "\'  ", "f" },
	{ 1, 2, "(  ", "i" },
	{ 1, 2, ")  ", "j" },
	{ 1, 2, "=  ", "" },
	{ 1, 2, "~  ", "`" },
	{ 1, 2, "|  ", "b" },
	{ 1, 2, "`  ", "e" },
	{ 1, 2, "{  ", "o" },
	{ 1, 2, "}  ", "p" },
	{ 1, 2, "*  ", "" },
	{ 1, 2, "+  ", "{" },
	{ 1, 2, "_  ", "Q" },
	{ 1, 2, "?  ", "H" },
	{ 1, 2, ">  ", "" },
	{ 1, 2, "<  ", "" },
	{ 1, 2, "A  ", "`" },
	{ 1, 2, "B  ", "a" },
	{ 1, 2, "C  ", "b" },
	{ 1, 2, "D  ", "c" },
	{ 1, 2, "E  ", "d" },
	{ 1, 2, "F  ", "e" },
	{ 1, 2, "G  ", "f" },
	{ 1, 2, "H  ", "g" },
	{ 1, 2, "I  ", "h" },
	{ 1, 2, "J  ", "i" },
	{ 1, 2, "K  ", "j" },
	{ 1, 2, "L  ", "k" },
	{ 1, 2, "M  ", "l" },
	{ 1, 2, "N  ", "m" },
	{ 1, 2, "O  ", "n" },
	{ 1, 2, "P  ", "o" },
	{ 1, 2, "Q  ", "p" },
	{ 1, 2, "R  ", "q" },
	{ 1, 2, "S  ", "r" },
	{ 1, 2, "T  ", "s" },
	{ 1, 2, "U  ", "t" },
	{ 1, 2, "V  ", "u" },
	{ 1, 2, "W  ", "v" },
	{ 1, 2, "X  ", "w" },
	{ 1, 2, "Y  ", "x" },
	{ 1, 2, "Z  ", "y" },
};

struct IME ime_ank[] = {
	{ 1, 2, "A  ", "`" },
	{ 1, 2, "B  ", "a" },
	{ 1, 2, "C  ", "b" },
	{ 1, 2, "D  ", "c" },
	{ 1, 2, "E  ", "d" },
	{ 1, 2, "F  ", "e" },
	{ 1, 2, "G  ", "f" },
	{ 1, 2, "H  ", "g" },
	{ 1, 2, "I  ", "h" },
	{ 1, 2, "J  ", "i" },
	{ 1, 2, "K  ", "j" },
	{ 1, 2, "L  ", "k" },
	{ 1, 2, "M  ", "l" },
	{ 1, 2, "N  ", "m" },
	{ 1, 2, "O  ", "n" },
	{ 1, 2, "P  ", "o" },
	{ 1, 2, "Q  ", "p" },
	{ 1, 2, "R  ", "q" },
	{ 1, 2, "S  ", "r" },
	{ 1, 2, "T  ", "s" },
	{ 1, 2, "U  ", "t" },
	{ 1, 2, "V  ", "u" },
	{ 1, 2, "W  ", "v" },
	{ 1, 2, "X  ", "w" },
	{ 1, 2, "Y  ", "x" },
	{ 1, 2, "Z  ", "y" },
	{ 1, 2, "a  ", "" },
	{ 1, 2, "b  ", "" },
	{ 1, 2, "c  ", "" },
	{ 1, 2, "d  ", "" },
	{ 1, 2, "e  ", "" },
	{ 1, 2, "f  ", "" },
	{ 1, 2, "g  ", "" },
	{ 1, 2, "h  ", "" },
	{ 1, 2, "i  ", "" },
	{ 1, 2, "j  ", "" },
	{ 1, 2, "k  ", "" },
	{ 1, 2, "l  ", "" },
	{ 1, 2, "m  ", "" },
	{ 1, 2, "n  ", "" },
	{ 1, 2, "o  ", "" },
	{ 1, 2, "p  ", "" },
	{ 1, 2, "q  ", "" },
	{ 1, 2, "r  ", "" },
	{ 1, 2, "s  ", "" },
	{ 1, 2, "t  ", "" },
	{ 1, 2, "u  ", "" },
	{ 1, 2, "v  ", "" },
	{ 1, 2, "w  ", "" },
	{ 1, 2, "x  ", "" },
	{ 1, 2, "y  ", "" },
	{ 1, 2, "z  ", "" },
	{ 1, 2, "-  ", "[" },
	{ 1, 2, "^  ", "O" },
	{ 1, 2, "/  ", "E" },
	{ 1, 2, ";  ", "G" },
	{ 1, 2, ":  ", "F" },
	{ 1, 2, "[  ", "u" },
	{ 1, 2, "]  ", "v" },
	{ 1, 2, "\  ", "" },
	{ 1, 2, "@  ", "" },
	{ 1, 2, "1  ", "P" },
	{ 1, 2, "2  ", "Q" },
	{ 1, 2, "3  ", "R" },
	{ 1, 2, "4  ", "S" },
	{ 1, 2, "5  ", "T" },
	{ 1, 2, "6  ", "U" },
	{ 1, 2, "7  ", "V" },
	{ 1, 2, "8  ", "W" },
	{ 1, 2, "9  ", "X" },
	{ 1, 2, "0  ", "O" },
	{ 1, 2, "!  ", "I" },
	{ 1, 2, "\"  ", "h" },
	{ 1, 2, "#  ", "" },
	{ 1, 2, "$  ", "" },
	{ 1, 2, "%  ", "" },
	{ 1, 2, "&  ", "" },
	{ 1, 2, "\'  ", "f" },
	{ 1, 2, "(  ", "i" },
	{ 1, 2, ")  ", "j" },
	{ 1, 2, "=  ", "" },
	{ 1, 2, "~  ", "`" },
	{ 1, 2, "|  ", "b" },
	{ 1, 2, "`  ", "e" },
	{ 1, 2, "{  ", "o" },
	{ 1, 2, "}  ", "p" },
	{ 1, 2, "*  ", "" },
	{ 1, 2, "+  ", "{" },
	{ 1, 2, "_  ", "Q" },
	{ 1, 2, "?  ", "H" },
	{ 1, 2, ">  ", "" },
	{ 1, 2, "<  ", "" },
};

void ime_fifoputs(unsigned char *s)
{
	if(s[0] != 0 && key_win != 0) {
		for(;*s != 0;s++) {
			fifo32_put_io(&key_win->task->fifo, *s + 256);
		}
	}
}

void ime_openwindow(void)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	unsigned int *buf;
	
	sht_ime = sheet_alloc(shtctl);
	buf = (unsigned int *) memman_alloc_4k(memman, 800 * 32 * 4);
	memset(buf, COL8_FFFFFF, 800 * 32 * 4);
	sheet_setbuf(sht_ime, buf, 800, 32, -1); /* FȂ */
	sheet_slide(sht_ime, 0, 0);
	sheet_updown(sht_ime, shtctl->top);
	sht_ime->act = 1;
	sht_ime->flag2 = 0;
}

void ime_closewindow(void)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	
	memman_free_4k(memman, sht_ime->buf,  800 * 16);
	sheet_free(sht_ime);
}

int ime_searchkana(char *half)
{
	int i;
	
	for(i = 0; i < sizeof(ime_table) / sizeof(struct IME); i++) {
		if(strncmp(half, ime_table[i].half, ime_table[i].halfnum) == 0) return i;
	}
	
	return -1;
}

int ime_searchank(char *half)
{
	int i;
	
	for(i = 0; i < sizeof(ime_ank) / sizeof(struct IME); i++) {
		if(strncmp(half, ime_ank[i].half, ime_ank[i].halfnum) == 0) return i;
	}
	
	return -1;
}

void ime_task(void)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct TASK *task = task_now();
	int i;
	int j;
	unsigned short kata;
	int index;
	int ank_ime = 0;
	unsigned char string[256];
	char hs[256];
	char han[256];
	unsigned char a, b;
	int hanp = 0;
	int cur_x = 0;
	int open_ime = 0;
	
	han[3] = 0;
	hs[0] = 0;
	
	task->langmode = 1;
	//floppy_init(0x3f0, 0);
	
	for(;;) {
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
		} else {
			i = fifo32_get(&task->fifo);
			
			if (256 <= i && i <= 511) {
				if(i == 0x08 + 256) {
					if(cur_x > 0) cur_x -= 16;
					memcpy(string + (cur_x / 8), "@", 3);
					memset(han, 0x00, 256);
					memset(hs, 0x00, 256);
				} else if(i == 0x0a + 256) {
					ime_fifoputs(string);
					cur_x = 0;
					hanp = 0;
					ank_ime = 0;
					memset(string, 0x00, 256);
					memset(han, 0x00, 256);
				} else if(i == 0xff + 256) {
					for(j = 0; ((unsigned short *)string)[j] != 0; j++) {
						//kata = string[j+1] | (string[j] << 8);
						kata = ((unsigned short *)string)[j];
						//sprintf(string,"0x%04x",kata);
						a = kata >> 8;
						b = kata & 0xff;
						kata = (b << 8) | a;
						if(kata <= 0x82f1 && kata >= 0x829f) kata += 0xa1;
						a = kata >> 8;
						b = kata & 0xff;
						kata = (b << 8) | a;
						//string[j+1] = kata >> 8;
						//string[j] = kata & 0xff;
						((unsigned short *)string)[j] = kata;
					}
				} else {
					if('A' <= i - 256 && i - 256 <= 'Z') {
						ank_ime = 1;
					}
					char n[128];
					n[0] = i - 256;
					n[1] = 0;
					strcat(hs,n);
					han[hanp] = i - 256;
					hanp++;
					if(hanp > 255) {
						hanp = 0;
						memset(han, 0x00, 256);
					}
					index = ime_searchkana(han);
					if(ank_ime == 1) index = ime_searchank(han);
					if(index != -1) {
						memset(hs,0,256);
						sheet_refresh(sht_ime, 0, 0, 800, 32);
						strncpy(string + (cur_x / 8), ime_table[index].kana, ime_table[index].kananum);
						if(ank_ime == 1) strncpy(string + (cur_x / 8), ime_ank[index].kana, ime_ank[index].kananum);
						hanp = 0;
						memset(han, 0x00, 256);
						cur_x += 8 * ime_table[index].kananum;
					}
				}
			} else if(i == 2) {
				memset(string, 0x00, 256);
				ime_openwindow();
				string[0] = 0;
				hanp = 0;
				open_ime = 1;
			} else if(i == 1) {
				memset(string, 0x00, 256);
				ime_closewindow();
				string[0] = 0;
				hanp = 0;
				cur_x = 0;
				open_ime = 0;
				ank_ime = 0;
			}
			if(open_ime == 1) {
				boxfill8(sht_ime->buf, sht_ime->bxsize, COL8_FFFFFF, 0, 0, 799, 31);
				putfonts8_asc(sht_ime->buf, sht_ime->bxsize, 0, 0, COL8_000000, string);
				putfonts8_asc(sht_ime->buf, sht_ime->bxsize, 0, 15, COL8_000000, hs);
				sheet_refresh(sht_ime, 0, 0, 800, 32);
			}
		}
	}
}
