#include "apilib.h"
#include <stdio.h>		/* sprintf */

int strtol(char *s, char **endp, int base);	/* W֐istdlib.hj */

char *skipspace(char *p);
int getnum(char **pp, int priority);

#define INVALID		-0x7fffffff

void HariMain(void)
{
	int win;
	int buf[256 * 151];
	int bt[15];
	int btc[15];
	char lcd[256];
	int lcdp = 0;
	int lcdx = 10;
	int lcdy = 26;
	int i = 0;
	int addr = 0;
	int btcf[15];
	int calc = 0;
	int resf = 0;
	int key = 0;
	static char bt_table[15] = {
		'1', '2', '3',
		'4', '5', '6',
		'7', '8', '9',
		'0', '=',
		'+', '-', '*', '/'
	};
	win = api_openwin(buf, 256, 150, -1, "guicalc");
	api_boxfilwin(win, 8, 24, 247, 43, api_getint(0));
	api_boxfilwin(win, 9, 25, 246, 42, api_getint(7));
	bt[0] = api_makebutton(win + 1,   8,  51,  71,  70, "1");
 	bt[1] = api_makebutton(win + 1,  76,  51, 139,  70, "2");
 	bt[2] = api_makebutton(win + 1, 144,  51, 208,  70, "3");
	bt[3] = api_makebutton(win + 1,   8,  75,  71,  94, "4");
	bt[4] = api_makebutton(win + 1,  76,  75, 139,  94, "5");
	bt[5] = api_makebutton(win + 1, 144,  75, 208,  94, "6");
	bt[6] = api_makebutton(win + 1,   8,  99,  71, 118, "7");
	bt[7] = api_makebutton(win + 1,  76,  99, 139, 118, "8");
	bt[8] = api_makebutton(win + 1, 144,  99, 208, 118, "9");
	bt[9] = api_makebutton(win + 1,   8, 123, 139, 142, "0");
	bt[10] = api_makebutton(win + 1,144, 123, 207, 142, "=");
	bt[11] = api_makebutton(win + 1,212,  51, 247,  70, "+");
	bt[12] = api_makebutton(win + 1,212,  75, 247,  94, "-");
	bt[13] = api_makebutton(win + 1,212,  99, 247, 118, "*");
	bt[14] = api_makebutton(win + 1,212, 124, 247, 142, "/");
	lcd[0] = '0';
	lcd[1] = 0;
	for (;;) {
		api_boxfilwin(win + 1, 8, 24, 247, 43, api_getint(0));
		api_boxfilwin(win + 1, 9, 25, 246, 42, api_getint(7));
		bt[0] = api_makebutton(win + 1,   8,  51,  71,  70, "1");
		btc[0] = api_getbtc(bt[0], win + 1);
		bt[1] = api_makebutton(win + 1,  76,  51, 139,  70, "2");
		btc[1] = api_getbtc(bt[0], win + 1);
		bt[2] = api_makebutton(win + 1, 144,  51, 208,  70, "3");
		btc[2] = api_getbtc(bt[0], win + 1);
		bt[3] = api_makebutton(win + 1,   8,  75,  71,  94, "4");
		btc[3] = api_getbtc(bt[0], win + 1);
		bt[4] = api_makebutton(win + 1,  76,  75, 139,  94, "5");
		btc[4] = api_getbtc(bt[0], win + 1);
		bt[5] = api_makebutton(win + 1, 144,  75, 208,  94, "6");
		btc[5] = api_getbtc(bt[0], win + 1);
		bt[6] = api_makebutton(win + 1,   8,  99,  71, 118, "7");
		btc[6] = api_getbtc(bt[0], win + 1);
		bt[7] = api_makebutton(win + 1,  76,  99, 139, 118, "8");
		btc[7] = api_getbtc(bt[0], win + 1);
		bt[8] = api_makebutton(win + 1, 144,  99, 208, 118, "9");
		btc[8] = api_getbtc(bt[0], win + 1);
		bt[9] = api_makebutton(win + 1,   8, 123, 139, 142, "0");
		btc[9] = api_getbtc(bt[0], win + 1);
		bt[10] = api_makebutton(win + 1,144, 123, 207, 142, "=");
		btc[10] = api_getbtc(bt[0], win + 1);
		bt[11] = api_makebutton(win + 1,212,  51, 247,  70, "+");
		btc[11] = api_getbtc(bt[0], win + 1);
		bt[12] = api_makebutton(win + 1,212,  75, 247,  94, "-");
		btc[12] = api_getbtc(bt[0], win + 1);
		bt[13] = api_makebutton(win + 1,212,  99, 247, 118, "*");
		btc[13] = api_getbtc(bt[0], win + 1);
		bt[14] = api_makebutton(win + 1,212, 124, 247, 142, "/");
		btc[14] = api_getbtc(bt[0], win + 1);

		key = api_getkey(0);

		if(api_getkey(0) == 0x08 && lcdp > 0) {
			lcdp--;
			lcd[lcdp] = 0;
		}

		if(lcd[0] == 0) {
			lcd[0] = '0';
		}

		if(btc[0] != 0 || key == bt_table[0]) {
			if(btcf[0] == 0) {
				lcd[lcdp] = bt_table[0];
				lcdp++;
			}
			btcf[0] = 1;
		} else if(btc[1] != 0 || key == bt_table[1]) {
			if(btcf[1] == 0) {
				lcd[lcdp] = bt_table[1];
				lcdp++;
			}
			btcf[1] = 1;
		} else if(btc[2] != 0 || key == bt_table[2]) {
			if(btcf[2] == 0) {
				lcd[lcdp] = bt_table[2];
				lcdp++;
			}
			btcf[2] = 1;
		} else if(btc[3] != 0 || key == bt_table[3]) {
			if(btcf[3] == 0) {
				lcd[lcdp] = bt_table[3];
				lcdp++;
			}
			btcf[3] = 1;
		} else if(btc[4] != 0 || key == bt_table[4]) {
			if(btcf[4] == 0) {
				lcd[lcdp] = bt_table[4];
				lcdp++;
			}
			btcf[4] = 1;
		} else if(btc[5] != 0 || key == bt_table[5]) {
			if(btcf[5] == 0) {
				lcd[lcdp] = bt_table[5];
				lcdp++;
			}
			btcf[5] = 1;
		} else if(btc[6] != 0 || key == bt_table[6]) {
			if(btcf[6] == 0) {
				lcd[lcdp] = bt_table[6];
				lcdp++;
			}
			btcf[6] = 1;
		} else if(btc[7] != 0 || key == bt_table[7]) {
			if(btcf[7] == 0) {
				lcd[lcdp] = bt_table[7];
				lcdp++;
			}
			btcf[7] = 1;
		} else if(btc[8] != 0 || key == bt_table[8]) {
			if(btcf[8] == 0) {
				lcd[lcdp] = bt_table[8];
				lcdp++;
			}
			btcf[8] = 1;
		} else if(btc[9] != 0 || key == bt_table[9]) {
			if(btcf[9] == 0) {
				lcd[lcdp] = bt_table[9];
				lcdp++;
			}
			btcf[9] = 1;
		} else if(btc[10] != 0 || key == 0x0a) {
			addr = &lcd;
			calc = getnum(&addr, 9);
			sprintf(lcd, "%d(0x%08X)",calc, calc);
			resf = 1;
		} else if(btc[11] != 0 || key == bt_table[11]) {
			if(btcf[11] == 0) {
				lcd[lcdp] = bt_table[11];
				lcdp++;
			}
			btcf[11] = 1;
		} else if(btc[12] != 0 || key == bt_table[12]) {
			if(btcf[12] == 0) {
				lcd[lcdp] = bt_table[12];
				lcdp++;
			}
			btcf[12] = 1;
		} else if(btc[13] != 0 || key == bt_table[13]) {
			if(btcf[13] == 0) {
				lcd[lcdp] = bt_table[13];
				lcdp++;
			}
			btcf[13] = 1;
		} else if(btc[14] != 0 || key == bt_table[14]) {
			if(btcf[14] == 0) {
				lcd[lcdp] = bt_table[14];
				lcdp++;
			}
			btcf[14] = 1;
		} else {
			for(i = 0;i < 16;i++) {
				btcf[i - 1] = 0;
			}
		}
		api_putstrwin(win + 1, lcdx, lcdy, api_getint(0), 30, lcd);
		api_refreshwin(win, 0, 0, 256, 150);

		if(resf == 1) {
			api_boxfilwin(win + 1, 8, 24, 247, 43, api_getint(0));
			api_boxfilwin(win + 1, 9, 25, 246, 42, api_getint(7));
			bt[0] = api_makebutton(win + 1,   8,  51,  71,  70, "1");
			bt[1] = api_makebutton(win + 1,  76,  51, 139,  70, "2");
			bt[2] = api_makebutton(win + 1, 144,  51, 208,  70, "3");
			bt[3] = api_makebutton(win + 1,   8,  75,  71,  94, "4");
			bt[4] = api_makebutton(win + 1,  76,  75, 139,  94, "5");
			bt[5] = api_makebutton(win + 1, 144,  75, 208,  94, "6");
			bt[6] = api_makebutton(win + 1,   8,  99,  71, 118, "7");
			bt[7] = api_makebutton(win + 1,  76,  99, 139, 118, "8");
			bt[8] = api_makebutton(win + 1, 144,  99, 208, 118, "9");
			bt[9] = api_makebutton(win + 1,   8, 123, 139, 142, "0");
			bt[10] = api_makebutton(win + 1,144, 123, 207, 142, "=");
			bt[11] = api_makebutton(win + 1,212,  51, 247,  70, "+");
			bt[12] = api_makebutton(win + 1,212,  75, 247,  94, "-");
			bt[13] = api_makebutton(win + 1,212,  99, 247, 118, "*");
			bt[14] = api_makebutton(win + 1,212, 124, 247, 142, "/");
			api_putstrwin(win + 1, lcdx, lcdy, api_getint(0), 30, lcd);
			api_refreshwin(win, 0, 0, 256, 150);
			for (;;) {
				if (api_getkey(1) == 0x0a)
				{
					break;
				}
			}
			resf = 0;
			lcdp = 0;
			sprintf(lcd, "0                             ");
		}
	}
	api_end();
}

char *skipspace(char *p)
{
	for (; *p == ' '; p++) { }	/* Xy[Xǂݔ΂ */
	return p;
}

int getnum(char **pp, int priority)
{
	char *p = *pp;
	int i = INVALID, j;
	p = skipspace(p);

	/* PZq */
	if (*p == '+') {
		p = skipspace(p + 1);
		i = getnum(&p, 0);
	} else if (*p == '-') {
		p = skipspace(p + 1);
		i = getnum(&p, 0);
		if (i != INVALID) {
			i = - i;
		}
	} else if (*p == '~') {
		p = skipspace(p + 1);
		i = getnum(&p, 0);
		if (i != INVALID) {
			i = ~i;
		}
	} else if (*p == '(') {	/*  */
		p = skipspace(p + 1);
		i = getnum(&p, 9);
		if (*p == ')') {
			p = skipspace(p + 1);
		} else {
			i = INVALID;
		}
	} else if ('0' <= *p && *p <= '9') { /* l */
		i = strtol(p, &p, 0);
	} else { /* G[ */
		i = INVALID;
	}

	/* 񍀉Zq */
	for (;;) {
		if (i == INVALID) {
			break;
		}
		p = skipspace(p);
		if (*p == '+' && priority > 2) {
			p = skipspace(p + 1);
			j = getnum(&p, 2);
			if (j != INVALID) {
				i += j;
			} else {
				i = INVALID;
			}
		} else if (*p == '-' && priority > 2) {
			p = skipspace(p + 1);
			j = getnum(&p, 2);
			if (j != INVALID) {
				i -= j;
			} else {
				i = INVALID;
			}
		} else if (*p == '*' && priority > 1) {
			p = skipspace(p + 1);
			j = getnum(&p, 1);
			if (j != INVALID) {
				i *= j;
			} else {
				i = INVALID;
			}
		} else if (*p == '/' && priority > 1) {
			p = skipspace(p + 1);
			j = getnum(&p, 1);
			if (j != INVALID && j != 0) {
				i /= j;
			} else {
				i = INVALID;
			}
		} else if (*p == '%' && priority > 1) {
			p = skipspace(p + 1);
			j = getnum(&p, 1);
			if (j != INVALID && j != 0) {
				i %= j;
			} else {
				i = INVALID;
			}
		} else if (*p == '<' && p[1] == '<' && priority > 3) {
			p = skipspace(p + 2);
			j = getnum(&p, 3);
			if (j != INVALID && j != 0) {
				i <<= j;
			} else {
				i = INVALID;
			}
		} else if (*p == '>' && p[1] == '>' && priority > 3) {
			p = skipspace(p + 2);
			j = getnum(&p, 3);
			if (j != INVALID && j != 0) {
				i >>= j;
			} else {
				i = INVALID;
			}
		} else if (*p == '&' && priority > 4) {
			p = skipspace(p + 1);
			j = getnum(&p, 4);
			if (j != INVALID) {
				i &= j;
			} else {
				i = INVALID;
			}
		} else if (*p == '^' && priority > 5) {
			p = skipspace(p + 1);
			j = getnum(&p, 5);
			if (j != INVALID) {
				i ^= j;
			} else {
				i = INVALID;
			}
		} else if (*p == '|' && priority > 6) {
			p = skipspace(p + 1);
			j = getnum(&p, 6);
			if (j != INVALID) {
				i |= j;
			} else {
				i = INVALID;
			}
		} else {
			break;
		}
	}
	p = skipspace(p);
	*pp = p;
	return i;
}

