
const axios = require('axios');
const fs = require('fs')

var forwarder = '192.168.1.5';
var target1 = 'http://' + forwarder + ':8080/';
var target2 = 'http://' + forwarder + ':8900/';

function getAsyncFunction(target, name) {
	var instance = axios.create({
		'responseType': 'arraybuffer',
		'headers': {
			'Content-Type': 'application/json',
			'Accept': 'image/jpg'
		}
	});
	return new Promise(function(resolve, reject) {
	instance.post(target, {
		Type: 1
	})
		.then(res => {
			console.log("data length=", res.data.length);
			const buffer = new Buffer.from(res.data);
			console.log("buffer size=", buffer.length);
			fs.writeFile("./tmp_" + name + ".jpg", buffer, "binary", function(err) {
				if (err) {
					console.log("Err:", err);
				} else {
					console.log("Success.");
				}
			});
			resolve(target);
		}).catch(error => {
                    if (error.response) {
                        // The request was made and the server responded with a status code
                        // that falls out of the range of 2xx
                        console.log(error.response.data);
                        console.log(error.response.status);      // 例：400
                        console.log(error.response.statusText);  // Bad Request
                        console.log(error.response.headers);
                    } else if (error.request) {
                        // The request was made but no response was received
                        // `error.request` is an instance of XMLHttpRequest in the browser and an instance of
                        // http.ClientRequest in node.js
                        console.log(error.request);
                    } else {
                        // Something happened in setting up the request that triggered an Error
                        console.log('Error', error.message);
                    }
                    console.log(error.config);
		    reject(error);
		});
	});
}

var taskA = getAsyncFunction(target1, "taskA");
var taskB = getAsyncFunction(target2, "taskB");
console.log("Starting to get the files.");
Promise.all([taskA, taskB]).then(function () {
//Promise.all([taskA]).then(function () {
	console.log("All task finished");
}).catch(err => {
	console.log("Err:", err);
});
