/***************************************************************************
**                                                                        **
**  Polyphone, a soundfont editor                                         **
**  Copyright (C) 2013-2020 Davy Triponney                                **
**                                                                        **
**  This program is free software: you can redistribute it and/or modify  **
**  it under the terms of the GNU General Public License as published by  **
**  the Free Software Foundation, either version 3 of the License, or     **
**  (at your option) any later version.                                   **
**                                                                        **
**  This program is distributed in the hope that it will be useful,       **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of        **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          **
**  GNU General Public License for more details.                          **
**                                                                        **
**  You should have received a copy of the GNU General Public License     **
**  along with this program. If not, see http://www.gnu.org/licenses/.    **
**                                                                        **
****************************************************************************
**           Author: Davy Triponney                                       **
**  Website/Contact: https://www.polyphone-soundfonts.com                 **
**             Date: 01.01.2013                                           **
***************************************************************************/

#include "extensionmanager.h"

ExtensionManager * ExtensionManager::s_instance = nullptr;

ExtensionManagerMidi * ExtensionManager::midi()
{
    if (s_instance == nullptr)
        s_instance = new ExtensionManager();
    return s_instance->_midi;
}

ExtensionManagerView * ExtensionManager::view()
{
    if (s_instance == nullptr)
        s_instance = new ExtensionManager();
    return s_instance->_view;
}

void ExtensionManager::kill()
{
    delete s_instance;
    s_instance = nullptr;
}

ExtensionManager::ExtensionManager() :
    _midi(new ExtensionManagerMidi()),
    _view(new ExtensionManagerView())
{
    // ...
}

ExtensionManager::~ExtensionManager()
{
    delete _midi;
    delete _view;
}
