/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef __LINUX_MFD_BD2657_H__
#define __LINUX_MFD_BD2657_H__

#include <linux/mfd/rohm-generic.h>
#include <linux/mfd/rohm-shared.h>

/* Regulator IDs. Data sheet starts from BUCK0 so let's use same here */
enum {
	BD2657_BUCK0,
	BD2657_BUCK1,
	BD2657_BUCK2,
	BD2657_BUCK3,
};

#define BD2657_BUCK_NUM_VOLTS		0xfF

/* Regulator control masks */
#define BD2657_MASK_RAMP_DELAY		0x6

#define BD2657_MASK_RUN0_EN		0x01
#define BD2657_MASK_RUN1_EN		0x02
#define BD2657_MASK_RUN2_EN		0x04
#define BD2657_MASK_RUN3_EN		0x08

#define BD2657_MASK_RAMP_SLOW		0xc
#define BD2657_MASK_RAMP_FAST		0x3

#define BD2657_MASK_DVS_BUCK1_CTRL	0x10
#define BD2657_DVS_BUCK1_CTRL_I2C	0
#define BD2657_DVS_BUCK1_USE_RUNLVL	0x10

#define BD2657_MASK_DVS_BUCK2_CTRL	0x20
#define BD2657_DVS_BUCK2_CTRL_I2C	0
#define BD2657_DVS_BUCK2_USE_RUNLVL	0x20

#define BD2657_MASK_DVS_BUCK6_CTRL	0x40
#define BD2657_DVS_BUCK6_CTRL_I2C	0
#define BD2657_DVS_BUCK6_USE_RUNLVL	0x40

#define BD2657_MASK_DVS_BUCK7_CTRL	0x80
#define BD2657_DVS_BUCK7_CTRL_I2C	0
#define BD2657_DVS_BUCK7_USE_RUNLVL	0x80

#define BD2657_MASK_BUCK_VOLT		0xff

#define BD2657_REG_PWRGOOD		0x24
#define BD2657_REG_S3_STATUS		0x2b
#define BD2657_REG_PBSTATUS		0x8f
#define BD2657_REG_RESETSRC		0x98
#define BD2657_REG_REGLOCK		0xA0
#define BD2657_MASK_REGLOCK		BIT(0)

/* Regulator control regs */
#define BD2657_REG_BUCK0_VID		0x0a
#define BD2657_REG_BUCK0_BVID		0x0b
#define BD2657_REG_BUCK0_SLEW		0x0c
#define BD2657_REG_BUCK0_VMAX		0x0d

#define BD2657_REG_BUCK1_VID		0x0e
#define BD2657_REG_BUCK1_BVID		0x0f
#define BD2657_REG_BUCK1_SLEW		0x10
#define BD2657_REG_BUCK1_VMAX		0x11

#define BD2657_REG_BUCK2_VID		0x12
#define BD2657_REG_BUCK2_BVID		0x13
#define BD2657_REG_BUCK2_SLEW		0x14
#define BD2657_REG_BUCK2_VMAX		0x15

#define BD2657_REG_BUCK3_VID		0x16
#define BD2657_REG_BUCK3_BVID		0x17
#define BD2657_REG_BUCK3_SLEW		0x18
#define BD2657_REG_BUCK3_VMAX		0x19

/* GPIO */
#define BD2657_NUM_GPIOS		2
#define BD2657_REG_GPIO0_OUT		0x90
#define BD2657_REG_GPIO1_OUT		0x91

#define GPIO0_OUT_MODE_MASK		BIT(3)
#define GPIO0_OUT_MODE_HWCTRL		BIT(3)
#define GPIO0_OUT_MODE_GPIO		0
#define BD2657_GPIO_DRIVE_MASK		BIT(1)
#define BD2657_GPIO_OPEN_DRAIN		0x0
#define BD2657_GPIO_PUSH_PULL		BIT(1)
#define BD2657_GPIO_OUT_HI		BIT(0)
#define BD2657_GPIO_OUT_LO		0x0
#define BD2657_GPIO_OUT_MASK		BIT(0)

//#define BD2657_REG_IO_STAT		0xed

/* CPU IRQ registers */
#define BD2657_REG_INT_MAIN		0x84
#define BD2657_REG_INT_MASK_MAIN	0x85
#define BD2657_REG_INT_THERM		0x86
#define BD2657_REG_INT_MASK_THERM	0x87
#define BD2657_REG_INT_REQ		0x88
#define BD2657_REG_INT_MASK_REQ		0x89
#define BD2657_REG_INT_PBTN		0x8a
#define BD2657_REG_INT_MASK_PBTN	0x8b

#define BD2657_INT_THERM_MASK		BIT(0)
#define BD2657_INT_REQ_MASK		BIT(1)
#define BD2657_INT_PBTN_OFF_MASK	BIT(2)

/* CPU Interrupts */
enum {
	BD2657_INT_THERM,
	BD2657_INT_REQ,
	BD2657_INT_PBTN_OFF,
};

#define BD2657_REG_INT_EPU		0x21
#define BD2657_REG_INT_MASK_EPU		0x22

#define BD2657_INT_BUCK0_SETTLE_MASK	BIT(0)
#define BD2657_INT_BUCK1_SETTLE_MASK	BIT(1)
#define BD2657_INT_BUCK2_SETTLE_MASK	BIT(2)
#define BD2657_INT_BUCK0_REJECT_MASK	BIT(3)
#define BD2657_INT_BUCK1_REJECT_MASK	BIT(4)
#define BD2657_INT_BUCK2_REJECT_MASK	BIT(5)
#define BD2657_INT_BUCK3_SETTLE_MASK	BIT(6)
#define BD2657_INT_BUCK3_REJECT_MASK	BIT(7)

/* EPU Interrupts */
enum {
	/* BUCK reg interrupts */
	BD2657_INT_BUCK0_SETTLE,
	BD2657_INT_BUCK1_SETTLE,
	BD2657_INT_BUCK2_SETTLE,
	BD2657_INT_BUCK0_REJECT,
	BD2657_INT_BUCK1_REJECT,
	BD2657_INT_BUCK2_REJECT,
	BD2657_INT_BUCK3_SETTLE,
	BD2657_INT_BUCK3_REJECT,
};

#define BD2657_REG_OTPREV		0xb0
#define BD2657_MAX_REGISTER BD2657_REG_OTPREV

/* Masks for main IRQ register bits */
enum {
	BD2657_INT_BUCK,
#define BD2657_INT_BUCK_MASK BIT(BD2657_INT_BUCK)
	BD2657_INT_DCIN,
#define BD2657_INT_DCIN_MASK BIT(BD2657_INT_DCIN)
	BD2657_INT_VSYS,
#define BD2657_INT_VSYS_MASK BIT(BD2657_INT_VSYS)
	BD2657_INT_CHG,
#define BD2657_INT_CHG_MASK BIT(BD2657_INT_CHG)
	BD2657_INT_BAT,
#define BD2657_INT_BAT_MASK BIT(BD2657_INT_BAT)
	BD2657_INT_BAT_MON,
#define BD2657_INT_BAT_MON_MASK BIT(BD2657_INT_BAT_MON)
	BD2657_INT_TEMP,
#define BD2657_INT_TEMP_MASK BIT(BD2657_INT_TEMP)
	BD2657_INT_RTC,
#define BD2657_INT_RTC_MASK BIT(BD2657_INT_RTC)
};

/* Interrupts */
enum {
	/* BUCK reg interrupts */
	BD2657_INT_BUCK1_OCP,
	BD2657_INT_BUCK2_OCP,
	BD2657_INT_BUCK3_OCP,
	BD2657_INT_BUCK4_OCP,
	BD2657_INT_BUCK5_OCP,
	BD2657_INT_BUCK6_OCP,
	BD2657_INT_BUCK7_OCP,
	BD2657_INT_PGFAULT,
	/* DCIN1 interrupts */
	BD2657_INT_DCIN_DET,
	BD2657_INT_DCIN_RMV,
	BD2657_INT_CLPS_OUT,
	BD2657_INT_CLPS_IN,
	/* DCIN2 interrupts */
	BD2657_INT_DCIN_MON_RES,
	BD2657_INT_DCIN_MON_DET,
	BD2657_INT_LONGPUSH,
	BD2657_INT_MIDPUSH,
	BD2657_INT_SHORTPUSH,
	BD2657_INT_PUSH,
	BD2657_INT_WDOG,
	BD2657_INT_SWRESET,
	/* Vsys */
	BD2657_INT_VSYS_UV_RES,
	BD2657_INT_VSYS_UV_DET,
	BD2657_INT_VSYS_LOW_RES,
	BD2657_INT_VSYS_LOW_DET,
	BD2657_INT_VSYS_HALL_IN,
	BD2657_INT_VSYS_HALL_TOGGLE,
	BD2657_INT_VSYS_MON_RES,
	BD2657_INT_VSYS_MON_DET,
	/* Charger */
	BD2657_INT_CHG_DCIN_ILIM,
	BD2657_INT_CHG_TOPOFF_TO_DONE,
	BD2657_INT_CHG_WDG_TEMP,
	BD2657_INT_CHG_WDG_TIME,
	BD2657_INT_CHG_RECHARGE_RES,
	BD2657_INT_CHG_RECHARGE_DET,
	BD2657_INT_CHG_RANGED_TEMP_TRANSITION,
	BD2657_INT_CHG_STATE_TRANSITION,
	/* Battery */
	BD2657_INT_BAT_TEMP_NORMAL,
	BD2657_INT_BAT_TEMP_ERANGE,
	BD2657_INT_BAT_TEMP_WARN,
	BD2657_INT_BAT_REMOVED,
	BD2657_INT_BAT_DETECTED,
	BD2657_INT_THERM_REMOVED,
	BD2657_INT_THERM_DETECTED,
	/* Battery Mon 1 */
	BD2657_INT_BAT_DEAD,
	BD2657_INT_BAT_SHORTC_RES,
	BD2657_INT_BAT_SHORTC_DET,
	BD2657_INT_BAT_LOW_VOLT_RES,
	BD2657_INT_BAT_LOW_VOLT_DET,
	BD2657_INT_BAT_OVER_VOLT_RES,
	BD2657_INT_BAT_OVER_VOLT_DET,
	/* Battery Mon 2 */
	BD2657_INT_BAT_MON_RES,
	BD2657_INT_BAT_MON_DET,
	/* Battery Mon 3 (Coulomb counter) */
	BD2657_INT_BAT_CC_MON1,
	BD2657_INT_BAT_CC_MON2,
	BD2657_INT_BAT_CC_MON3,
	/* Battery Mon 4 */
	BD2657_INT_BAT_OVER_CURR_1_RES,
	BD2657_INT_BAT_OVER_CURR_1_DET,
	BD2657_INT_BAT_OVER_CURR_2_RES,
	BD2657_INT_BAT_OVER_CURR_2_DET,
	BD2657_INT_BAT_OVER_CURR_3_RES,
	BD2657_INT_BAT_OVER_CURR_3_DET,
	/* Temperature */
	BD2657_INT_TEMP_BAT_LOW_RES,
	BD2657_INT_TEMP_BAT_LOW_DET,
	BD2657_INT_TEMP_BAT_HI_RES,
	BD2657_INT_TEMP_BAT_HI_DET,
	BD2657_INT_TEMP_CHIP_OVER_125_RES,
	BD2657_INT_TEMP_CHIP_OVER_125_DET,
	BD2657_INT_TEMP_CHIP_OVER_VF_DET,
	BD2657_INT_TEMP_CHIP_OVER_VF_RES,
	/* RTC Alarm */
	BD2657_INT_RTC0,
	BD2657_INT_RTC1,
	BD2657_INT_RTC2,
};

#define BD2657_INT_BUCK1_OCP_MASK			0x1
#define BD2657_INT_BUCK2_OCP_MASK			0x2
#define BD2657_INT_BUCK3_OCP_MASK			0x4
#define BD2657_INT_BUCK4_OCP_MASK			0x8
#define BD2657_INT_BUCK5_OCP_MASK			0x10
#define BD2657_INT_BUCK6_OCP_MASK			0x20
#define BD2657_INT_BUCK7_OCP_MASK			0x40
#define BD2657_INT_PGFAULT_MASK			0x80

#define BD2657_INT_DCIN_DET_MASK			0x1
#define BD2657_INT_DCIN_RMV_MASK			0x2
#define BD2657_INT_CLPS_OUT_MASK			0x4
#define BD2657_INT_CLPS_IN_MASK			0x8
	/* DCIN2 interrupts */
#define BD2657_INT_DCIN_MON_RES_MASK			0x1
#define BD2657_INT_DCIN_MON_DET_MASK			0x2
#define BD2657_INT_LONGPUSH_MASK			0x4
#define BD2657_INT_MIDPUSH_MASK			0x8
#define BD2657_INT_SHORTPUSH_MASK			0x10
#define BD2657_INT_PUSH_MASK				0x20
#define BD2657_INT_WDOG_MASK				0x40
#define BD2657_INT_SWRESET_MASK			0x80
	/* Vsys */
#define BD2657_INT_VSYS_UV_RES_MASK			0x1
#define BD2657_INT_VSYS_UV_DET_MASK			0x2
#define BD2657_INT_VSYS_LOW_RES_MASK			0x4
#define BD2657_INT_VSYS_LOW_DET_MASK			0x8
#define BD2657_INT_VSYS_HALL_IN_MASK			0x10
#define BD2657_INT_VSYS_HALL_TOGGLE_MASK		0x20
#define BD2657_INT_VSYS_MON_RES_MASK			0x40
#define BD2657_INT_VSYS_MON_DET_MASK			0x80
	/* Charger */
#define BD2657_INT_CHG_DCIN_ILIM_MASK			0x1
#define BD2657_INT_CHG_TOPOFF_TO_DONE_MASK		0x2
#define BD2657_INT_CHG_WDG_TEMP_MASK			0x4
#define BD2657_INT_CHG_WDG_TIME_MASK			0x8
#define BD2657_INT_CHG_RECHARGE_RES_MASK		0x10
#define BD2657_INT_CHG_RECHARGE_DET_MASK		0x20
#define BD2657_INT_CHG_RANGED_TEMP_TRANSITION_MASK	0x40
#define BD2657_INT_CHG_STATE_TRANSITION_MASK		0x80
	/* Battery */
#define BD2657_INT_BAT_TEMP_NORMAL_MASK		0x1
#define BD2657_INT_BAT_TEMP_ERANGE_MASK		0x2
#define BD2657_INT_BAT_TEMP_WARN_MASK			0x4
#define BD2657_INT_BAT_REMOVED_MASK			0x10
#define BD2657_INT_BAT_DETECTED_MASK			0x20
#define BD2657_INT_THERM_REMOVED_MASK			0x40
#define BD2657_INT_THERM_DETECTED_MASK			0x80
	/* Battery Mon 1 */
#define BD2657_INT_BAT_DEAD_MASK			0x2
#define BD2657_INT_BAT_SHORTC_RES_MASK			0x4
#define BD2657_INT_BAT_SHORTC_DET_MASK			0x8
#define BD2657_INT_BAT_LOW_VOLT_RES_MASK		0x10
#define BD2657_INT_BAT_LOW_VOLT_DET_MASK		0x20
#define BD2657_INT_BAT_OVER_VOLT_RES_MASK		0x40
#define BD2657_INT_BAT_OVER_VOLT_DET_MASK		0x80
	/* Battery Mon 2 */
#define BD2657_INT_BAT_MON_RES_MASK			0x1
#define BD2657_INT_BAT_MON_DET_MASK			0x2
	/* Battery Mon 3 (Coulomb counter) */
#define BD2657_INT_BAT_CC_MON1_MASK			0x1
#define BD2657_INT_BAT_CC_MON2_MASK			0x2
#define BD2657_INT_BAT_CC_MON3_MASK			0x4
	/* Battery Mon 4 */
#define BD2657_INT_BAT_OVER_CURR_1_RES_MASK		0x1
#define BD2657_INT_BAT_OVER_CURR_1_DET_MASK		0x2
#define BD2657_INT_BAT_OVER_CURR_2_RES_MASK		0x4
#define BD2657_INT_BAT_OVER_CURR_2_DET_MASK		0x8
#define BD2657_INT_BAT_OVER_CURR_3_RES_MASK		0x10
#define BD2657_INT_BAT_OVER_CURR_3_DET_MASK		0x20
	/* Temperature */
#define BD2657_INT_TEMP_BAT_LOW_RES_MASK		0x1
#define BD2657_INT_TEMP_BAT_LOW_DET_MASK		0x2
#define BD2657_INT_TEMP_BAT_HI_RES_MASK		0x4
#define BD2657_INT_TEMP_BAT_HI_DET_MASK		0x8
#define BD2657_INT_TEMP_CHIP_OVER_125_RES_MASK		0x10
#define BD2657_INT_TEMP_CHIP_OVER_125_DET_MASK		0x20
#define BD2657_INT_TEMP_CHIP_OVER_VF_RES_MASK		0x40
#define BD2657_INT_TEMP_CHIP_OVER_VF_DET_MASK		0x80
	/* RTC Alarm */
#define BD2657_INT_RTC0_MASK				0x1
#define BD2657_INT_RTC1_MASK				0x2
#define BD2657_INT_RTC2_MASK				0x4

#define BD2657_OUT_TYPE_MASK				0x2
#define BD2657_OUT_TYPE_OPEN_DRAIN			0x0
#define BD2657_OUT_TYPE_CMOS				0x2

#endif /* __LINUX_MFD_BD2657_H__ */
