/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.history.AffectedPathsContentProvider;
import org.eclipse.team.svn.ui.history.AffectedPathsLabelProvider;
import org.eclipse.team.svn.ui.history.HistoryActionManager;
import org.eclipse.team.svn.ui.history.data.AffectedPathsNode;
import org.eclipse.team.svn.ui.history.data.SVNChangedPathData;
import org.eclipse.team.svn.ui.utility.ArrayStructuredContentProvider;
import org.eclipse.team.svn.ui.utility.ColumnedViewerComparator;
import org.eclipse.team.svn.ui.utility.OverlayedImageDescriptor;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffectedPathsComposite
extends Composite {
    public static final int COLUMN_ICON = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_PATH = 2;
    public static final int COLUMN_COPIED_FROM = 3;
    public static final int NUM_COLUMNS = 4;
    protected static ImageDescriptor ADDITION_OVERLAY;
    protected static ImageDescriptor MODIFICATION_OVERLAY;
    protected static ImageDescriptor DELETION_OVERLAY;
    protected static ImageDescriptor REPLACEMENT_OVERLAY;
    protected SashForm sashForm;
    protected TableViewer tableViewer;
    protected TreeViewer treeViewer;
    protected AffectedPathsLabelProvider labelProvider;

    public AffectedPathsComposite(Composite parent, int style) {
        super(parent, style);
        if (ADDITION_OVERLAY == null) {
            ADDITION_OVERLAY = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/addition.gif");
            MODIFICATION_OVERLAY = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/change.gif");
            DELETION_OVERLAY = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/deletion.gif");
            REPLACEMENT_OVERLAY = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/replacement.gif");
        }
        this.createControls();
    }

    public void setResourceTreeVisible(boolean visible) {
        if (visible) {
            this.sashForm.setMaximizedControl(null);
        } else {
            this.sashForm.setMaximizedControl(this.tableViewer.getControl());
            AffectedPathsContentProvider provider = (AffectedPathsContentProvider)this.treeViewer.getContentProvider();
            AffectedPathsNode rootNode = provider.getRoot();
            if (rootNode != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)rootNode));
            }
        }
    }

    public void setInput(SVNChangedPathData[] input, Collection<String> relatedPathPrefixes, Collection<String> relatedParents, long currentRevision) {
        this.labelProvider.setCurrentRevision(currentRevision);
        AffectedPathsContentProvider provider = (AffectedPathsContentProvider)this.treeViewer.getContentProvider();
        provider.initialize(input, relatedPathPrefixes, relatedParents, currentRevision);
        if (input != null && (input.length > 0 || currentRevision == 0L)) {
            this.treeViewer.setInput((Object)"Root");
            this.treeViewer.expandAll();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)provider.getRoot()));
            ((Tree)this.treeViewer.getControl()).showSelection();
        } else {
            this.treeViewer.setInput(null);
        }
    }

    public void registerActionManager(HistoryActionManager manager, IWorkbenchPartSite site) {
        manager.affectedTableManager.installKeyBindings((StructuredViewer)this.tableViewer);
        manager.affectedTableManager.installDefaultAction((StructuredViewer)this.tableViewer);
        manager.affectedTableManager.installMenuActions((StructuredViewer)this.tableViewer, site);
        manager.affectedTreeManager.installKeyBindings((StructuredViewer)this.treeViewer);
        manager.affectedTreeManager.installDefaultAction((StructuredViewer)this.treeViewer);
        manager.affectedTreeManager.installMenuActions((StructuredViewer)this.treeViewer, site);
    }

    protected void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.sashForm = new SashForm((Composite)this, 256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer((Composite)this.sashForm, 768);
        this.treeViewer.setContentProvider((IContentProvider)new AffectedPathsContentProvider());
        this.labelProvider = new AffectedPathsLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){
            protected AffectedPathsNode oldSelection;

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection tSelection = (IStructuredSelection)event.getSelection();
                if (tSelection.size() > 0) {
                    AffectedPathsNode selection = (AffectedPathsNode)tSelection.getFirstElement();
                    if (this.oldSelection != selection) {
                        AffectedPathsComposite.this.tableViewer.setInput((Object)selection.getPathData());
                        this.oldSelection = selection;
                    }
                } else {
                    AffectedPathsComposite.this.tableViewer.setInput(null);
                }
            }
        });
        final Table table = new Table((Composite)this.sashForm, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                TableItem item = table.getItem(new Point(e.x, e.y));
                if (item != null) {
                    Rectangle rect = item.getBounds(0);
                    String tooltip = "";
                    if (rect.contains(e.x, e.y)) {
                        SVNChangedPathData data = (SVNChangedPathData)item.getData();
                        switch (data.action) {
                            case ADDED: {
                                tooltip = SVNUIMessages.LogMessagesComposite_Add;
                                break;
                            }
                            case MODIFIED: {
                                tooltip = SVNUIMessages.LogMessagesComposite_Modify;
                                break;
                            }
                            case DELETED: {
                                tooltip = SVNUIMessages.LogMessagesComposite_Delete;
                                break;
                            }
                            case REPLACED: {
                                tooltip = SVNUIMessages.LogMessagesComposite_Replace;
                            }
                        }
                    }
                    table.setToolTipText(rect.contains(e.x, e.y) ? tooltip : "");
                }
            }
        });
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(table);
        this.sashForm.setWeights(new int[]{25, 75});
        AffectedPathsTableComparator tableComparator = new AffectedPathsTableComparator((Viewer)this.tableViewer);
        TableColumn col = new TableColumn(table, 0);
        col.setText("");
        col.setResizable(false);
        col.setAlignment(0x1000000);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(26, false));
        col = new TableColumn(table, 0);
        col.setText(SVNUIMessages.AffectedPathsComposite_Name);
        col.addSelectionListener((SelectionListener)tableComparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setText(SVNUIMessages.AffectedPathsComposite_Path);
        col.addSelectionListener((SelectionListener)tableComparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        col = new TableColumn(table, 0);
        col.setText(SVNUIMessages.AffectedPathsComposite_CopiedFrom);
        col.addSelectionListener((SelectionListener)tableComparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        tableComparator.setReversed(false);
        tableComparator.setColumnNumber(2);
        this.tableViewer.setComparator((ViewerComparator)tableComparator);
        this.tableViewer.getTable().setSortColumn(this.tableViewer.getTable().getColumn(2));
        this.tableViewer.getTable().setSortDirection(128);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayStructuredContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AffectedPathsTableLabelProvider());
    }

    protected class AffectedPathsTableComparator
    extends ColumnedViewerComparator {
        public AffectedPathsTableComparator(Viewer tableViewer) {
            super(tableViewer);
        }

        public int compareImpl(Viewer viewer, Object row1, Object row2) {
            SVNChangedPathData data1 = (SVNChangedPathData)row1;
            SVNChangedPathData data2 = (SVNChangedPathData)row2;
            switch (this.column) {
                case 1: {
                    return ColumnedViewerComparator.compare(data1.resourceName, data2.resourceName);
                }
                case 2: {
                    return ColumnedViewerComparator.compare(data1.resourcePath, data2.resourcePath);
                }
                case 3: {
                    String copied1 = String.valueOf(data1.copiedFromPath) + (data1.copiedFromRevision == -1L ? "" : String.valueOf('@') + String.valueOf(data1.copiedFromRevision));
                    String copied2 = String.valueOf(data2.copiedFromPath) + (data2.copiedFromRevision == -1L ? "" : String.valueOf('@') + String.valueOf(data2.copiedFromRevision));
                    return ColumnedViewerComparator.compare(copied1, copied2);
                }
            }
            return 0;
        }
    }

    protected class AffectedPathsTableLabelProvider
    implements ITableLabelProvider {
        protected Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

        protected AffectedPathsTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                String fileName = ((SVNChangedPathData)element).resourceName;
                Object descr = SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getImageDescriptor(fileName);
                Image img = this.images.get(descr);
                if (img == null) {
                    img = descr.createImage();
                    this.images.put((ImageDescriptor)descr, img);
                }
                switch (((SVNChangedPathData)element).action) {
                    case ADDED: {
                        descr = new OverlayedImageDescriptor(img, ADDITION_OVERLAY, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                        break;
                    }
                    case MODIFIED: {
                        descr = new OverlayedImageDescriptor(img, MODIFICATION_OVERLAY, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                        break;
                    }
                    case DELETED: {
                        descr = new OverlayedImageDescriptor(img, DELETION_OVERLAY, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                        break;
                    }
                    case REPLACED: {
                        descr = new OverlayedImageDescriptor(img, REPLACEMENT_OVERLAY, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                    }
                }
                img = this.images.get(descr);
                if (img == null) {
                    img = descr.createImage();
                    this.images.put((ImageDescriptor)descr, img);
                }
                return img;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SVNChangedPathData data = (SVNChangedPathData)element;
            switch (columnIndex) {
                case 1: {
                    return data.resourceName;
                }
                case 2: {
                    return data.resourcePath;
                }
                case 3: {
                    return String.valueOf(data.copiedFromPath) + (data.copiedFromRevision == -1L ? "" : String.valueOf('@') + String.valueOf(data.copiedFromRevision));
                }
            }
            return "";
        }

        public void dispose() {
            for (Image img : this.images.values()) {
                img.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

