/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.subscribers.AbstractContentComparator;
import org.eclipse.team.internal.ui.synchronize.RegexDiffComparator;

public class RegexSyncInfoFilter
extends SyncInfoFilter {
    AbstractContentComparator criteria;
    boolean ignoreWhiteSpace;

    public RegexSyncInfoFilter(String pattern) {
        this(false, pattern);
    }

    public RegexSyncInfoFilter(boolean ignoreWhitespace, String pattern) {
        this.criteria = new RegexDiffComparator(Pattern.compile(pattern, 32), ignoreWhitespace);
    }

    public boolean select(SyncInfo info, IProgressMonitor monitor) {
        IResourceVariant remote = info.getRemote();
        IResource local = info.getLocal();
        if (local.getType() != 1) {
            return true;
        }
        if (remote == null) {
            return !local.exists();
        }
        if (!local.exists()) {
            return false;
        }
        return this.criteria.compare(local, remote, monitor);
    }
}

