/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;

@Command(usage="usage_ShowRef")
class ShowRef
extends TextBuiltin {
    ShowRef() {
    }

    @Override
    protected void run() {
        try {
            for (Ref r : this.getSortedRefs()) {
                this.show((AnyObjectId)r.getObjectId(), r.getName());
                if (r.getPeeledObjectId() == null) continue;
                this.show((AnyObjectId)r.getPeeledObjectId(), String.valueOf(r.getName()) + "^{}");
            }
        }
        catch (IOException e) {
            throw ShowRef.die(e.getMessage(), (Throwable)e);
        }
    }

    private Iterable<Ref> getSortedRefs() throws IOException {
        List all = this.db.getRefDatabase().getRefs();
        return RefComparator.sort((Collection)all);
    }

    private void show(AnyObjectId id, String name) throws IOException {
        this.outw.print((Object)id.name());
        this.outw.print('\t');
        this.outw.print((Object)name);
        this.outw.println();
    }
}

