/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;
import org.eclipse.jgit.lfs.server.LargeFileRepository;
import org.eclipse.jgit.lfs.server.LfsObject;
import org.eclipse.jgit.lfs.server.Response;
import org.eclipse.jgit.lfs.server.internal.LfsServerText;

abstract class TransferHandler {
    final LargeFileRepository repository;
    final List<LfsObject> objects;

    /*
     * Exception decompiling
     */
    static TransferHandler forOperation(String operation, LargeFileRepository repository, List<LfsObject> objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl31 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl31 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    TransferHandler(LargeFileRepository repository, List<LfsObject> objects) {
        this.repository = repository;
        this.objects = objects;
    }

    abstract Response.Body process() throws IOException;

    private static class Download
    extends TransferHandler {
        Download(LargeFileRepository repository, List<LfsObject> objects) {
            super(repository, objects);
        }

        @Override
        Response.Body process() throws IOException {
            Response.Body body = new Response.Body();
            if (this.objects.size() > 0) {
                body.objects = new ArrayList<Response.ObjectInfo>();
                for (LfsObject o : this.objects) {
                    this.addObjectInfo(body, o);
                }
            }
            return body;
        }

        private void addObjectInfo(Response.Body body, LfsObject o) throws IOException {
            Response.ObjectInfo info = new Response.ObjectInfo();
            body.objects.add(info);
            info.oid = o.oid;
            info.size = o.size;
            LongObjectId oid = LongObjectId.fromString((String)o.oid);
            if (this.repository.getSize((AnyLongObjectId)oid) >= 0L) {
                info.actions = new HashMap<String, Response.Action>();
                info.actions.put("download", this.repository.getDownloadAction((AnyLongObjectId)oid));
            } else {
                info.error = new Response.Error();
                info.error.code = 404;
                info.error.message = MessageFormat.format(LfsServerText.get().objectNotFound, oid.getName());
            }
        }
    }

    private static class Upload
    extends TransferHandler {
        Upload(LargeFileRepository repository, List<LfsObject> objects) {
            super(repository, objects);
        }

        @Override
        Response.Body process() throws IOException {
            Response.Body body = new Response.Body();
            if (this.objects.size() > 0) {
                body.objects = new ArrayList<Response.ObjectInfo>();
                for (LfsObject o : this.objects) {
                    this.addObjectInfo(body, o);
                }
            }
            return body;
        }

        private void addObjectInfo(Response.Body body, LfsObject o) throws IOException {
            Response.ObjectInfo info = new Response.ObjectInfo();
            body.objects.add(info);
            info.oid = o.oid;
            info.size = o.size;
            LongObjectId oid = LongObjectId.fromString((String)o.oid);
            if (this.repository.getSize((AnyLongObjectId)oid) == -1L) {
                info.actions = new HashMap<String, Response.Action>();
                info.actions.put("upload", this.repository.getUploadAction((AnyLongObjectId)oid, o.size));
                Response.Action verify = this.repository.getVerifyAction((AnyLongObjectId)oid);
                if (verify != null) {
                    info.actions.put("verify", verify);
                }
            }
        }
    }
}

