/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.util.ArrayList;
import java.util.Collections;
import org.codehaus.groovy.eclipse.refactoring.actions.AbstractGroovyCleanUp;
import org.codehaus.groovy.eclipse.refactoring.actions.OrganizeGroovyImports;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.ImportsFix;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.fix.ImportsCleanUp;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class GroovyImportsCleanUp
extends AbstractGroovyCleanUp {
    private ImportsCleanUp javaCleanUp = new ImportsCleanUp(Collections.singletonMap("cleanup.organize_imports", "true"));

    public CleanUpRequirements getRequirements() {
        return this.javaCleanUp.getRequirements();
    }

    public String[] getStepDescriptions() {
        return this.javaCleanUp.getStepDescriptions();
    }

    @Override
    public RefactoringStatus checkPreConditions(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        ArrayList<ICompilationUnit> groovyUnits = new ArrayList<ICompilationUnit>(compilationUnits.length);
        ICompilationUnit[] iCompilationUnitArray = compilationUnits;
        int n = compilationUnits.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            if (unit instanceof GroovyCompilationUnit) {
                groovyUnits.add(unit);
            }
            ++n2;
        }
        RefactoringStatus groovyStatus = super.checkPreConditions(project, groovyUnits.toArray(new ICompilationUnit[groovyUnits.size()]), monitor);
        this.javaCleanUp.checkPreConditions(project, new ICompilationUnit[0], monitor);
        return groovyStatus;
    }

    @Override
    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        return this.javaCleanUp.checkPostConditions(monitor);
    }

    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        ICompilationUnit unit = context.getCompilationUnit();
        if (!(unit instanceof GroovyCompilationUnit)) {
            return this.javaCleanUp.createFix(context);
        }
        boolean[] hasAmbiguity = new boolean[1];
        OrganizeGroovyImports op = new OrganizeGroovyImports((GroovyCompilationUnit)unit, (choices, ranges) -> {
            blArray[0] = true;
            return new TypeNameMatch[0];
        });
        TextEdit edit = op.calculateMissingImports();
        if (this.status == null) {
            this.status = new RefactoringStatus();
        }
        if (hasAmbiguity[0]) {
            this.status.addInfo(ActionMessages.bind((String)ActionMessages.OrganizeImportsAction_multi_error_unresolvable, (Object)GroovyImportsCleanUp.getLocationString(unit)));
        } else if (edit == null) {
            this.status.addInfo(ActionMessages.bind((String)ActionMessages.OrganizeImportsAction_multi_error_parse, (Object)GroovyImportsCleanUp.getLocationString(unit)));
        }
        if (edit == null || edit instanceof MultiTextEdit && edit.getChildrenSize() == 0) {
            return null;
        }
        return new ImportsFix(edit, unit, FixMessages.ImportsFix_OrganizeImports_Description);
    }

    private static String getLocationString(ICompilationUnit unit) {
        return BasicElementLabels.getPathLabel((IPath)unit.getPath(), (boolean)false);
    }
}

