/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.beans.Introspector;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertToPropertyAction
extends Action {
    private final GroovyEditor editor;

    public ConvertToPropertyAction(GroovyEditor editor) {
        this.editor = editor;
        this.setText("Replace Accessor call with Property read/write");
        this.setActionDefinitionId("org.codehaus.groovy.eclipse.ui.convertToProperty");
    }

    public void run() {
        if (!this.editor.validateEditorInputState()) {
            return;
        }
        ISelection selection = this.editor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        GroovyCompilationUnit gcu = this.editor.getGroovyCompilationUnit();
        if (!ElementValidator.checkValidateEdit((IJavaElement)gcu, (Shell)this.editor.getSite().getShell(), (String)"Convert to Property")) {
            return;
        }
        try {
            TextEdit edit = ConvertToPropertyAction.createEdit(gcu, ((ITextSelection)selection).getOffset(), ((ITextSelection)selection).getLength());
            if (edit != null) {
                gcu.applyTextEdit(edit, null);
            }
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logError("Failure in convert to property", e);
        }
    }

    public static TextEdit createEdit(GroovyCompilationUnit gcu, int pos, int len) {
        ModuleNodeMapper.ModuleNodeInfo info = gcu.getModuleInfo(true);
        if (!info.isEmpty()) {
            StaticMethodCallExpression call = null;
            ASTNode node = new ASTNodeFinder(new Region(pos, len)).doVisit(info.module);
            if (node instanceof ConstantExpression) {
                MethodCallExpression expr;
                IASTFragment fragment = new FindSurroundingNode(new Region(node)).doVisitSurroundingNode(info.module);
                if (fragment.kind() == ASTFragmentKind.METHOD_CALL && (expr = (MethodCallExpression)fragment.getAssociatedNode()) != null && !expr.isUsingGenerics()) {
                    call = expr;
                }
            } else if (node instanceof StaticMethodCallExpression) {
                call = (StaticMethodCallExpression)node;
            }
            if (call != null && call.getArguments() instanceof ArgumentListExpression) {
                Matcher match;
                ArgumentListExpression args = (ArgumentListExpression)call.getArguments();
                if (args.getExpressions().isEmpty() && (match = Pattern.compile("(?:get|is)(\\p{javaJavaIdentifierPart}+)").matcher(call.getMethodAsString())).matches()) {
                    int offset = node.getStart();
                    int length = args.getEnd() + 1 - offset;
                    String propertyName = match.group(1);
                    return new ReplaceEdit(offset, length, Introspector.decapitalize(propertyName));
                }
                if (args.getExpressions().size() == 1 && (match = Pattern.compile("set(\\p{javaJavaIdentifierPart}+)").matcher(call.getMethodAsString())).matches()) {
                    int offset = node.getStart();
                    int length = args.getStart() - offset;
                    String propertyName = match.group(1);
                    MultiTextEdit edits = new MultiTextEdit();
                    Map options = gcu.getJavaProject().getOptions(true);
                    StringBuilder replacement = new StringBuilder(Introspector.decapitalize(propertyName));
                    if ("insert".equals(options.get("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator"))) {
                        replacement.append(' ');
                    }
                    replacement.append('=');
                    if ("insert".equals(options.get("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator"))) {
                        replacement.append(' ');
                    }
                    edits.addChild((TextEdit)new ReplaceEdit(offset, length, replacement.toString()));
                    if (gcu.getContents()[args.getEnd()] == ')') {
                        edits.addChild((TextEdit)new DeleteEdit(args.getEnd(), 1));
                    }
                    return edits;
                }
            }
        }
        return null;
    }
}

