/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.refactoring.actions.AddImportOnSelectionAdapter;
import org.codehaus.groovy.eclipse.refactoring.actions.TypeSearch;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.AddImportsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;

public class AddImportOnSelectionAction
extends AddImportOnSelectionAdapter {
    public AddImportOnSelectionAction(CompilationUnitEditor editor) {
        super(editor);
    }

    @Override
    protected AddImportOnSelectionAdapter.AddImportOperation newAddImportOperation(final GroovyCompilationUnit compilationUnit, final ITextSelection textSelection, final AddImportsOperation.IChooseImportQuery typeQuery) {
        return new AddImportOnSelectionAdapter.AddImportOperation(){
            private IStatus fStatus = Status.OK_STATUS;

            @Override
            public IStatus getStatus() {
                return this.fStatus;
            }

            public void run(IProgressMonitor monitor) {
                block5: {
                    SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (String)CodeGenerationMessages.AddImportsOperation_description, (int)4);
                    try {
                        ModuleNodeMapper.ModuleNodeInfo info = compilationUnit.getModuleInfo(true);
                        if (info.isEmpty()) {
                            this.fStatus = Status.CANCEL_STATUS;
                            return;
                        }
                        submon.worked(1);
                        ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)compilationUnit, (boolean)true);
                        TextEdit edit = this.evaluateEdits(info.module, importRewrite, (IProgressMonitor)submon.split(1));
                        if (edit == null) {
                            return;
                        }
                        MultiTextEdit result = new MultiTextEdit();
                        result.addChild(edit);
                        result.addChild(importRewrite.rewriteImports((IProgressMonitor)submon.split(1)));
                        AddImportOnSelectionAction.applyEdit((ICompilationUnit)compilationUnit, (TextEdit)result, true, (IProgressMonitor)submon.split(1));
                    }
                    catch (CoreException e) {
                        this.fStatus = e.getStatus();
                    }
                    catch (OperationCanceledException cancel) {
                        if (this.fStatus != Status.OK_STATUS) break block5;
                        this.fStatus = Status.CANCEL_STATUS;
                    }
                }
            }

            private TextEdit evaluateEdits(ModuleNode moduleNode, ImportRewrite importRewrite, IProgressMonitor monitor) throws CoreException {
                Region selectRegion = new Region(textSelection.getOffset(), textSelection.getLength());
                ASTNodeFinder nodeFinder = new ASTNodeFinder(selectRegion);
                ASTNode node = nodeFinder.doVisit(moduleNode);
                if (node != null) {
                    if (node instanceof VariableExpression) {
                        TypeNameMatch choice = this.findCandidateTypes(((VariableExpression)node).getName(), node.getStart(), monitor);
                        importRewrite.addImport(choice.getFullyQualifiedName());
                        return new RangeMarker(node.getStart(), node.getLength());
                    }
                    if (node instanceof ClassNode || node instanceof ClassExpression || node instanceof ConstructorCallExpression) {
                        String prefix;
                        ClassNode type = this.componentType(node);
                        int typeStart = this.startOffset((ASTNode)(!(node instanceof ConstructorCallExpression) ? node : type), nodeFinder);
                        if (moduleNode.getClasses().contains(type)) {
                            return null;
                        }
                        if (type.getName().equals(type.getNameWithoutPackage())) {
                            TypeNameMatch choice = this.findCandidateTypes(type.getName(), typeStart, monitor);
                            importRewrite.addImport(choice.getFullyQualifiedName());
                            return new RangeMarker(typeStart, type.getName().length());
                        }
                        String simple = type.getNameWithoutPackage().substring(type.getNameWithoutPackage().lastIndexOf(36) + 1);
                        if (simple.startsWith(prefix = compilationUnit.getSource().substring(typeStart, selectRegion.getEnd())) && prefix.length() > 0) {
                            importRewrite.addImport(type.getName());
                            return new RangeMarker(typeStart, type.getNameWithoutPackage().length());
                        }
                        String source = compilationUnit.getSource().substring(typeStart, this.endOffset(node, nodeFinder));
                        int nameStart = typeStart + source.indexOf(GroovyUtils.splitName((ClassNode)type)[1]);
                        if (nameStart > typeStart) {
                            Pattern pattern;
                            Matcher matcher;
                            if (nameStart <= selectRegion.getEnd()) {
                                String result = importRewrite.addImport(type.getName().replace('$', '.'));
                                if (result.indexOf(46) > 0) {
                                    this.fStatus = JavaUIStatus.createError((int)4, (String)CodeGenerationMessages.AddImportsOperation_error_importclash, null);
                                    return null;
                                }
                                return new DeleteEdit(typeStart, nameStart - typeStart);
                            }
                            String qualifier = GroovyUtils.splitName((ClassNode)type)[0].replace('$', '.');
                            if (prefix.length() > 0 && (matcher = (pattern = Pattern.compile("^" + Pattern.quote(prefix) + "\\p{javaJavaIdentifierPart}*")).matcher(qualifier)).find()) {
                                IType it = compilationUnit.getJavaProject().findType(matcher.group());
                                if (it == null) {
                                    return null;
                                }
                                importRewrite.addImport(matcher.group());
                                return new DeleteEdit(typeStart, this.endOffsetMinus(selectRegion.getEnd()) - typeStart);
                            }
                            prefix = compilationUnit.getSource().substring(typeStart, this.endOffsetPlus(selectRegion.getEnd()));
                            pattern = Pattern.compile("\\b" + Pattern.quote(prefix) + "$");
                            matcher = pattern.matcher(qualifier);
                            if (matcher.find()) {
                                importRewrite.addImport(qualifier);
                                return new RangeMarker(typeStart, nameStart - typeStart);
                            }
                        }
                    }
                    if (node instanceof ConstantExpression) {
                        MethodCallExpression call;
                        IASTFragment fragment = new FindSurroundingNode(new Region(node)).doVisitSurroundingNode(moduleNode);
                        if (fragment.kind() == ASTFragmentKind.PROPERTY) {
                            Expression expr = fragment.getAssociatedExpression();
                            if (expr instanceof ClassExpression) {
                                importRewrite.addStaticImport(expr.getType().getName().replace('$', '.'), this.propertyName(node), true);
                                return new DeleteEdit(expr.getStart(), expr.getLength() + 1);
                            }
                            if (expr instanceof VariableExpression) {
                                TypeNameMatch choice = this.findCandidateTypes(((VariableExpression)expr).getName(), expr.getStart(), monitor);
                                importRewrite.addStaticImport(choice.getFullyQualifiedName(), node.getText(), true);
                                return new DeleteEdit(expr.getStart(), expr.getLength() + 1);
                            }
                        }
                        if (fragment.kind() == ASTFragmentKind.METHOD_CALL && (call = (MethodCallExpression)fragment.getAssociatedNode()) != null && !call.isUsingGenerics()) {
                            Expression expr = call.getObjectExpression();
                            if (expr instanceof ClassExpression) {
                                importRewrite.addStaticImport(expr.getType().getName().replace('$', '.'), call.getMethodAsString(), false);
                                return new DeleteEdit(expr.getStart(), call.getMethod().getStart() - expr.getStart());
                            }
                            if (expr instanceof VariableExpression) {
                                TypeNameMatch choice = this.findCandidateTypes(((VariableExpression)expr).getName(), expr.getStart(), monitor);
                                importRewrite.addStaticImport(choice.getFullyQualifiedName(), call.getMethodAsString(), false);
                                return new DeleteEdit(expr.getStart(), call.getMethod().getStart() - expr.getStart());
                            }
                        }
                    }
                }
                return null;
            }

            private TypeNameMatch findCandidateTypes(String typeName, int typeStart, IProgressMonitor monitor) throws CoreException {
                boolean isAnnotation = '@' == compilationUnit.getContents()[Math.max(0, typeStart - 1)];
                TypeSearch.UnresolvedTypeData typeData = new TypeSearch.UnresolvedTypeData(typeName, isAnnotation, (ISourceRange)new SourceRange(typeStart, typeName.length()));
                new TypeSearch().searchForTypes(compilationUnit, Collections.singletonMap(typeName, typeData), monitor);
                List<TypeNameMatch> typesFound = typeData.getFoundInfos();
                if (typesFound.isEmpty()) {
                    this.fStatus = JavaUIStatus.createError((int)4, (String)CodeGenerationMessages.bind((String)CodeGenerationMessages.AddImportsOperation_error_notresolved_message, (Object)BasicElementLabels.getJavaElementName((String)typeName)), null);
                    throw new OperationCanceledException();
                }
                TypeNameMatch choice = typeQuery.chooseImport(typesFound.toArray(new TypeNameMatch[typesFound.size()]), typeName);
                if (choice == null) {
                    throw new OperationCanceledException();
                }
                return choice;
            }

            private int startOffset(ASTNode node, ASTNodeFinder nodeFinder) throws CoreException {
                Region nodeRegion;
                int start = node.getStart();
                if (node.getEnd() < 1 && (nodeRegion = (Region)ReflectionUtils.getPrivateField(ASTNodeFinder.class, (String)"sloc", (Object)nodeFinder)) != null) {
                    start = nodeRegion.getOffset();
                    while (!Character.isJavaIdentifierStart(compilationUnit.getSource().charAt(start))) {
                        ++start;
                    }
                }
                return start;
            }

            private int endOffset(ASTNode node, ASTNodeFinder nodeFinder) throws CoreException {
                Region nodeRegion;
                int end = node.getEnd();
                if (end < 1 && (nodeRegion = (Region)ReflectionUtils.getPrivateField(ASTNodeFinder.class, (String)"sloc", (Object)nodeFinder)) != null) {
                    end = nodeRegion.getEnd();
                    while (end > 0 && !Character.isJavaIdentifierPart(compilationUnit.getSource().charAt(end - 1))) {
                        --end;
                    }
                }
                return end;
            }

            private int endOffsetPlus(int end) throws CoreException {
                while (Character.isJavaIdentifierPart(compilationUnit.getSource().charAt(end))) {
                    ++end;
                }
                return end;
            }

            private int endOffsetMinus(int end) throws CoreException {
                while (end > 0 && Character.isJavaIdentifierPart(compilationUnit.getSource().charAt(end - 1))) {
                    --end;
                }
                return end;
            }

            private ClassNode componentType(ASTNode node) {
                ClassNode type = node instanceof ClassNode ? (ClassNode)node : ((Expression)node).getType();
                return type.getComponentType() != null ? this.componentType((ASTNode)type.getComponentType()) : type;
            }

            private String propertyName(ASTNode node) {
                TypeLookupResult[] result = new TypeLookupResult[1];
                new TypeInferencingVisitorFactory().createVisitor(compilationUnit).visitCompilationUnit((n, r, e) -> {
                    if (n == node) {
                        typeLookupResultArray[0] = r;
                        return ITypeRequestor.VisitStatus.STOP_VISIT;
                    }
                    return ITypeRequestor.VisitStatus.CONTINUE;
                });
                if (result[0] != null && result[0].declaration instanceof MethodNode) {
                    return ((MethodNode)result[0].declaration).getName();
                }
                return node.getText();
            }
        };
    }

    protected static void applyEdit(ICompilationUnit cu, TextEdit edit, boolean save, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)CorextMessages.JavaModelUtil_applyedit_operation, (int)2);
        IFile file = (IFile)cu.getResource();
        if (!save || !file.exists()) {
            cu.applyTextEdit(edit, (IProgressMonitor)subMonitor.split(2));
        } else {
            IStatus status = Resources.makeCommittable((IResource)file, null);
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            cu.applyTextEdit(edit, (IProgressMonitor)subMonitor.split(1));
            cu.save((IProgressMonitor)subMonitor.split(1), true);
        }
    }
}

