/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.core.builder.GroovyClasspathContainer;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.preferences.Messages;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GroovyLibrariesContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IClasspathEntry containerEntry;
    private IJavaProject javaProject;
    private boolean isMinimal;
    private String userLibs;

    public GroovyLibrariesContainerPage() {
        super("GroovyLibrariesContainerPage", "Groovy Libraries", JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.setDescription(MessageFormat.format(Messages.getString("GroovyLibrariesPreferencesPage.Description"), this.getTitle()));
    }

    public void initialize(IJavaProject javaProject, IClasspathEntry[] entries) {
        this.javaProject = javaProject;
        this.userLibs = GroovyClasspathContainer.getLegacyUserLibsPreference((IJavaProject)this.javaProject);
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.isMinimal = Optional.ofNullable(containerEntry).filter(GroovyClasspathContainer::hasMinimalAttribute).isPresent();
        if (!this.isMinimal && containerEntry != null) {
            if (containerEntry.getPath().lastSegment().equals("user-libs=true")) {
                this.userLibs = "true";
            } else if (containerEntry.getPath().lastSegment().equals("user-libs=false")) {
                this.userLibs = "false";
            }
        }
    }

    public void createControl(Composite parent) {
        SelectionListener minimalListener = this.createSelectionListener(data -> {
            boolean bl = this.isMinimal = ((Boolean)data).booleanValue();
        });
        SelectionListener userLibListener = this.createSelectionListener(data -> {
            String string = this.userLibs = (String)data;
        });
        Composite panel = new Composite(parent, 0);
        panel.setFont(parent.getFont());
        panel.setLayout((Layout)new GridLayout());
        this.setControl((Control)panel);
        Group group = this.createControlGroup(panel);
        group.setText(Messages.getString("GroovyLibrariesPreferencesPage.OsgiLibsGroup"));
        Label label = new Label((Composite)group, 64);
        label.setText(Messages.getString("GroovyLibrariesPreferencesPage.OsgiLibsLabel"));
        Button button = new Button((Composite)group, 16);
        button.setData((Object)Boolean.FALSE);
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setSelection(!this.isMinimal);
        button.addSelectionListener(minimalListener);
        button.setText(MessageFormat.format(Messages.getString("GroovyLibrariesPreferencesPage.OsgiLibsChoiceY"), CompilerUtils.getExtraJarsForClasspath().stream().map(jar -> jar.toFile().getName()).collect(Collectors.joining(", "))));
        button = new Button((Composite)group, 16);
        button.setData((Object)Boolean.TRUE);
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setSelection(this.isMinimal);
        button.addSelectionListener(minimalListener);
        button.setText(Messages.getString("GroovyLibrariesPreferencesPage.OsgiLibsChoiceN"));
        group = this.createControlGroup(panel);
        group.setText(Messages.getString("GroovyLibrariesPreferencesPage.UserLibsGroup"));
        label = new Label((Composite)group, 64);
        label.setText(Messages.getString("GroovyLibrariesPreferencesPage.UserLibsLabel"));
        button = new Button((Composite)group, 16);
        button.setData((Object)"default");
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setSelection(button.getData().equals(this.userLibs));
        button.addSelectionListener(userLibListener);
        button.setText(Messages.getString("GroovyLibrariesPreferencesPage.UserLibsChoiceX"));
        button = new Button((Composite)group, 16);
        button.setData((Object)"true");
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setSelection(button.getData().equals(this.userLibs));
        button.addSelectionListener(userLibListener);
        button.setText(Messages.getString("GroovyLibrariesPreferencesPage.UserLibsChoiceY"));
        button = new Button((Composite)group, 16);
        button.setData((Object)"false");
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setSelection(button.getData().equals(this.userLibs));
        button.addSelectionListener(userLibListener);
        button.setText(Messages.getString("GroovyLibrariesPreferencesPage.UserLibsChoiceN"));
    }

    private Group createControlGroup(Composite parent) {
        Group group = new Group(parent, 32);
        group.setFont(parent.getFont());
        group.setLayout((Layout)new GridLayout());
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).indent(0, 7).applyTo((Control)group);
        return group;
    }

    private SelectionListener createSelectionListener(final Consumer<Object> consumer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    consumer.accept(event.widget.getData());
                }
            }
        };
    }

    public boolean finish() {
        this.containerEntry = GroovyRuntime.newGroovyClasspathContainerEntry((boolean)this.isMinimal, (boolean)JavaRuntime.isModularProject((IJavaProject)this.javaProject), "default".equals(this.userLibs) ? null : Boolean.valueOf(this.userLibs));
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.containerEntry;
    }
}

