/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import groovy.lang.Tuple2;
import java.util.Arrays;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.editor.GroovyColorManager;
import org.codehaus.groovy.eclipse.preferences.FieldEditorOverlayPage;
import org.codehaus.groovy.eclipse.preferences.Messages;
import org.eclipse.debug.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.osgi.framework.Version;

public class GroovyEditorPreferencesPage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    public GroovyEditorPreferencesPage() {
        super(1);
        this.setPreferenceStore(GroovyPlugin.getDefault().getPreferenceStore());
    }

    @Override
    protected String getPageId() {
        return "org.codehaus.groovy.eclipse.preferences.editor";
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.createColorEditor(parent, "groovy.editor.highlight.gjdk.color", "GroovyEditorPreferencesPage.GJDK_method_color");
        Tuple2<ColorFieldEditor, BooleanFieldEditor2> primitivesEditor = this.createColorEditor(parent, "groovy.editor.highlight.javatypes.color", "GroovyEditorPreferencesPage.Primitives_color");
        Tuple2<ColorFieldEditor, BooleanFieldEditor2> keywordEditor = this.createColorEditor(parent, "groovy.editor.highlight.javakeywords.color", "GroovyEditorPreferencesPage.Keywords_color");
        Tuple2<ColorFieldEditor, BooleanFieldEditor2> assertEditor = this.createColorEditor(parent, "groovy.editor.highlight.assert.color", "GroovyEditorPreferencesPage.Assert_color");
        Tuple2<ColorFieldEditor, BooleanFieldEditor2> returnEditor = this.createColorEditor(parent, "groovy.editor.highlight.return.color", "GroovyEditorPreferencesPage.Return_color");
        Button javaColorButton = new Button(parent, 524288);
        javaColorButton.setText(Messages.getString("GroovyEditorPreferencesPage.Copy_Java_Color_Preferences"));
        javaColorButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            Arrays.asList(primitivesEditor, keywordEditor, assertEditor).forEach(tuple -> this.copyColorAndStyle((Tuple2<ColorFieldEditor, BooleanFieldEditor2>)tuple, store, "java_keyword"));
            this.copyColorAndStyle(returnEditor, store, "java_keyword_return");
        }));
        GridDataFactory.swtDefaults().align(16384, 128).indent(0, 7).span(2, 1).applyTo((Control)javaColorButton);
        this.createSemanticHighlightingEditors(parent);
        if (JavaPlugin.getDefault().getBundle().getVersion().compareTo(new Version(3, 16, 0)) >= 0) {
            this.createPreferencePageLink(parent, "org.eclipse.jdt.ui.preferences.JavaEditorCodeMiningPreferencePage", Messages.getString("GroovyEditorPreferencesPage.InheritedJavaMiningsDescription"));
        }
    }

    private void createSemanticHighlightingEditors(Composite parent) {
        Group group = new Group(parent, 32);
        group.setFont(group.getParent().getFont());
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.getString("GroovyEditorPreferencesPage.SemanticHighlightingPrefs"));
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).indent(0, 7).span(2, 1).applyTo((Control)group);
        Composite panel = new Composite((Composite)group, 0);
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.semantic.highlighting", Messages.getString("GroovyEditorPreferencesPage.SemanticHighlightingToggle"), panel));
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.editor.highlight.slashy", Messages.getString("GroovyEditorPreferencesPage.DollarSlashyHighlightingToggle"), panel));
        this.createPreferencePageLink(panel, "org.eclipse.jdt.ui.preferences.JavaEditorColoringPreferencePage", Messages.getString("GroovyEditorPreferencesPage.InheritedJavaColorsDescription"));
    }

    private void createPreferencePageLink(Composite parent, String pageId, String linkText) {
        PreferenceLinkArea area = new PreferenceLinkArea(parent, 64, pageId, linkText, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridDataFactory.swtDefaults().indent(0, 7).span(2, 1).applyTo(area.getControl());
    }

    private Tuple2<ColorFieldEditor, BooleanFieldEditor2> createColorEditor(Composite parent, String preference, String nls) {
        Tuple2 editors = new Tuple2((Object)new ColorFieldEditor(preference, Messages.getString(nls), parent), (Object)new BooleanFieldEditor2(String.valueOf(preference) + "_bold", "  " + Messages.getString("GroovyEditorPreferencesPage.BoldToggle"), 1, parent));
        this.addField((FieldEditor)editors.getFirst());
        this.addField((FieldEditor)editors.getSecond());
        return editors;
    }

    private void copyColorAndStyle(Tuple2<ColorFieldEditor, BooleanFieldEditor2> tuple, IPreferenceStore store, String pref) {
        ((ColorFieldEditor)tuple.getFirst()).getColorSelector().setColorValue(PreferenceConverter.getColor((IPreferenceStore)store, (String)pref));
        ((BooleanFieldEditor2)tuple.getSecond()).getChangeControl(null).setSelection(store.getBoolean(String.valueOf(pref) + "_bold"));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        boolean success = super.performOk();
        if (success) {
            GroovyColorManager colorManager = GroovyPlugin.getDefault().getTextTools().getColorManager();
            colorManager.uninitialize();
            colorManager.initialize();
        }
        return success;
    }
}

