/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.highlighting;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.editor.highlighting.HighlightedTypedPosition;
import org.codehaus.groovy.eclipse.editor.highlighting.SemanticReferenceRequestor;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class SemanticHighlightingReferenceRequestor
extends SemanticReferenceRequestor {
    private static final Position NO_POSITION = new Position(0);
    private char[] contents;
    private final GroovyCompilationUnit unit;
    private Position lastGString = NO_POSITION;
    private static final boolean DEBUG = false;
    protected final SortedSet<HighlightedTypedPosition> typedPositions = new TreeSet<HighlightedTypedPosition>((p1, p2) -> {
        int result = p1.compareTo((Position)p2);
        if (result == 0) {
            int y;
            int x = p1.kind.ordinal();
            result = x < (y = p2.kind.ordinal()) ? -1 : (x == y ? 0 : 1);
        }
        return result;
    });

    static {
        NO_POSITION.delete();
    }

    public SemanticHighlightingReferenceRequestor(GroovyCompilationUnit unit) {
        this.unit = unit;
    }

    private int unitLength() {
        if (this.contents == null) {
            this.contents = this.unit.getContents();
        }
        return this.contents.length;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (!(node instanceof AnnotatedNode) || node instanceof ImportNode || this.endOffset(node, result) < 1) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        HighlightedTypedPosition pos = null;
        if (result.confidence == TypeLookupResult.TypeConfidence.UNKNOWN && node.getEnd() > 0) {
            if (this.isRealASTNode(node) || node.getText().contains("trait$super$")) {
                Position p = SemanticHighlightingReferenceRequestor.getPosition(node);
                this.typedPositions.add(new HighlightedTypedPosition(p, HighlightedTypedPosition.HighlightKind.UNKNOWN));
                return ITypeRequestor.VisitStatus.CANCEL_BRANCH;
            }
        } else if (!(node instanceof ClassExpression) && GroovyUtils.isDeprecated((ASTNode)result.declaration)) {
            pos = new HighlightedTypedPosition(SemanticHighlightingReferenceRequestor.getPosition(node), HighlightedTypedPosition.HighlightKind.DEPRECATED);
            if (node instanceof ClassNode && ((ClassNode)node).getNameEnd() < 1) {
                int offset = pos.getOffset();
                int length = pos.getLength();
                if (offset >= 0 && length > 0 && offset + length < this.unitLength()) {
                    offset = CharOperation.lastIndexOf((char)'.', (char[])this.contents, (int)offset, (int)(offset + length));
                    if (offset++ > pos.getOffset()) {
                        pos.setLength(length - (offset - pos.getOffset()));
                        pos.setOffset(offset);
                    }
                }
            }
        } else if (node instanceof ClassNode) {
            if (((ClassNode)node).getNameEnd() < 1) {
                this.checkOuterClass(result.type, outer -> this.acceptASTNode((ASTNode)outer, new TypeLookupResult(outer, outer, (ASTNode)outer, TypeLookupResult.TypeConfidence.EXACT, typeLookupResult.scope), enclosingElement));
            }
            if (!(enclosingElement instanceof IImportDeclaration) && !((ClassNode)node).isScriptBody()) {
                pos = this.handleClassReference((ClassNode)node, result.type);
            }
        } else if (result.declaration instanceof FieldNode) {
            pos = this.handleFieldOrProperty((AnnotatedNode)node, result.declaration);
        } else if (result.declaration instanceof PropertyNode) {
            pos = !((PropertyNode)result.declaration).getField().hasNoRealSourcePosition() ? this.handleFieldOrProperty((AnnotatedNode)node, result.declaration) : new HighlightedTypedPosition(node.getStart(), node.getLength(), ((PropertyNode)result.declaration).isSynthetic() ? HighlightedTypedPosition.HighlightKind.MAP_KEY : (((PropertyNode)result.declaration).isStatic() ? HighlightedTypedPosition.HighlightKind.STATIC_CALL : HighlightedTypedPosition.HighlightKind.METHOD_CALL));
        } else if (node instanceof MethodNode) {
            pos = result.enclosingAnnotation == null ? this.handleMethodDeclaration((MethodNode)node) : this.handleAnnotationElement(result.enclosingAnnotation, (MethodNode)node);
        } else if (node instanceof ConstructorCallExpression) {
            pos = this.handleMethodReference((ConstructorCallExpression)node);
        } else if (!(node instanceof MethodCallExpression)) {
            if (node instanceof StaticMethodCallExpression) {
                pos = this.handleMethodReference((StaticMethodCallExpression)node);
            } else if (!(node instanceof MethodPointerExpression)) {
                ASTNode var;
                if (node instanceof Parameter) {
                    ASTNode var2 = (ASTNode)node.getNodeMetaData((Object)"reserved.type.name");
                    if (var2 != null) {
                        this.typedPositions.add(new HighlightedTypedPosition(var2.getStart(), var2.getLength(), HighlightedTypedPosition.HighlightKind.RESERVED));
                    }
                    pos = this.handleParameterReference((Parameter)node, result.scope);
                } else if (node instanceof VariableExpression) {
                    pos = result.declaration instanceof MethodNode ? this.handleMethodReference((Expression)node, result, false) : this.handleVariableExpression((VariableExpression)node, result.scope, enclosingElement);
                } else if (node instanceof ConstantExpression) {
                    if (result.declaration instanceof MethodNode) {
                        if (((MethodNode)result.declaration).isSynthetic() && !((MethodNode)result.declaration).getName().equals(node.getText())) {
                            pos = this.handleFieldOrProperty((AnnotatedNode)((Expression)node), result.declaration);
                        } else {
                            boolean isStaticImport = enclosingElement instanceof ImportDeclaration;
                            pos = this.handleMethodReference((Expression)node, result, isStaticImport);
                        }
                    } else if (result.declaration instanceof VariableExpression) {
                        pos = new HighlightedTypedPosition(node.getStart(), node.getLength(), HighlightedTypedPosition.HighlightKind.VARIABLE);
                    } else {
                        pos = this.handleConstantExpression((ConstantExpression)node);
                        try {
                            if (pos != null && pos.kind == HighlightedTypedPosition.HighlightKind.REGEXP && (Pattern.compile(node.getText()).flags() & 4) != 0) {
                                int idx = this.contents[node.getStart()] == '$' ? 2 : 1;
                                String pat = String.valueOf(this.contents, node.getStart(), node.getLength() - idx);
                                while ((idx = pat.indexOf(35, idx)) > 0) {
                                    if (pat.charAt(idx - 1) == '\\') continue;
                                    int i = idx;
                                    int j = idx = pat.indexOf(10, idx);
                                    int offset = node.getStart() + i;
                                    int length = (j == -1 ? pat.length() : j) - i;
                                    this.typedPositions.add(new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.COMMENT));
                                }
                            }
                        }
                        catch (PatternSyntaxException idx) {}
                    }
                } else if (node instanceof GStringExpression) {
                    pos = this.handleGStringExpression((GStringExpression)node);
                } else if (node instanceof MapEntryExpression) {
                    pos = this.handleMapEntryExpression((MapEntryExpression)node);
                } else if (node instanceof DeclarationExpression && (var = (ASTNode)node.getNodeMetaData((Object)"reserved.type.name")) != null) {
                    pos = new HighlightedTypedPosition(var.getStart(), var.getLength(), HighlightedTypedPosition.HighlightKind.RESERVED);
                }
            }
        }
        if (pos != null && pos.getLength() > 0 && (node instanceof Expression || pos.getOffset() > 0 || pos.getLength() > 1)) {
            this.typedPositions.add(pos);
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private void checkOuterClass(ClassNode node, Consumer<ClassNode> todo) {
        ClassNode outer = node.getOuterClass();
        if (outer != null) {
            int start = node.getStart();
            int until = node.getEnd();
            if (until < this.unitLength() && (until = CharOperation.lastIndexOf((char)'.', (char[])this.contents, (int)start, (int)until)) > start) {
                outer = outer.getPlainNodeReference();
                outer.setStart(start);
                outer.setEnd(until);
                start = CharOperation.lastIndexOf((char)'.', (char[])this.contents, (int)start, (int)until);
                if (start > 0) {
                    outer.setNameStart2(start + 1);
                }
                todo.accept(outer);
            }
        }
    }

    private HighlightedTypedPosition handleClassReference(ClassNode node, ClassNode type) {
        int length;
        int offset;
        if (node.getNameEnd() > 0) {
            offset = node.getNameStart();
            length = node.getNameEnd() - offset + 1;
        } else {
            if (node.getStart() > 0 && node.getStart() < this.unitLength() && this.contents[node.getStart() - 1] == '@') {
                return null;
            }
            offset = node.getNameStart2();
            length = node.getEnd() - offset;
        }
        HighlightedTypedPosition.HighlightKind kind = type.isEnum() ? HighlightedTypedPosition.HighlightKind.ENUMERATION : (type.isGenericsPlaceHolder() ? HighlightedTypedPosition.HighlightKind.PLACEHOLDER : (type.isAnnotationDefinition() ? HighlightedTypedPosition.HighlightKind.ANNOTATION : (type.isInterface() ? (Traits.isTrait((ClassNode)type) ? HighlightedTypedPosition.HighlightKind.TRAIT : HighlightedTypedPosition.HighlightKind.INTERFACE) : (type.isAbstract() ? HighlightedTypedPosition.HighlightKind.ABSTRACT_CLASS : HighlightedTypedPosition.HighlightKind.CLASS))));
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleFieldOrProperty(AnnotatedNode node, ASTNode decl) {
        int length;
        int offset;
        HighlightedTypedPosition.HighlightKind kind = !SemanticHighlightingReferenceRequestor.isStatic(decl) ? HighlightedTypedPosition.HighlightKind.FIELD : (!SemanticHighlightingReferenceRequestor.isFinal(decl) ? HighlightedTypedPosition.HighlightKind.STATIC_FIELD : HighlightedTypedPosition.HighlightKind.STATIC_VALUE);
        if (node == decl) {
            offset = node.getNameStart();
            length = node.getNameEnd() - offset + 1;
        } else {
            offset = node.getStart();
            length = node.getLength();
        }
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleAnnotationElement(AnnotationNode anno, MethodNode elem) {
        try {
            int start = anno.getStart();
            int until = anno.getEnd();
            String source = this.unit.getSource().substring(start, until);
            Matcher m = Pattern.compile("\\b" + Pattern.quote(elem.getName()) + "\\b").matcher(source);
            if (m.find()) {
                return new HighlightedTypedPosition(start + m.start(), elem.getName().length(), HighlightedTypedPosition.HighlightKind.TAG_KEY);
            }
        }
        catch (Exception e) {
            Util.log((Throwable)e);
        }
        return null;
    }

    private HighlightedTypedPosition handleMethodDeclaration(MethodNode node) {
        HighlightedTypedPosition.HighlightKind kind = node instanceof ConstructorNode ? HighlightedTypedPosition.HighlightKind.CTOR : (!SemanticHighlightingReferenceRequestor.isStatic((ASTNode)node) ? HighlightedTypedPosition.HighlightKind.METHOD : HighlightedTypedPosition.HighlightKind.STATIC_METHOD);
        int offset = node.getNameStart();
        int length = node.getNameEnd() - offset + 1;
        if (kind != HighlightedTypedPosition.HighlightKind.CTOR && length > node.getName().length()) {
            return null;
        }
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleMethodReference(MethodCallExpression expr) {
        HighlightedTypedPosition.HighlightKind kind = expr.getObjectExpression() instanceof ClassExpression ? HighlightedTypedPosition.HighlightKind.STATIC_CALL : HighlightedTypedPosition.HighlightKind.METHOD_CALL;
        int offset = expr.getMethod().getStart();
        int length = expr.getMethod().getLength();
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleMethodReference(ConstructorCallExpression expr) {
        if (expr.isSpecialCall()) {
            return null;
        }
        int offset = Math.max(expr.getNameStart(), expr.getType().getNameStart2());
        int length = expr.getNameEnd() - offset + 1;
        return new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.CTOR_CALL);
    }

    private HighlightedTypedPosition handleMethodReference(StaticMethodCallExpression expr) {
        int offset = expr.getNameStart();
        int length = expr.getNameEnd() - offset + 1;
        return new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.STATIC_CALL);
    }

    private HighlightedTypedPosition handleMethodReference(MethodPointerExpression expr) {
        HighlightedTypedPosition.HighlightKind kind = expr.getExpression() instanceof ClassExpression ? HighlightedTypedPosition.HighlightKind.STATIC_CALL : HighlightedTypedPosition.HighlightKind.METHOD_CALL;
        int offset = expr.getMethodName().getStart();
        int length = expr.getMethodName().getLength();
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleMethodReference(Expression expr, TypeLookupResult result, boolean isStaticImport) {
        int length;
        int offset;
        HighlightedTypedPosition.HighlightKind kind = HighlightedTypedPosition.HighlightKind.METHOD_CALL;
        if (result.isGroovy) {
            kind = HighlightedTypedPosition.HighlightKind.GROOVY_CALL;
        } else if (isStaticImport || ((MethodNode)result.declaration).isStatic()) {
            kind = HighlightedTypedPosition.HighlightKind.STATIC_CALL;
        }
        if (expr.getNameEnd() < 1) {
            offset = expr.getStart();
            length = expr.getLength();
        } else {
            offset = expr.getNameStart();
            length = expr.getNameEnd() - offset + 1;
        }
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleParameterReference(Parameter param, VariableScope scope) {
        HighlightedTypedPosition.HighlightKind kind = SemanticHighlightingReferenceRequestor.isCatchParam((Variable)param, scope) || SemanticHighlightingReferenceRequestor.isForLoopParam((Variable)param, scope) ? HighlightedTypedPosition.HighlightKind.VARIABLE : HighlightedTypedPosition.HighlightKind.PARAMETER;
        return new HighlightedTypedPosition(param.getNameStart(), param.getNameEnd() - param.getNameStart() + 1, kind);
    }

    private HighlightedTypedPosition handleVariableExpression(VariableExpression expr, VariableScope scope, IJavaElement source) {
        boolean isSuperOrThis;
        boolean isParam = expr.getAccessedVariable() instanceof Parameter && !SemanticHighlightingReferenceRequestor.isForLoopParam(expr.getAccessedVariable(), scope) && !SemanticHighlightingReferenceRequestor.isCatchParam(expr.getAccessedVariable(), scope);
        boolean isIt = isParam && "it".equals(expr.getName()) && ((Parameter)expr.getAccessedVariable()).getLineNumber() <= 0;
        boolean bl = isSuperOrThis = "super".equals(expr.getName()) || "this".equals(expr.getName());
        if (!(isSuperOrThis && !this.lastGString.includes(expr.getStart()) || isParam && !isIt && ((Parameter)expr.getAccessedVariable()).getLineNumber() <= 0 && !(source instanceof SourceType))) {
            HighlightedTypedPosition.HighlightKind kind = isParam ? (isIt ? HighlightedTypedPosition.HighlightKind.GROOVY_CALL : HighlightedTypedPosition.HighlightKind.PARAMETER) : (isSuperOrThis ? HighlightedTypedPosition.HighlightKind.KEYWORD : HighlightedTypedPosition.HighlightKind.VARIABLE);
            return new HighlightedTypedPosition(expr.getStart(), expr.getLength(), kind);
        }
        return null;
    }

    private HighlightedTypedPosition handleConstantExpression(ConstantExpression expr) {
        if (SemanticHighlightingReferenceRequestor.isNumber(expr.getType())) {
            return new HighlightedTypedPosition(expr.getStart(), expr.getLength(), HighlightedTypedPosition.HighlightKind.NUMBER);
        }
        if (!this.lastGString.includes(expr.getStart()) && this.isSlashy((Expression)expr)) {
            return new HighlightedTypedPosition(expr.getStart(), expr.getLength(), HighlightedTypedPosition.HighlightKind.REGEXP);
        }
        return null;
    }

    private HighlightedTypedPosition handleGStringExpression(GStringExpression expr) {
        boolean isTriple;
        this.lastGString = new Position(expr.getStart(), expr.getLength());
        boolean isSlashy = this.isSlashy((Expression)expr);
        boolean bl = isTriple = !isSlashy && this.isTriple((Expression)expr);
        int pre = isTriple ? 3 : (this.contents[expr.getStart()] == '$' ? 2 : 1);
        for (ConstantExpression string : expr.getStrings()) {
            int offset = string.getStart() + pre;
            int length = string.getLength() - pre;
            if (string != DefaultGroovyMethods.last((List)expr.getStrings())) {
                pre = this.contents[offset + length - 1] == '{' ? 2 : 1;
            } else {
                int n = isTriple ? 3 : (pre = this.contents[expr.getStart()] == '$' ? 2 : 1);
            }
            if ((length -= pre) > 0 && this.lastGString.includes(offset + length)) {
                this.typedPositions.add(new HighlightedTypedPosition(offset, length, isSlashy ? HighlightedTypedPosition.HighlightKind.REGEXP : HighlightedTypedPosition.HighlightKind.STRING));
            }
            --pre;
        }
        return new HighlightedTypedPosition(this.lastGString, HighlightedTypedPosition.HighlightKind.GROOVY_CALL);
    }

    private HighlightedTypedPosition handleMapEntryExpression(MapEntryExpression expr) {
        Expression key = expr.getKeyExpression();
        if (key instanceof ConstantExpression && key.getEnd() > 0 && key.getStart() == expr.getStart()) {
            char c;
            this.unitLength();
            if (key.getStart() < this.contents.length && (c = this.contents[key.getStart()]) != '\'' && c != '\"' && c != '/') {
                return new HighlightedTypedPosition(key.getStart(), key.getLength(), HighlightedTypedPosition.HighlightKind.MAP_KEY);
            }
        }
        return null;
    }

    private int endOffset(ASTNode node, TypeLookupResult result) {
        int offset = node.getEnd();
        if (result.enclosingAnnotation != null) {
            offset = result.enclosingAnnotation.getEnd();
        }
        return offset;
    }

    private boolean isRealASTNode(ASTNode node) {
        String text = node.getText();
        if (text.length() != node.getLength()) {
            return false;
        }
        int contentsLength = this.unitLength();
        char[] textArr = text.toCharArray();
        int i = 0;
        int j = node.getStart();
        while (i < textArr.length && j < contentsLength) {
            if (textArr[i] != this.contents[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private boolean isSlashy(Expression expr) {
        if (expr.getStart() < expr.getEnd() && expr.getEnd() <= this.unitLength()) {
            boolean dollar;
            boolean slashy = this.contents[expr.getStart()] == '/' && this.contents[expr.getEnd() - 1] == '/';
            boolean bl = dollar = !slashy && this.contents[expr.getStart()] == '$' && this.contents[expr.getStart() + 1] == '/' && this.contents[expr.getEnd() - 2] == '/' && this.contents[expr.getEnd() - 1] == '$';
            if (slashy || dollar) {
                return true;
            }
        }
        return false;
    }

    private boolean isTriple(Expression expr) {
        if (expr.getStart() < expr.getEnd() && expr.getEnd() <= this.unitLength()) {
            String source = String.valueOf(this.contents, expr.getStart(), expr.getLength());
            return source.startsWith("\"\"\"");
        }
        return false;
    }
}

