/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Comment;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.transform.trait.Traits;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.groovy.core.util.DepthFirstVisitor;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.ui.text.folding.DefaultJavaFoldingStructureProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.ITextEditor;

public class GroovyAwareFoldingStructureProvider
extends DefaultJavaFoldingStructureProvider {
    protected GroovyEditor editor;

    public void install(ITextEditor editor, ProjectionViewer viewer) {
        super.install(editor, viewer);
        if (editor instanceof GroovyEditor) {
            this.editor = (GroovyEditor)editor;
        }
    }

    public void uninstall() {
        this.editor = null;
        super.uninstall();
    }

    protected void computeFoldingStructure(IJavaElement element, DefaultJavaFoldingStructureProvider.FoldingStructureComputationContext context) {
        if (this.editor != null && this.editor.getModuleNode() != null) {
            if (this.isMainType(element)) {
                this.computeClosureFoldingStructure(element, context);
            } else if (this.isScriptMethod(element)) {
                this.computeCommentFoldingStructure(element, context);
                return;
            }
            if (element instanceof IType) {
                this.computeTraitMethodFoldingStructure((IType)element, context);
            }
        }
        super.computeFoldingStructure(element, context);
    }

    protected void computeClosureFoldingStructure(final IJavaElement element, final DefaultJavaFoldingStructureProvider.FoldingStructureComputationContext context) {
        DepthFirstVisitor visitor = new DepthFirstVisitor(){

            public void visitClosureExpression(ClosureExpression expression) {
                Position position;
                IRegion normalized;
                if (expression.getEnd() > 0 && (normalized = GroovyAwareFoldingStructureProvider.this.alignRegion((IRegion)new Region(expression.getStart(), expression.getLength()), context)) != null && (position = GroovyAwareFoldingStructureProvider.this.createMemberPosition(normalized, (IMember)element)) != null) {
                    boolean isCollapsed = false;
                    boolean isComment = false;
                    context.addProjectionRange(new DefaultJavaFoldingStructureProvider.JavaProjectionAnnotation(isCollapsed, element, isComment), position);
                }
                super.visitClosureExpression(expression);
            }
        };
        visitor.visitModule(this.editor.getModuleNode());
    }

    protected void computeCommentFoldingStructure(IJavaElement element, DefaultJavaFoldingStructureProvider.FoldingStructureComputationContext context) {
        for (Comment comment : this.editor.getModuleNode().getContext().getComments()) {
            if (comment.isJavadoc() || comment.eline <= comment.sline) continue;
            try {
                Position position;
                IDocument document = GroovyAwareFoldingStructureProvider.getDocument(context);
                int offset = document.getLineOffset(comment.sline - 1) + (comment.scol - 1);
                int length = document.getLineOffset(comment.eline - 1) + (comment.ecol - 1) - offset;
                IRegion normalized = this.alignRegion((IRegion)new Region(offset, length), context);
                if (normalized == null || !this.isScriptMethodElement(normalized) || (position = this.createCommentPosition(normalized)) == null) continue;
                boolean isCollapsed = false;
                boolean isComment = true;
                context.addProjectionRange(new DefaultJavaFoldingStructureProvider.JavaProjectionAnnotation(isCollapsed, element, isComment), position);
            }
            catch (BadLocationException e) {
                GroovyPlugin.getDefault().logError("Failed to compute region for comment", e);
            }
        }
    }

    protected void computeTraitMethodFoldingStructure(IType maybeTrait, DefaultJavaFoldingStructureProvider.FoldingStructureComputationContext context) {
        this.findType(maybeTrait).filter(Traits::isTrait).ifPresent(traitType -> {
            List traitMethods = (List)traitType.getNodeMetaData((Object)"trait.methods");
            if (traitMethods != null && !traitMethods.isEmpty()) {
                for (MethodNode traitMethod : traitMethods) {
                    IMethod method;
                    Position position;
                    IRegion normalized = this.alignRegion((IRegion)new Region(traitMethod.getStart(), traitMethod.getLength()), context);
                    if (normalized == null || (position = this.createMemberPosition(normalized, (IMember)(method = maybeTrait.getMethod(traitMethod.getName(), GroovyUtils.getParameterTypeSignatures((MethodNode)traitMethod, (boolean)true))))) == null) continue;
                    boolean isCollapsed = false;
                    boolean isComment = false;
                    context.addProjectionRange(new DefaultJavaFoldingStructureProvider.JavaProjectionAnnotation(isCollapsed, (IJavaElement)method, isComment), position);
                }
            }
        });
    }

    protected final Optional<ClassNode> findType(IType type) {
        String typeName = type.getFullyQualifiedName();
        LinkedList<ClassNode> classNodes = new LinkedList<ClassNode>(this.editor.getModuleNode().getClasses());
        while (!classNodes.isEmpty()) {
            ClassNode classNode = (ClassNode)classNodes.remove();
            if (classNode.getName().equals(typeName)) {
                return Optional.of(classNode);
            }
            Iterator it = classNode.getInnerClasses();
            while (it.hasNext()) {
                classNodes.add((ClassNode)it.next());
            }
        }
        return Optional.empty();
    }

    protected final boolean isMainType(IJavaElement element) {
        if (element instanceof IType) {
            String typeName = ((IType)element).getFullyQualifiedName();
            return typeName.equals(this.editor.getModuleNode().getMainClassName());
        }
        return false;
    }

    protected final boolean isScriptMethod(IJavaElement element) {
        if (element instanceof IMethod && "run".equals(element.getElementName()) && ((IMethod)element).getNumberOfParameters() == 0) {
            return this.findType(((IMethod)element).getDeclaringType()).filter(ClassNode::isScript).isPresent();
        }
        return false;
    }

    protected final boolean isScriptMethodElement(IRegion region) {
        FindSurroundingNode fsn = new FindSurroundingNode(new org.codehaus.groovy.eclipse.codebrowsing.requestor.Region(region.getOffset(), region.getLength()), FindSurroundingNode.VisitKind.SURROUNDING_NODE);
        IASTFragment astFragment = fsn.doVisitSurroundingNode(this.editor.getModuleNode());
        if (astFragment.getAssociatedNode() instanceof MethodNode) {
            return ((MethodNode)astFragment.getAssociatedNode()).isScriptBody();
        }
        return astFragment.getAssociatedNode() instanceof ModuleNode;
    }

    protected static IDocument getDocument(DefaultJavaFoldingStructureProvider.FoldingStructureComputationContext context) {
        return (IDocument)ReflectionUtils.executePrivateMethod(context.getClass(), (String)"getDocument", (Object)context);
    }
}

