/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse;

import org.codehaus.groovy.eclipse.adapters.ClassFileEditorAdapterFactory;
import org.codehaus.groovy.eclipse.adapters.GroovyIFileEditorInputAdapterFactory;
import org.codehaus.groovy.eclipse.debug.ui.EnsureJUnitFont;
import org.codehaus.groovy.eclipse.debug.ui.GroovyDebugOptionsEnforcer;
import org.codehaus.groovy.eclipse.debug.ui.GroovyJavaDebugElementAdapterFactory;
import org.codehaus.groovy.eclipse.editor.GroovyAwareFoldingStructureProvider;
import org.codehaus.groovy.eclipse.editor.GroovyOutlineTools;
import org.codehaus.groovy.eclipse.editor.GroovyTextTools;
import org.codehaus.groovy.eclipse.refactoring.actions.DelegatingCleanUpPostSaveListener;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.text.folding.JavaFoldingStructureProviderRegistry;
import org.eclipse.jdt.ui.text.folding.DefaultJavaFoldingStructureProvider;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GroovyPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.codehaus.groovy.eclipse.ui";
    public static final String GROOVY_TEMPLATE_CTX = "org.codehaus.groovy.eclipse.templates";
    public static final String COMPILER_MISMATCH_MARKER = "org.codehaus.groovy.eclipse.core.compilerMismatch";
    private static GroovyPlugin plugin;
    private EnsureJUnitFont junitMono;
    private GroovyTextTools textTools;
    private GroovyOutlineTools outlineTools;

    public static GroovyPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchWindow window = GroovyPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = GroovyPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell shell = window.getShell();
        if (shell == null) {
            shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        }
        return shell;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (plugin == null) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    public static void trace(String message) {
        if (plugin.isDebugging()) {
            System.out.println(message);
        }
    }

    public GroovyPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.textTools = new GroovyTextTools();
        this.outlineTools = new GroovyOutlineTools();
        this.addMonospaceFontListener();
        this.setStructureProviderRegistry();
        DelegatingCleanUpPostSaveListener.installCleanUp();
        IAdapterManager adapterManager = Platform.getAdapterManager();
        adapterManager.registerAdapters((IAdapterFactory)new ClassFileEditorAdapterFactory(), ClassFileEditor.class);
        adapterManager.registerAdapters((IAdapterFactory)new GroovyJavaDebugElementAdapterFactory(), IJavaStackFrame.class);
        adapterManager.registerAdapters((IAdapterFactory)new GroovyIFileEditorInputAdapterFactory(), IFileEditorInput.class);
        if (this.getPreferenceStore().getBoolean("groovy.debug.force_options")) {
            new GroovyDebugOptionsEnforcer().maybeForce(this.getPreferenceStore());
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.textTools.dispose();
            this.textTools = null;
            this.outlineTools.dispose();
            this.outlineTools = null;
            this.removeMonospaceFontListener();
            DelegatingCleanUpPostSaveListener.uninstallCleanUp();
        }
        finally {
            super.stop(context);
        }
    }

    private void addMonospaceFontListener() {
        this.junitMono = new EnsureJUnitFont();
        try {
            if (PlatformUI.isWorkbenchRunning() && GroovyPlugin.getActiveWorkbenchPage() != null) {
                GroovyPlugin.getActiveWorkbenchPage().addPartListener((IPartListener2)this.junitMono);
            }
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.junitMono);
            PrefUtil.getInternalPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.junitMono);
        }
        catch (Exception e) {
            this.logError("Error installing JUnit monospace font listener", e);
        }
    }

    private void removeMonospaceFontListener() {
        try {
            try {
                if (!PlatformUI.getWorkbench().isClosing()) {
                    GroovyPlugin.getActiveWorkbenchPage().removePartListener((IPartListener2)this.junitMono);
                }
            }
            catch (RuntimeException runtimeException) {
                PrefUtil.getInternalPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
                this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
                this.junitMono = null;
            }
        }
        finally {
            PrefUtil.getInternalPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
            this.junitMono = null;
        }
    }

    private void setStructureProviderRegistry() {
        try {
            ReflectionUtils.setPrivateField(JavaPlugin.class, (String)"fFoldingStructureProviderRegistry", (Object)JavaPlugin.getDefault(), (Object)new JavaFoldingStructureProviderRegistry(){

                public IJavaFoldingStructureProvider getCurrentFoldingProvider() {
                    Object provider = super.getCurrentFoldingProvider();
                    if (provider.getClass().equals(DefaultJavaFoldingStructureProvider.class)) {
                        provider = new GroovyAwareFoldingStructureProvider();
                    }
                    return provider;
                }
            });
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public GroovyTextTools getTextTools() {
        return this.textTools;
    }

    public GroovyOutlineTools getOutlineTools() {
        return this.outlineTools;
    }

    public void logMessage(String message) {
        this.log(1, message, null);
    }

    public void logWarning(String message) {
        this.log(2, message, null);
    }

    public void logError(String message, Throwable error) {
        this.log(4, message, error);
    }

    private void log(int severity, String message, Throwable cause) {
        this.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message, cause));
    }
}

