/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.ui;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.DSLDStoreManager;
import org.codehaus.groovy.eclipse.dsl.DSLPreferencesInitializer;
import org.codehaus.groovy.eclipse.dsl.DisabledScriptsCache;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;

public class DSLPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String[] LABELS = new String[]{"Edit...", "Recompile Scripts", "Refresh List", "Check All", "Uncheck All"};
    private static final int IDX_EDIT = 0;
    private static final int IDX_RECOMPILE = 1;
    private static final int IDX_REFRESH = 2;
    private static final int IDX_CHECK_ALL = 3;
    private static final int IDX_UNCHECK_ALL = 4;
    DisabledScriptsCache cache;
    Map<String, ProjectContextKey[]> elementsMap;
    private CheckedTreeListDialogField tree;
    private IWorkbenchPage page;
    private Button autoAdd;
    private Button disableDSLDs;
    private static final String EVENT = "Recompiling all DSLDs in the workspace.";

    public void init(IWorkbench workbench) {
        this.cache = new DisabledScriptsCache();
        this.elementsMap = new HashMap<String, ProjectContextKey[]>();
        try {
            this.page = workbench.getActiveWorkbenchWindow().getActivePage();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.tree = new CheckedTreeListDialogField(new DSLListAdapter(), LABELS, (ILabelProvider)new DSLLabelProvider());
        this.tree.setTreeExpansionLevel(2);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.tree}, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.tree.getTreeControl(null));
        this.refresh();
        PixelConverter converter = new PixelConverter((Control)parent);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.tree.setButtonsMinWidth(buttonBarWidth);
        this.autoAdd = new Button(composite, 32);
        this.autoAdd.setText("Automatically add DSL Support to all Groovy projects");
        this.autoAdd.setSelection(GroovyDSLCoreActivator.getDefault().getPreferenceStore().getBoolean("org.codehaus.groovy.eclipse.dsl.auto.add.support"));
        GridData data = new GridData(16384, 128, true, false);
        data.horizontalSpan = 2;
        this.autoAdd.setLayoutData((Object)data);
        this.disableDSLDs = new Button(composite, 32);
        this.disableDSLDs.setText("Disable DSLD support in your workspace. (Requires restart)");
        boolean isDisabled = GroovyDSLCoreActivator.getDefault().getPreferenceStore().getBoolean("org.codehaus.groovy.eclipse.dsl.disabled");
        this.disableDSLDs.setSelection(isDisabled);
        this.disableDSLDs.setLayoutData((Object)data);
        if (this.disableDSLDs.getSelection()) {
            Label l = new Label(composite, 0);
            l.setText("NOTE: DSLD support is currently disabled.");
        }
        return composite;
    }

    protected IProject toProject(Object element) {
        if (element instanceof String) {
            String name = (String)element;
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (GroovyNature.hasGroovyNature((IProject)proj)) {
                return proj;
            }
        }
        return null;
    }

    protected boolean canEdit() {
        List selected = this.tree.getSelectedElements();
        return selected.size() == 1 && selected.get(0) instanceof ProjectContextKey;
    }

    protected void edit() {
        if (this.canEdit()) {
            List selected = this.tree.getSelectedElements();
            ProjectContextKey pck = (ProjectContextKey)selected.get(0);
            IStorage storage = pck.dslFile;
            IEditorInput input = this.getEditorInput(storage);
            if (input != null) {
                try {
                    if (this.page != null) {
                        IDE.openEditor((IWorkbenchPage)this.page, (IEditorInput)input, (String)"org.codehaus.groovy.eclipse.editor.GroovyEditor", (boolean)true);
                    }
                }
                catch (PartInitException e) {
                    if (this.page != null) {
                        ErrorDialog.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)"Error opening editor", (String)("See error log: " + e.getLocalizedMessage()), (IStatus)e.getStatus());
                    }
                    GroovyDSLCoreActivator.logException(e);
                }
            } else if (this.page != null) {
                ErrorDialog.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)"Could not open editor", (String)("File " + pck.dslFile + " is not accessible."), (IStatus)new Status(4, "org.codehaus.groovy.eclipse.dsl", "Could not open editor"));
            }
        }
    }

    private IEditorInput getEditorInput(IStorage storage) {
        if (storage instanceof IFile && ((IFile)storage).getProject().equals((Object)JavaModelManager.getExternalManager().getExternalFoldersProject())) {
            return new FileStoreEditorInput((IFileStore)new LocalFile(new File(((IFile)storage).getLocationURI())));
        }
        return EditorUtility.getEditorInput((Object)storage);
    }

    protected void refresh() {
        DSLDStoreManager manager = GroovyDSLCoreActivator.getDefault().getContextStoreManager();
        Object[] projectNames = manager.getProjectNames();
        this.elementsMap.clear();
        Object[] objectArray = projectNames;
        int n = projectNames.length;
        int n2 = 0;
        while (n2 < n) {
            DSLDStore store;
            Object projectName = objectArray[n2];
            IProject project = this.toProject(projectName);
            if (project != null && (store = manager.getDSLDStore(project)) != null) {
                IStorage[] keys = store.getAllContextKeys();
                Arrays.sort(keys, Comparator.comparing(IStorage::getName));
                ProjectContextKey[] pck = new ProjectContextKey[keys.length];
                int i = 0;
                int n3 = pck.length;
                while (i < n3) {
                    pck[i] = new ProjectContextKey((String)projectName, keys[i]);
                    pck[i].isChecked = !this.cache.isDisabled(DSLDStore.toUniqueString(pck[i].dslFile));
                    ++i;
                }
                this.elementsMap.put((String)projectName, pck);
            }
            ++n2;
        }
        Arrays.sort(projectNames);
        this.tree.setElements(Arrays.asList(projectNames));
        this.tree.refresh();
        Iterator<ProjectContextKey[]> iterator = this.elementsMap.values().iterator();
        while (iterator.hasNext()) {
            ProjectContextKey[] keys;
            ProjectContextKey[] projectContextKeyArray = keys = iterator.next();
            int n4 = keys.length;
            int n5 = 0;
            while (n5 < n4) {
                ProjectContextKey key = projectContextKeyArray[n5];
                this.tree.setChecked(key, key.isChecked);
                ++n5;
            }
        }
    }

    void checkAll(boolean newState) {
        Iterator<ProjectContextKey[]> iterator = this.elementsMap.values().iterator();
        while (iterator.hasNext()) {
            ProjectContextKey[] keys;
            ProjectContextKey[] projectContextKeyArray = keys = iterator.next();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectContextKey key = projectContextKeyArray[n2];
                key.isChecked = newState;
                this.tree.setChecked(key, key.isChecked);
                ++n2;
            }
        }
    }

    protected void recompile() {
        new UIJob("Refresh DSLD launcher"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                GroovyLogManager.manager.log(TraceCategory.DSL, DSLPreferencesPage.EVENT);
                GroovyLogManager.manager.logStart(DSLPreferencesPage.EVENT);
                GroovyDSLCoreActivator activator = GroovyDSLCoreActivator.getDefault();
                if (!activator.isDSLDDisabled()) {
                    activator.getContextStoreManager().initialize(ResourcesPlugin.getWorkspace().getRoot().getProjects(), true);
                }
                if (!DSLPreferencesPage.this.getControl().isDisposed()) {
                    DSLPreferencesPage.this.refresh();
                }
                GroovyLogManager.manager.logEnd(DSLPreferencesPage.EVENT, TraceCategory.DSL);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkAll(true);
        DSLPreferencesInitializer.reset();
        this.autoAdd.setSelection(true);
    }

    public boolean performOk() {
        HashSet<String> unchecked = new HashSet<String>();
        Iterator<ProjectContextKey[]> iterator = this.elementsMap.values().iterator();
        while (iterator.hasNext()) {
            ProjectContextKey[] keys;
            ProjectContextKey[] projectContextKeyArray = keys = iterator.next();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectContextKey key = projectContextKeyArray[n2];
                if (!key.isChecked) {
                    unchecked.add(DSLDStore.toUniqueString(key.dslFile));
                }
                ++n2;
            }
        }
        this.cache.setDisabled(unchecked);
        GroovyDSLCoreActivator.getDefault().getPreferenceStore().setValue("org.codehaus.groovy.eclipse.dsl.auto.add.support", this.autoAdd.getSelection());
        boolean origDisabled = GroovyDSLCoreActivator.getDefault().getPreferenceStore().getBoolean("org.codehaus.groovy.eclipse.dsl.disabled");
        if (origDisabled != this.disableDSLDs.getSelection()) {
            GroovyDSLCoreActivator.getDefault().getPreferenceStore().setValue("org.codehaus.groovy.eclipse.dsl.disabled", this.disableDSLDs.getSelection());
            boolean res = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Restart now?", (String)("You have " + (this.disableDSLDs.getSelection() ? "disabled" : "enabled") + " DSLDs in your workspace." + "  This will not take effect until a restart has been performed.\n\nDo you want to restart now?"));
            if (res) {
                Workbench.getInstance().restart();
            }
        }
        return super.performOk();
    }

    private class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof ProjectContextKey) {
                ProjectContextKey key = (ProjectContextKey)element;
                key.isChecked = event.getChecked();
            } else if (element instanceof String) {
                ProjectContextKey[] children;
                ProjectContextKey[] projectContextKeyArray = children = DSLPreferencesPage.this.elementsMap.get(element);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ProjectContextKey child = projectContextKeyArray[n2];
                    child.isChecked = event.getChecked();
                    ++n2;
                }
            }
        }
    }

    private class CheckedTreeListDialogField
    extends TreeListDialogField<String> {
        private ContainerCheckedTreeViewer checkboxViewer;

        private CheckedTreeListDialogField(ITreeListAdapter<String> adapter, String[] buttonLabels, ILabelProvider lprovider) {
            super(adapter, buttonLabels, lprovider);
        }

        protected TreeViewer createTreeViewer(Composite parent) {
            Tree treeComponent = new Tree(parent, this.getTreeStyle() | 0x20);
            treeComponent.setFont(parent.getFont());
            this.checkboxViewer = new ContainerCheckedTreeViewer(treeComponent);
            this.checkboxViewer.addCheckStateListener((ICheckStateListener)new CheckStateListener());
            return this.checkboxViewer;
        }

        void setChecked(Object child, boolean newState) {
            this.checkboxViewer.setChecked(child, newState);
        }
    }

    private class DSLLabelProvider
    extends LabelProvider {
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

        private DSLLabelProvider() {
        }

        public void dispose() {
            this.provider.dispose();
            super.dispose();
        }

        public String getText(Object element) {
            if (element instanceof ProjectContextKey) {
                ProjectContextKey pck = (ProjectContextKey)element;
                return pck.dslFile.getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            IProject proj = DSLPreferencesPage.this.toProject(element);
            if (proj != null) {
                return this.provider.getImage((Object)proj);
            }
            IFile file = null;
            if (element instanceof ProjectContextKey && ((ProjectContextKey)element).dslFile instanceof IFile) {
                file = (IFile)((ProjectContextKey)element).dslFile;
            }
            if (file != null) {
                return this.provider.getImage(file);
            }
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.classf_obj.gif");
        }
    }

    private class DSLListAdapter
    implements ITreeListAdapter<String> {
        private DSLListAdapter() {
        }

        public void customButtonPressed(TreeListDialogField<String> field, int index) {
            if (index == 0) {
                DSLPreferencesPage.this.edit();
            } else if (index == 1) {
                DSLPreferencesPage.this.recompile();
            } else if (index == 2) {
                DSLPreferencesPage.this.refresh();
            } else if (index == 3) {
                DSLPreferencesPage.this.checkAll(true);
            } else if (index == 4) {
                DSLPreferencesPage.this.checkAll(false);
            }
        }

        public void selectionChanged(TreeListDialogField<String> field) {
            if (DSLPreferencesPage.this.canEdit()) {
                field.enableButton(0, true);
            } else {
                field.enableButton(0, false);
            }
        }

        public void doubleClicked(TreeListDialogField<String> field) {
            DSLPreferencesPage.this.edit();
        }

        public void keyPressed(TreeListDialogField<String> field, KeyEvent event) {
        }

        public Object[] getChildren(TreeListDialogField<String> field, Object element) {
            if (element instanceof String) {
                return DSLPreferencesPage.this.elementsMap.get(element);
            }
            return null;
        }

        public Object getParent(TreeListDialogField<String> field, Object element) {
            if (element instanceof ProjectContextKey) {
                return ((ProjectContextKey)element).projectName;
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField<String> field, Object element) {
            Object[] children = this.getChildren(field, element);
            return children != null && children.length > 0;
        }
    }

    private static class ProjectContextKey {
        final String projectName;
        final IStorage dslFile;
        boolean isChecked;

        ProjectContextKey(String projectName, IStorage dslFile) {
            this.projectName = projectName;
            this.dslFile = dslFile;
        }
    }
}

