/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FilteringPointcut;
import org.eclipse.core.resources.IStorage;

public class FindAnnotationPointcut
extends FilteringPointcut<AnnotationNode> {
    public FindAnnotationPointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName, AnnotationNode.class);
    }

    @Override
    protected Collection<AnnotationNode> explodeObject(Object object) {
        ArrayList<AnnotationNode> result = new ArrayList<AnnotationNode>();
        this.explodeObject(object, result);
        return result;
    }

    protected void explodeObject(Object object, Collection<AnnotationNode> result) {
        if (object instanceof AnnotationNode) {
            AnnotationNode annotation = (AnnotationNode)object;
            if (FindAnnotationPointcut.isCollectorAnnotation(annotation)) {
                Expression expression = annotation.getMember("value");
                if (expression instanceof ListExpression) {
                    List expressions = ((ListExpression)expression).getExpressions();
                    this.explodeObject(expressions, result);
                } else {
                    this.explodeObject(expression, result);
                }
            }
            result.add(annotation);
        } else if (object instanceof AnnotationConstantExpression) {
            this.explodeObject(((ConstantExpression)object).getValue(), result);
        } else if (object instanceof AnnotatedNode) {
            this.explodeObject(((AnnotatedNode)object).getAnnotations(), result);
        } else if (object instanceof Collection) {
            ((Collection)object).forEach(item -> this.explodeObject(item, result));
        }
    }

    @Override
    protected AnnotationNode filterObject(AnnotationNode result, GroovyDSLDContext context, String firstArgAsString) {
        if (firstArgAsString.equals(result.getClassNode().getName())) {
            return result;
        }
        return null;
    }

    protected static boolean isCollectorAnnotation(AnnotationNode annotation) {
        ClassNode returnType;
        List methods = annotation.getClassNode().getMethods();
        if (methods.size() == 1 && ((MethodNode)methods.get(0)).getName().equals("value") && (returnType = ((MethodNode)methods.get(0)).getReturnType()).isArray()) {
            return returnType.getComponentType().implementsInterface(ClassHelper.Annotation_TYPE);
        }
        return false;
    }
}

