/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.AbstractControlManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class AbstractLabeledDialogueControl
extends AbstractControlManager {
    private Label parameterNameLabel;
    private Point offsetLabelLocation;
    private IDialogueControlDescriptor labelDescriptor;

    protected AbstractLabeledDialogueControl(IDialogueControlDescriptor labelDescriptor, Point offsetLabelLocation) {
        this.labelDescriptor = labelDescriptor;
        this.offsetLabelLocation = offsetLabelLocation;
    }

    protected IDialogueControlDescriptor getLabelDescriptor() {
        return this.labelDescriptor;
    }

    protected int numberofColumns() {
        return 2;
    }

    @Override
    protected Map<Control, IDialogueControlDescriptor> createManagedControls(Composite parent) {
        HashMap<Control, IDialogueControlDescriptor> controls = new HashMap<Control, IDialogueControlDescriptor>();
        if (this.labelDescriptor != null) {
            Control labeledControl;
            Composite labelArea = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(this.numberofColumns()).margins(0, 0).equalWidth(false).applyTo(labelArea);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)labelArea);
            this.parameterNameLabel = new Label(labelArea, 8);
            this.parameterNameLabel.setText(String.valueOf(this.labelDescriptor.getLabel()) + ": ");
            this.parameterNameLabel.setToolTipText(this.labelDescriptor.getToolTipText());
            GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)this.parameterNameLabel);
            if (this.offsetLabelLocation != null) {
                int widthHint;
                GridData data = (GridData)this.parameterNameLabel.getLayoutData();
                int heightHint = this.offsetLabelLocation.y;
                if (heightHint > 0) {
                    data.heightHint = heightHint;
                }
                if ((widthHint = this.offsetLabelLocation.x) > 0) {
                    data.widthHint = widthHint;
                }
            }
            if ((labeledControl = this.getManagedControl(labelArea)) != null) {
                controls.put(labeledControl, this.getLabelDescriptor());
            }
        }
        return controls;
    }

    protected abstract Control getManagedControl(Composite var1);

    public Label getLabel() {
        return this.parameterNameLabel != null && !this.parameterNameLabel.isDisposed() ? this.parameterNameLabel : null;
    }
}

