/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage;

import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.preferencepage.ITreeViewerColumn;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class SuggestionsViewer {
    private ContainerCheckedTreeViewer viewer;
    private ITreeViewerColumn[] columns;
    private ColumnSortListener columnListener;
    private ITreeViewerColumn defaultSortColumn;

    public SuggestionsViewer(ITreeViewerColumn[] columns, ITreeViewerColumn defaultSortColumn) {
        this.defaultSortColumn = defaultSortColumn;
        this.columns = columns;
    }

    protected int getConfiguration() {
        return 68386;
    }

    protected ICheckStateProvider getCheckStateProvider() {
        return null;
    }

    public void createControls(Composite parent) {
        TreeColumn sortColumn;
        int n;
        Composite treeComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeComposite);
        GridLayoutFactory.fillDefaults().applyTo(treeComposite);
        Tree tree = new Tree(treeComposite, this.getConfiguration());
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.getHeightHint()).applyTo((Control)tree);
        this.viewer = new ContainerCheckedTreeViewer(tree);
        if (this.columns != null && this.columns.length > 0) {
            PixelConverter converter = new PixelConverter((Control)treeComposite);
            ITreeViewerColumn[] iTreeViewerColumnArray = this.columns;
            n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeViewerColumn column = iTreeViewerColumnArray[n2];
                if (column != null) {
                    TreeColumn treeColumn = new TreeColumn(tree, 0);
                    treeColumn.setResizable(true);
                    treeColumn.setWidth(converter.convertWidthInCharsToPixels(column.getWidth()));
                    treeColumn.setText(column.getName());
                }
                ++n2;
            }
        }
        if ((sortColumn = this.getDefaultSortColumn()) != null) {
            tree.setSortColumn(sortColumn);
            tree.setSortDirection(128);
        }
        TreeColumn[] columns = this.viewer.getTree().getColumns();
        if (this.columnListener != null) {
            this.removeListeners();
        }
        this.columnListener = new ColumnSortListener();
        TreeColumn[] treeColumnArray = columns;
        int n3 = columns.length;
        n = 0;
        while (n < n3) {
            TreeColumn column = treeColumnArray[n];
            column.addSelectionListener((SelectionListener)this.columnListener);
            ++n;
        }
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer.refresh();
    }

    public ContainerCheckedTreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected int getHeightHint() {
        return 200;
    }

    protected TreeColumn getDefaultSortColumn() {
        Tree tree;
        TreeColumn[] columns;
        if (this.defaultSortColumn == null) {
            return null;
        }
        String sortColumnName = this.defaultSortColumn.getName();
        if (sortColumnName != null && (columns = (tree = this.viewer.getTree()).getColumns()) != null) {
            TreeColumn[] treeColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                if (sortColumnName.equals(column.getText())) {
                    return column;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setChecked(Object child, boolean newState) {
        this.viewer.setChecked(child, newState);
    }

    public void dispose() {
        this.removeListeners();
    }

    protected void removeListeners() {
        if (this.columnListener != null) {
            TreeColumn[] columns;
            TreeColumn[] treeColumnArray = columns = this.viewer.getTree().getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.removeSelectionListener((SelectionListener)this.columnListener);
                ++n2;
            }
        }
    }

    protected class ColumnSortListener
    extends SelectionAdapter {
        protected ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof TreeColumn) {
                TreeColumn selected = (TreeColumn)e.widget;
                Tree tree = SuggestionsViewer.this.viewer.getTree();
                TreeColumn current = tree.getSortColumn();
                int newDirection = 128;
                if (current == selected) {
                    newDirection = tree.getSortDirection() == 128 ? 1024 : 128;
                } else {
                    tree.setSortColumn(selected);
                }
                tree.setSortDirection(newDirection);
                SuggestionsViewer.this.viewer.refresh();
            }
        }
    }
}

