/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyMethodSuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;

public class SuggestionDescriptor {
    private boolean isStatic;
    private boolean isMethod = false;
    private String name;
    private String javaDoc;
    private boolean isActive;
    private String suggestionType;
    private String declaringTypeName;
    private boolean useArgumentNames;
    private List<MethodParameter> parameters;

    protected SuggestionDescriptor(String declaringTypeName, boolean isStatic, boolean isMethod, String name, String javaDoc, String suggestionType, boolean useArgumentNames, List<MethodParameter> parameters, boolean isActive) {
        this.isStatic = isStatic;
        this.isMethod = isMethod;
        this.name = name;
        this.javaDoc = javaDoc;
        this.suggestionType = suggestionType;
        this.isActive = isActive;
        this.declaringTypeName = declaringTypeName;
        this.useArgumentNames = useArgumentNames;
        this.parameters = parameters;
    }

    public SuggestionDescriptor(String declaringTypeName, boolean isStatic, String name, String javaDoc, String suggestionType, boolean useArgumentNames, List<MethodParameter> parameters, boolean isActive) {
        this(declaringTypeName, isStatic, true, name, javaDoc, suggestionType, useArgumentNames, parameters, isActive);
    }

    public SuggestionDescriptor(String declaringTypeName, boolean isStatic, String name, String javaDoc, String suggestionType, boolean isActive) {
        this(declaringTypeName, isStatic, false, name, javaDoc, suggestionType, false, null, isActive);
    }

    public SuggestionDescriptor(IGroovySuggestion suggestion) {
        this(suggestion, suggestion.isActive());
    }

    public SuggestionDescriptor(IGroovySuggestion suggestion, boolean isActive) {
        this.isStatic = suggestion.isStatic();
        this.isActive = isActive;
        this.name = suggestion.getName();
        this.javaDoc = suggestion.getJavaDoc();
        this.suggestionType = suggestion.getType();
        this.declaringTypeName = suggestion.getDeclaringType().getName();
        if (suggestion instanceof GroovyMethodSuggestion) {
            GroovyMethodSuggestion methodSuggestion = (GroovyMethodSuggestion)suggestion;
            this.useArgumentNames = methodSuggestion.useNamedArguments();
            this.parameters = methodSuggestion.getParameters();
            this.isMethod = true;
        }
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public String getName() {
        return this.name;
    }

    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    public String getJavaDoc() {
        return this.javaDoc;
    }

    public String getSuggestionType() {
        return this.suggestionType;
    }

    public boolean isUseArgumentNames() {
        return this.useArgumentNames;
    }

    public List<MethodParameter> getParameters() {
        return this.parameters;
    }
}

