/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyNamedArgumentProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.codehaus.groovy.eclipse.dsl.contributions.ContributionElems;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.ParameterContribution;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;
import org.codehaus.jdt.groovy.ast.MethodNodeWithNamedParams;
import org.eclipse.jdt.groovy.search.AbstractSimplifiedTypeLookup;

public class MethodContributionElement
implements IContributionElement {
    private static final BlockStatement EMPTY_BLOCK = new BlockStatement();
    private static final ClassNode[] NO_EXCEPTIONS = ClassNode.EMPTY_ARRAY;
    private static final ParameterContribution[] NO_PARAMETER_CONTRIBUTIONS = new ParameterContribution[0];
    private final String methodName;
    private final ParameterContribution[] namedParams;
    private final ParameterContribution[] optionalParams;
    private final ParameterContribution[] positionalParams;
    private final String returnType;
    private final String declaringType;
    private final boolean isStatic;
    private final boolean useNamedArgs;
    private final String provider;
    private final String doc;
    private ClassNode cachedDeclaringType;
    private ClassNode cachedReturnType;
    private Parameter[] cachedNamedParameters;
    private Parameter[] cachedOptionalParameters;
    private Parameter[] cachedPositionalParameters;
    private final int relevanceMultiplier;
    private final boolean isDeprecated;
    private final boolean noParens;

    public MethodContributionElement(String methodName, ParameterContribution[] params, String returnType, String declaringType, boolean isStatic, String provider, String doc, boolean useNamedArgs, boolean isDeprecated, int relevanceMultiplier) {
        this(methodName, params, NO_PARAMETER_CONTRIBUTIONS, NO_PARAMETER_CONTRIBUTIONS, returnType, declaringType, isStatic, provider, doc, useNamedArgs, false, isDeprecated, relevanceMultiplier);
    }

    public MethodContributionElement(String methodName, ParameterContribution[] params, ParameterContribution[] namedParams, ParameterContribution[] optionalParams, String returnType, String declaringType, boolean isStatic, String provider, String doc, boolean useNamedArgs, boolean noParens, boolean isDeprecated, int relevanceMultiplier) {
        this.methodName = methodName;
        this.positionalParams = params;
        this.namedParams = namedParams;
        this.optionalParams = optionalParams;
        this.returnType = returnType;
        this.isStatic = isStatic;
        this.declaringType = declaringType;
        this.useNamedArgs = useNamedArgs;
        this.noParens = noParens;
        this.isDeprecated = isDeprecated;
        this.relevanceMultiplier = relevanceMultiplier;
        String string = this.provider = provider != null ? ContributionElems.removeJavadocMarkup(provider) : "DSL Descriptor";
        this.doc = doc != null ? doc : "Provided by " + (provider != null ? provider : "DSL Descriptor");
    }

    @Override
    public AbstractSimplifiedTypeLookup.TypeAndDeclaration lookupType(String name, ClassNode declaringType, ResolverCache resolver) {
        if (name.equals(this.methodName)) {
            MethodNode node = this.toMethod(declaringType, resolver);
            ClassNode type = node instanceof ConstructorNode ? node.getDeclaringClass() : node.getReturnType();
            return new AbstractSimplifiedTypeLookup.TypeAndDeclaration(type, (ASTNode)node, node.getDeclaringClass(), this.doc);
        }
        return null;
    }

    @Override
    public IGroovyProposal toProposal(ClassNode declaringType, ResolverCache resolver) {
        GroovyMethodProposal proposal = new GroovyMethodProposal(this.toMethod(declaringType.redirect(), resolver), this.provider);
        proposal.setProposalFormattingOptions(ProposalFormattingOptions.newFromOptions().newFromExisting(this.useNamedArgs, this.noParens, proposal.getMethod()));
        proposal.setRelevanceMultiplier((float)this.relevanceMultiplier);
        return proposal;
    }

    @Override
    public List<IGroovyProposal> extraProposals(ClassNode declaringType, ResolverCache resolver, Expression expression) {
        Map<String, ClassNode> availableParams = this.findAvailableParameters(resolver);
        if (availableParams.isEmpty()) {
            return ProposalUtils.NO_PROPOSALS;
        }
        this.removeUsedParameters(expression, availableParams);
        ArrayList<IGroovyProposal> extraProposals = new ArrayList<IGroovyProposal>(availableParams.size());
        for (Map.Entry<String, ClassNode> available : availableParams.entrySet()) {
            extraProposals.add((IGroovyProposal)new GroovyNamedArgumentProposal(available.getKey(), available.getValue(), this.toMethod(declaringType.redirect(), resolver), this.contributionName()));
        }
        return extraProposals;
    }

    private void removeUsedParameters(Expression expression, Map<String, ClassNode> availableParams) {
        if (expression instanceof MethodCall) {
            MethodCall call = (MethodCall)expression;
            Expression arguments = call.getArguments();
            if (arguments instanceof TupleExpression) {
                for (Expression maybeArg : ((TupleExpression)arguments).getExpressions()) {
                    if (!(maybeArg instanceof MapExpression)) continue;
                    arguments = maybeArg;
                    break;
                }
            }
            if (arguments instanceof MapExpression) {
                MapExpression enclosingCallArgs = (MapExpression)arguments;
                for (MapEntryExpression entry : enclosingCallArgs.getMapEntryExpressions()) {
                    String paramName = entry.getKeyExpression().getText();
                    availableParams.remove(paramName);
                }
            }
        }
    }

    private Map<String, ClassNode> findAvailableParameters(ResolverCache resolver) {
        ParameterContribution param;
        int n;
        int n2;
        ParameterContribution[] parameterContributionArray;
        HashMap<String, ClassNode> available = new HashMap<String, ClassNode>(this.positionalParams.length);
        if (this.useNamedArgs) {
            parameterContributionArray = this.positionalParams;
            n2 = this.positionalParams.length;
            n = 0;
            while (n < n2) {
                param = parameterContributionArray[n];
                available.put(param.name, param.toParameter(resolver).getType());
                ++n;
            }
        }
        parameterContributionArray = this.namedParams;
        n2 = this.namedParams.length;
        n = 0;
        while (n < n2) {
            param = parameterContributionArray[n];
            available.put(param.name, param.toParameter(resolver).getType());
            ++n;
        }
        parameterContributionArray = this.optionalParams;
        n2 = this.optionalParams.length;
        n = 0;
        while (n < n2) {
            param = parameterContributionArray[n];
            available.put(param.name, param.toParameter(resolver).getType());
            ++n;
        }
        return available;
    }

    private MethodNode toMethod(ClassNode declaringType, ResolverCache resolver) {
        MethodNodeWithNamedParams method;
        if (this.cachedNamedParameters == null) {
            this.cachedNamedParameters = MethodContributionElement.toParameters(this.namedParams, resolver);
            this.cachedOptionalParameters = MethodContributionElement.toParameters(this.optionalParams, resolver);
            this.cachedPositionalParameters = MethodContributionElement.toParameters(this.positionalParams, resolver);
        }
        if ("<init>".equals(this.methodName)) {
            method = new ConstructorContribution(this.modifiers(), this.cachedNamedParameters, this.cachedOptionalParameters, this.cachedPositionalParameters);
            ClassNode type = this.declaringType(declaringType, resolver);
            if (type == declaringType) {
                type = this.returnType(resolver);
            }
            method.setDeclaringClass(type);
        } else {
            method = new MethodContribution(this.methodName, this.modifiers(), this.returnType(resolver), this.cachedNamedParameters, this.cachedOptionalParameters, this.cachedPositionalParameters);
            method.setDeclaringClass(this.declaringType(declaringType, resolver));
        }
        return method;
    }

    private static Parameter[] toParameters(ParameterContribution[] pcs, ResolverCache resolver) {
        Parameter[] ps;
        if (pcs == null) {
            ps = Parameter.EMPTY_ARRAY;
        } else {
            int n = pcs.length;
            ps = new Parameter[n];
            int i = 0;
            while (i < n) {
                ps[i] = pcs[i].toParameter(resolver);
                ++i;
            }
        }
        return ps;
    }

    private ClassNode declaringType(ClassNode lexicalDeclaringType, ResolverCache resolver) {
        if (this.declaringType != null && this.cachedDeclaringType == null) {
            this.cachedDeclaringType = resolver.resolve(this.declaringType);
        }
        return this.cachedDeclaringType == null ? lexicalDeclaringType : this.cachedDeclaringType;
    }

    private ClassNode returnType(ResolverCache resolver) {
        if (this.cachedReturnType == null) {
            if (resolver != null) {
                this.cachedReturnType = resolver.resolve(this.returnType);
                if (this.returnType.indexOf(60) < 1) {
                    this.cachedReturnType = this.cachedReturnType.getPlainNodeReference();
                }
            } else {
                this.cachedReturnType = ClassHelper.DYNAMIC_TYPE;
            }
        }
        return this.cachedReturnType;
    }

    private int modifiers() {
        int modifiers = 1;
        if (this.isStatic) {
            modifiers |= 8;
        }
        if (this.isDeprecated) {
            modifiers |= 0x100000;
        }
        return modifiers;
    }

    @Override
    public String description() {
        return "Method: " + this.declaringType + "." + this.methodName + "(..)";
    }

    @Override
    public String contributionName() {
        if ("<init>".equals(this.methodName)) {
            return this.getDeclaringTypeName();
        }
        return this.methodName;
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("public ");
        if (this.isStatic) {
            sb.append("static ");
        }
        if (this.isDeprecated) {
            sb.append("deprecated ");
        }
        if (this.useNamedArgs) {
            sb.append("useNamedArgs ");
        }
        sb.append(this.returnType).append(' ');
        sb.append(this.declaringType);
        sb.append('.').append(this.methodName);
        sb.append('(').append(Arrays.toString(this.positionalParams)).append(')');
        sb.append(' ').append('(').append(this.provider).append(')');
        return sb.toString();
    }

    public static class ConstructorContribution
    extends ConstructorNode
    implements MethodNodeWithNamedParams {
        private final Parameter[] namedParams;
        private final Parameter[] optionalParams;
        private final Parameter[] positionalParams;

        public ConstructorContribution(int modifiers, Parameter[] namedParams, Parameter[] optionalParams, Parameter[] positionalParams) {
            super(modifiers, MethodNodeWithNamedParams.concatParams((Parameter[])positionalParams, (Parameter[])namedParams, (Parameter[])optionalParams), NO_EXCEPTIONS, (Statement)EMPTY_BLOCK);
            this.namedParams = namedParams;
            this.optionalParams = optionalParams;
            this.positionalParams = positionalParams;
        }

        public Parameter[] getNamedParams() {
            return this.namedParams;
        }

        public Parameter[] getOptionalParams() {
            return this.optionalParams;
        }

        public Parameter[] getPositionalParams() {
            return this.positionalParams;
        }
    }

    public static class MethodContribution
    extends MethodNode
    implements MethodNodeWithNamedParams {
        private final Parameter[] namedParams;
        private final Parameter[] optionalParams;
        private final Parameter[] positionalParams;

        public MethodContribution(String name, int modifiers, ClassNode returnType, Parameter[] namedParams, Parameter[] optionalParams, Parameter[] positionalParams) {
            super(name, modifiers, returnType, MethodNodeWithNamedParams.concatParams((Parameter[])positionalParams, (Parameter[])namedParams, (Parameter[])optionalParams), NO_EXCEPTIONS, (Statement)EMPTY_BLOCK);
            this.namedParams = namedParams;
            this.optionalParams = optionalParams;
            this.positionalParams = positionalParams;
        }

        public Parameter[] getNamedParams() {
            return this.namedParams;
        }

        public Parameter[] getOptionalParams() {
            return this.optionalParams;
        }

        public Parameter[] getPositionalParams() {
            return this.positionalParams;
        }
    }
}

