/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import groovy.lang.GroovyObjectSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionGroup;
import org.codehaus.groovy.eclipse.dsl.contributions.MethodContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.ParameterContribution;
import org.codehaus.groovy.eclipse.dsl.contributions.PropertyContributionElement;
import org.codehaus.groovy.eclipse.dsl.pointcuts.BindingSet;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;

public class ContributionGroup
extends GroovyObjectSupport
implements IContributionGroup {
    protected static final String DEFAULT_PROVIDER = "User";
    protected static final int DEFAULT_RELEVANCE_MULTIPLIER = 11;
    protected List<IContributionElement> contributions = new ArrayList<IContributionElement>();

    public void addMethodContribution(String name, ParameterContribution[] params, String returnType, String declaringType, boolean isStatic, boolean useNamedArgs) {
        this.contributions.add(new MethodContributionElement(name, params, returnType, declaringType, isStatic, DEFAULT_PROVIDER, null, useNamedArgs, false, 11));
    }

    public void addPropertyContribution(String name, String type, String declaringType, boolean isStatic) {
        this.contributions.add(new PropertyContributionElement(name, type, declaringType, isStatic ? 8 : 0, DEFAULT_PROVIDER, null, false, 11));
    }

    @Override
    public List<IContributionElement> getContributions(GroovyDSLDContext pattern, BindingSet matches) {
        return this.contributions.stream().filter(element -> pattern.matchesType(element.getDeclaringTypeName())).collect(Collectors.toList());
    }
}

