/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.classpath;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;

public class AutoAddContainerSupport
implements IResourceChangeListener {
    private final IPreferenceStore store = GroovyDSLCoreActivator.getDefault().getPreferenceStore();
    private final Set<String> alreadyAddedProjects = Arrays.stream(this.store.getString("org.codehaus.groovy.eclipse.dsl.projects.ignore").split(",")).filter(projName -> !projName.isEmpty() && ResourcesPlugin.getWorkspace().getRoot().getProject(projName).exists()).collect(Collectors.toSet());

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null && delta.getAffectedChildren().length > 0) {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                if (child.getResource() instanceof IProject) {
                    if (child.getAffectedChildren().length == 0) {
                        projects.add((IProject)child.getResource());
                    } else {
                        IResourceDelta[] iResourceDeltaArray2 = child.getAffectedChildren();
                        int n3 = iResourceDeltaArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IResourceDelta grandchild = iResourceDeltaArray2[n4];
                            IResource r = grandchild.getResource();
                            if (r instanceof IFile && r.getName().equals(".project")) {
                                projects.add((IProject)child.getResource());
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            this.addContainer(projects.toArray(new IProject[projects.size()]));
        }
    }

    public void addContainer(IProject[] projects) {
        if (!this.store.getBoolean("org.codehaus.groovy.eclipse.dsl.auto.add.support") || this.store.getBoolean("org.codehaus.groovy.eclipse.dsl.scripts.disabled")) {
            return;
        }
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!this.alreadyAddedProjects.contains(project.getName()) && GroovyNature.hasGroovyNature((IProject)project)) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                AddDSLSupportJob job = new AddDSLSupportJob(javaProject);
                job.setRule(this.getSetClassPathSchedulingRule(javaProject));
                job.setPriority(40);
                job.setSystem(true);
                job.schedule();
            }
            ++n2;
        }
    }

    private ISchedulingRule getSetClassPathSchedulingRule(IJavaProject javaProject) {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        return new MultiRule(new ISchedulingRule[]{ruleFactory.modifyRule((IResource)javaProject.getProject()), ruleFactory.modifyRule((IResource)JavaModelManager.getExternalManager().getExternalFoldersProject())});
    }

    public void dispose() {
        this.store.setValue("org.codehaus.groovy.eclipse.dsl.projects.ignore", this.alreadyAddedProjects.stream().collect(Collectors.joining(",")));
        if (this.store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.store).save();
            }
            catch (IOException e) {
                GroovyDSLCoreActivator.logException(e);
            }
        }
    }

    public void ignoreProject(IProject project) {
        this.alreadyAddedProjects.add(project.getName());
    }

    public void unignoreProject(IProject project) {
        this.alreadyAddedProjects.remove(project.getName());
    }

    public void unignoreAllProjects() {
        this.alreadyAddedProjects.clear();
    }

    private class AddDSLSupportJob
    extends Job {
        private final IJavaProject javaProject;

        private AddDSLSupportJob(IJavaProject javaProject) {
            super("Add DSL Support");
            this.javaProject = javaProject;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (!GroovyRuntime.findClasspathEntry((IJavaProject)this.javaProject, cpe -> cpe.getPath().equals((Object)GroovyDSLCoreActivator.CLASSPATH_CONTAINER_ID)).isPresent()) {
                    GroovyRuntime.appendClasspathEntry((IJavaProject)this.javaProject, (IClasspathEntry)JavaCore.newContainerEntry((IPath)GroovyDSLCoreActivator.CLASSPATH_CONTAINER_ID));
                }
                AutoAddContainerSupport.this.alreadyAddedProjects.add(this.javaProject.getElementName());
                return Status.OK_STATUS;
            }
            catch (JavaModelException e) {
                GroovyDSLCoreActivator.logException("Problem auto-adding DSL support to " + this.javaProject.getElementName(), e);
                return e.getStatus();
            }
        }
    }
}

