/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;

public enum ASTFragmentKind {
    PROPERTY,
    SAFE_PROPERTY,
    SPREAD_SAFE_PROPERTY,
    METHOD_POINTER,
    METHOD_CALL,
    BINARY,
    SIMPLE_EXPRESSION,
    EMPTY,
    ENCLOSING;


    static ASTFragmentKind toPropertyKind(Expression expr) {
        if (expr instanceof PropertyExpression) {
            PropertyExpression prop = (PropertyExpression)expr;
            if (prop.isSpreadSafe()) {
                return SPREAD_SAFE_PROPERTY;
            }
            if (prop.isSafe()) {
                return SAFE_PROPERTY;
            }
            return PROPERTY;
        }
        if (expr instanceof MethodPointerExpression) {
            return METHOD_POINTER;
        }
        if (expr instanceof MethodCallExpression) {
            return METHOD_CALL;
        }
        if (expr instanceof BinaryExpression) {
            return BINARY;
        }
        return SIMPLE_EXPRESSION;
    }

    public static boolean isExpressionKind(IASTFragment fragment) {
        if (fragment == null) {
            return false;
        }
        ASTFragmentKind kind = fragment.kind();
        switch (kind) {
            case PROPERTY: 
            case SAFE_PROPERTY: 
            case SPREAD_SAFE_PROPERTY: 
            case METHOD_POINTER: 
            case METHOD_CALL: 
            case BINARY: 
            case SIMPLE_EXPRESSION: {
                return true;
            }
        }
        return false;
    }
}

