/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.requestor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyExtendedCompletionContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ContentAssistContext {
    public final int completionLocation;
    public final int completionEnd;
    public final String completionExpression;
    public final String fullCompletionExpression;
    public final ASTNode completionNode;
    public final ASTNode containingCodeBlock;
    public final ASTNode lhsNode;
    public ClassNode lhsType;
    public final ContentAssistLocation location;
    public final GroovyCompilationUnit unit;
    public final AnnotatedNode containingDeclaration;
    public VariableScope currentScope;
    private Set<String> favoriteStaticMembers;

    public ContentAssistContext(int completionLocation, String completionExpression, String fullCompletionExpression, ASTNode completionNode, ASTNode containingCodeBlock, ASTNode lhsNode, ContentAssistLocation location, GroovyCompilationUnit unit, AnnotatedNode containingDeclaration, int completionEnd) {
        this.completionLocation = completionLocation;
        this.completionExpression = completionExpression;
        this.fullCompletionExpression = fullCompletionExpression;
        this.completionNode = completionNode;
        this.containingCodeBlock = containingCodeBlock;
        this.lhsNode = lhsNode;
        this.location = location;
        this.unit = unit;
        this.containingDeclaration = containingDeclaration;
        this.completionEnd = completionEnd;
    }

    public final void extend(CompletionContext that, VariableScope scope) {
        if (that != null && !that.isExtended()) {
            if (scope == null) {
                scope = this.getPerceivedCompletionScope();
            }
            ReflectionUtils.setPrivateField(InternalCompletionContext.class, (String)"isExtended", (Object)that, (Object)Boolean.TRUE);
            ReflectionUtils.setPrivateField(InternalCompletionContext.class, (String)"extendedContext", (Object)that, (Object)((Object)new GroovyExtendedCompletionContext(this, scope)));
        }
    }

    public IType getEnclosingType() {
        try {
            IJavaElement element = this.unit.getElementAt(this.completionLocation);
            if (element != null) {
                return (IType)element.getAncestor(7);
            }
        }
        catch (JavaModelException e) {
            GroovyContentAssist.logError("Exception finding completion for " + this.unit, e);
        }
        return null;
    }

    public ClassNode getEnclosingGroovyType() {
        ClassNode containingTypeDecl;
        if (!(this.containingDeclaration instanceof ClassNode)) {
            containingTypeDecl = this.containingDeclaration.getDeclaringClass();
        } else {
            containingTypeDecl = (ClassNode)this.containingDeclaration;
            if (this.containingCodeBlock instanceof AnnotationNode && this.containingCodeBlock.getEnd() < containingTypeDecl.getNameStart()) {
                containingTypeDecl = containingTypeDecl.getOuterClass();
            }
        }
        return containingTypeDecl;
    }

    public Set<String> getFavoriteStaticMembers() {
        if (this.favoriteStaticMembers == null) {
            String serializedFavorites = PreferenceConstants.getPreferenceStore().getString("content_assist_favorite_static_members");
            this.favoriteStaticMembers = serializedFavorites != null && serializedFavorites.length() > 0 ? (Set<Object>)Arrays.stream(serializedFavorites.split(";")).filter(it -> it.indexOf(46) != -1).collect(Collectors.toCollection(TreeSet::new)) : Collections.emptySet();
        }
        return this.favoriteStaticMembers;
    }

    public ASTNode getPerceivedCompletionNode() {
        return this.completionNode;
    }

    public String getPerceivedCompletionExpression() {
        return this.completionExpression.replaceAll("^(?:@|new\\b)|\\s+", "");
    }

    public String getQualifiedCompletionExpression() {
        return this.fullCompletionExpression.replaceAll("^(?:@|new\\b)|\\s+", "");
    }

    public VariableScope getPerceivedCompletionScope() {
        if (this.currentScope == null && this.completionNode != null) {
            TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(this.unit);
            visitor.visitCompilationUnit((node, result, enclosingElement) -> {
                if (node == this.completionNode) {
                    this.currentScope = result.scope;
                    return ITypeRequestor.VisitStatus.STOP_VISIT;
                }
                return ITypeRequestor.VisitStatus.CONTINUE;
            });
        }
        return this.currentScope;
    }

    public boolean isParenAfter(IDocument document) {
        if (document != null && document.getLength() > this.completionEnd) {
            try {
                return '(' == document.getChar(this.completionEnd);
            }
            catch (BadLocationException e) {
                GroovyContentAssist.logError("Exception during content assist", e);
            }
        }
        return false;
    }
}

