/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.requestor;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.codehaus.groovy.eclipse.core.util.VisitCompleteException;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.groovy.core.util.DepthFirstVisitor;

public class CompletionNodeFinder
extends DepthFirstVisitor {
    private final int completionEnd;
    private final int completionOffset;
    private final int supportingNodeEnd;
    private final String completionExpression;
    private final String fullCompletionExpression;
    private GroovyCompilationUnit unit;
    private ContentAssistContext context;
    private ASTNode lhsNode;
    private final Deque<ASTNode> blockStack = new LinkedList<ASTNode>();
    private final Deque<AnnotatedNode> declarationStack = new LinkedList<AnnotatedNode>();
    private final Deque<TupleExpression> argumentListStack = new LinkedList<TupleExpression>();

    public CompletionNodeFinder(int completionOffset, int completionEnd, int supportingNodeEnd, String completionExpression, String fullCompletionExpression) {
        this.completionOffset = completionOffset;
        this.completionEnd = completionEnd;
        this.supportingNodeEnd = supportingNodeEnd;
        this.completionExpression = Objects.requireNonNull(completionExpression);
        this.fullCompletionExpression = Objects.requireNonNull(fullCompletionExpression);
    }

    public ContentAssistContext findContentAssistContext(GroovyCompilationUnit unit) {
        try {
            try {
                this.unit = unit;
                this.visitModule(unit.getModuleNode());
            }
            catch (VisitCompleteException visitCompleteException) {
                this.unit = null;
            }
        }
        finally {
            this.unit = null;
        }
        return this.context;
    }

    public ContentAssistContext getContext() {
        return this.context;
    }

    public void visitPackage(PackageNode node) {
        this.declarationStack.add((AnnotatedNode)node);
        this.visitAnnotations(node.getAnnotations());
        if (this.check((ASTNode)node)) {
            this.createContext(null, (ASTNode)node, ContentAssistLocation.PACKAGE);
        }
        this.declarationStack.removeLast();
    }

    public void visitImport(ImportNode node) {
        this.declarationStack.add((AnnotatedNode)node);
        this.visitAnnotations(node.getAnnotations());
        if (this.check((ASTNode)node)) {
            this.createContext(null, (ASTNode)node, ContentAssistLocation.IMPORT);
        }
        this.declarationStack.removeLast();
    }

    public void visitClass(ClassNode node) {
        if (this.completionOffset <= node.getStart() || node.getEnd() < this.completionOffset) {
            return;
        }
        this.declarationStack.add((AnnotatedNode)node);
        this.visitGenerics(node.getGenericsTypes(), (ASTNode)node);
        ClassNode ext = node.getUnresolvedSuperClass();
        if (this.check((ASTNode)ext)) {
            this.createContext(null, (ASTNode)node, ContentAssistLocation.EXTENDS);
        }
        ClassNode[] classNodeArray = node.getUnresolvedInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode imp = classNodeArray[n2];
            if (this.check((ASTNode)imp)) {
                this.createContext(null, (ASTNode)node, ContentAssistLocation.IMPLEMENTS);
            }
            ++n2;
        }
        this.blockStack.add((ASTNode)node);
        super.visitClass(node);
        this.blockStack.removeLast();
        if (!node.isScript()) {
            this.createContext(null, (ASTNode)node, ContentAssistLocation.CLASS_BODY);
        }
        this.declarationStack.removeLast();
    }

    public void visitField(FieldNode node) {
        if (this.completionOffset <= node.getStart() || node.getEnd() < this.completionOffset) {
            return;
        }
        this.declarationStack.add((AnnotatedNode)node);
        if (!node.isEnum() && this.check((ASTNode)node.getType())) {
            this.createContext(null, (ASTNode)node.getDeclaringClass(), ContentAssistLocation.CLASS_BODY);
        }
        this.blockStack.add((ASTNode)node);
        super.visitField(node);
        this.blockStack.removeLast();
        this.declarationStack.removeLast();
        if (!(node.isEnum() || node.isStatic() && node.getEnd() > node.getNameEnd() + 1)) {
            this.createContext((ASTNode)node, (ASTNode)node.getDeclaringClass(), ContentAssistLocation.CLASS_BODY);
        }
    }

    public void visitProperty(PropertyNode node) {
        if (this.completionOffset <= node.getStart() || node.getEnd() < this.completionOffset) {
            return;
        }
        this.declarationStack.add((AnnotatedNode)node);
        if (this.check((ASTNode)node.getType())) {
            this.createContext(null, (ASTNode)node.getDeclaringClass(), ContentAssistLocation.CLASS_BODY);
        }
        this.blockStack.add((ASTNode)node);
        super.visitProperty(node);
        this.blockStack.removeLast();
        this.declarationStack.removeLast();
    }

    public void visitMethod(MethodNode node) {
        if (node == this.runMethod || node.isStaticConstructor()) {
            return;
        }
        Statement body = node.getCode();
        if (!node.isScriptBody()) {
            if (node.hasAnnotationDefault()) {
                this.lhsNode = new DepthFirstVisitor.MemberValueExpression(node.getName(), ((ReturnStatement)node.getCode()).getExpression(), new AnnotationNode(node.getDeclaringClass()));
            }
            this.declarationStack.add((AnnotatedNode)node);
            this.visitGenerics(node.getGenericsTypes(), (ASTNode)node);
            if (this.check((ASTNode)node.getReturnType())) {
                this.createContext(null, (ASTNode)node.getDeclaringClass(), ContentAssistLocation.CLASS_BODY);
            }
            if (CompletionNodeFinder.isNotEmpty((Object[])node.getExceptions())) {
                ClassNode[] classNodeArray = node.getExceptions();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode type = classNodeArray[n2];
                    if (this.check((ASTNode)type)) {
                        this.createContext(null, (ASTNode)node, ContentAssistLocation.EXCEPTIONS);
                    }
                    ++n2;
                }
            }
            this.blockStack.add((ASTNode)node);
            super.visitMethod(node);
            this.blockStack.removeLast();
            int lparenOffset = node.getNameEnd() + 1;
            if (lparenOffset < this.completionOffset && this.completionOffset <= node.getEnd()) {
                int rparenOffset = (Integer)node.getNodeMetaData((Object)"rparen.offset");
                if (this.completionOffset <= rparenOffset) {
                    this.createContext(null, (ASTNode)node, ContentAssistLocation.PARAMETER);
                } else if (body != null && this.check((ASTNode)body)) {
                    this.createContext((ASTNode)body, (ASTNode)body, this.expressionOrStatement());
                }
            }
            this.declarationStack.removeLast();
        } else if (body != null) {
            this.declarationStack.add((AnnotatedNode)node);
            this.blockStack.add((ASTNode)node);
            body.visit((GroovyCodeVisitor)this);
            this.createContext((ASTNode)body, (ASTNode)body, this.expressionOrScript());
        }
    }

    protected void visitAnnotation(AnnotationNode node) {
        if (this.completionOffset >= node.getClassNode().getStart() && this.completionOffset <= node.getClassNode().getEnd()) {
            this.createContext((ASTNode)node.getClassNode(), (ASTNode)node, ContentAssistLocation.ANNOTATION);
        }
        this.blockStack.add((ASTNode)node);
        super.visitAnnotation(node);
        int annoEnd = node.getEnd();
        int nameEnd = node.getClassNode().getEnd();
        if (annoEnd > nameEnd && this.completionOffset > nameEnd && this.completionOffset < annoEnd) {
            this.createContext((ASTNode)node, (ASTNode)node, ContentAssistLocation.ANNOTATION_BODY);
        }
        this.blockStack.removeLast();
    }

    protected void visitParameter(Parameter node) {
        boolean isCatchParam;
        this.blockStack.add((ASTNode)node);
        super.visitParameter(node);
        this.blockStack.removeLast();
        if (this.check((ASTNode)node.getType()) || this.check((ASTNode)node) && this.completionOffset < node.getNameStart()) {
            this.createContext((ASTNode)node, this.blockStack.getLast(), (isCatchParam = this.blockStack.getLast() instanceof CatchStatement) ? ContentAssistLocation.EXCEPTIONS : ContentAssistLocation.PARAMETER);
        }
        if (node.getNameStart() <= this.completionOffset && this.completionOffset <= node.getNameEnd() + 1) {
            isCatchParam = this.blockStack.getLast() instanceof CatchStatement && (node.getName().equals("?") || node.getType().getEnd() < 1);
            this.createContext((ASTNode)node, this.blockStack.getLast(), isCatchParam ? ContentAssistLocation.EXCEPTIONS : ContentAssistLocation.PARAMETER);
        }
        if (this.check((ASTNode)node)) {
            this.createContext((ASTNode)node, this.blockStack.getLast(), this.expressionOrStatement());
        }
    }

    protected void visitVariable(Variable var) {
        assert (!(var instanceof DynamicVariable) && !(var instanceof VariableExpression));
        if (var instanceof ASTNode) {
            this.lhsNode = (ASTNode)var;
        }
        super.visitVariable(var);
        this.lhsNode = null;
    }

    private void visitArguments(Expression args, Expression call) {
        boolean doContext = false;
        if (args instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)args;
            for (Expression expr : tuple.getExpressions()) {
                if (expr.getStart() != this.completionOffset) continue;
                doContext = true;
                break;
            }
            this.argumentListStack.add(tuple);
        } else if (args != null && args.getStart() == this.completionOffset) {
            doContext = true;
        }
        if (!doContext) {
            ASTNode lhs = this.lhsNode;
            this.lhsNode = null;
            args.visit((GroovyCodeVisitor)this);
            this.lhsNode = lhs;
        }
        if (args instanceof TupleExpression) {
            this.argumentListStack.removeLast();
        }
    }

    private void visitGenerics(GenericsType[] gts, ASTNode node) {
        if (CompletionNodeFinder.isNotEmpty((Object[])gts) && gts[0].getStart() <= this.completionOffset && this.completionOffset <= gts[gts.length - 1].getEnd()) {
            GenericsType[] genericsTypeArray = gts;
            int n = gts.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gt = genericsTypeArray[n2];
                if (gt.getStart() <= this.completionOffset && this.completionOffset <= gt.getEnd()) {
                    ClassNode type;
                    if (!gt.isPlaceholder() && this.check((ASTNode)(type = gt.getType()))) {
                        this.createContext((ASTNode)type, node, ContentAssistLocation.GENERICS);
                    }
                    if (gt.getLowerBound() != null && this.check((ASTNode)(type = gt.getLowerBound()))) {
                        this.createContext((ASTNode)type, node, ContentAssistLocation.GENERICS);
                    }
                    if (CompletionNodeFinder.isNotEmpty((Object[])gt.getUpperBounds())) {
                        ClassNode[] classNodeArray = gt.getUpperBounds();
                        int n3 = classNodeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            type = classNodeArray[n4];
                            if (this.check((ASTNode)type)) {
                                this.createContext((ASTNode)type, node, ContentAssistLocation.GENERICS);
                            }
                            ++n4;
                        }
                    }
                    this.createContext((ASTNode)gt, node, ContentAssistLocation.GENERICS);
                }
                ++n2;
            }
            this.createContext(null, node, ContentAssistLocation.GENERICS);
        }
    }

    public void visitBlockStatement(BlockStatement statement) {
        this.blockStack.add((ASTNode)statement);
        super.visitBlockStatement(statement);
        if (this.check((ASTNode)statement)) {
            this.createContext(this.blockStack.getLast(), (ASTNode)statement, this.expressionOrStatement());
        }
        this.blockStack.removeLast();
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.blockStack.add((ASTNode)statement);
        super.visitCatchStatement(statement);
        this.blockStack.removeLast();
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        super.visitExpressionStatement(statement);
        if (this.check((ASTNode)statement)) {
            Expression expression = statement.getExpression();
            int exprEnd = expression.getEnd();
            int stateEnd = statement.getEnd();
            if ((this.completionOffset <= stateEnd && this.completionOffset > exprEnd || this.supportingNodeEnd <= stateEnd && this.supportingNodeEnd > exprEnd) && (expression instanceof VariableExpression || expression instanceof ConstantExpression || expression instanceof PropertyExpression)) {
                if (expression instanceof PropertyExpression) {
                    expression = CompletionNodeFinder.getRightMost(expression);
                }
                if (expression != null) {
                    if (this.supportingNodeEnd > 0 && this.fullCompletionExpression.endsWith(".") && this.completionExpression.isEmpty()) {
                        this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.EXPRESSION);
                    } else {
                        this.createContextForCallContext(expression, (AnnotatedNode)expression, expression.getText());
                    }
                }
            }
        }
    }

    public void visitForLoop(ForStatement statement) {
        this.blockStack.add((ASTNode)statement);
        super.visitForLoop(statement);
        this.blockStack.removeLast();
    }

    public void visitArrayExpression(ArrayExpression expression) {
        if (this.check((ASTNode)expression)) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), this.expressionOrStatement());
        }
        super.visitArrayExpression(expression);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        if (expression.getOperation().isA(1100)) {
            this.lhsNode = expression.getLeftExpression();
            super.visitBinaryExpression(expression);
            this.lhsNode = null;
        } else {
            super.visitBinaryExpression(expression);
            if (expression.getOperation().getType() == 30 && this.check((ASTNode)expression)) {
                this.createContext((ASTNode)expression, this.blockStack.getLast(), this.expressionOrStatement());
            }
        }
    }

    public void visitCastExpression(CastExpression expression) {
        if (this.check((ASTNode)expression.getType())) {
            this.createContext((ASTNode)expression.getType(), this.blockStack.getLast(), this.expressionOrStatement());
        }
        super.visitCastExpression(expression);
    }

    public void visitClassExpression(ClassExpression expression) {
        if (this.check((ASTNode)expression)) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), this.expressionOrStatement());
        }
        super.visitClassExpression(expression);
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.blockStack.add((ASTNode)expression);
        super.visitClosureExpression(expression);
        this.blockStack.removeLast();
        if (this.check((ASTNode)expression)) {
            this.createContext((ASTNode)expression, (ASTNode)expression.getCode(), this.expressionOrStatement());
        }
    }

    public void visitConstantExpression(ConstantExpression expression) {
        if (expression instanceof AnnotationConstantExpression && this.check((ASTNode)expression.getType())) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.ANNOTATION);
        }
        if (this.completionOffset > expression.getStart() && this.completionOffset <= expression.getEnd()) {
            if (CompletionNodeFinder.isStringLiteral(expression)) {
                throw new VisitCompleteException();
            }
            this.createContext((ASTNode)expression, this.blockStack.getLast(), this.expressionOrStatement());
        }
        super.visitConstantExpression(expression);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression expression) {
        if (this.supportingNodeEnd > 0 && this.supportingNodeEnd == expression.getEnd()) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.EXPRESSION);
        }
        if (this.completionOffset <= expression.getStart() || expression.getEnd() < this.completionOffset) {
            super.visitConstructorCallExpression(expression);
            return;
        }
        this.visitAnnotations(expression.getAnnotations());
        if (this.completionOffset <= expression.getNameStart()) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), this.expressionOrStatement());
        }
        ClassNode constructorType = expression.getType();
        if (expression.isSpecialCall()) {
            AnnotatedNode enclosing = this.declarationStack.getLast();
            constructorType = enclosing.getDeclaringClass();
            if (expression.isSuperCall()) {
                constructorType = constructorType.getUnresolvedSuperClass(false);
            }
        } else if (expression.isUsingAnonymousInnerClass() && (constructorType = expression.getType().getUnresolvedSuperClass(false)) == ClassHelper.OBJECT_TYPE) {
            constructorType = expression.getType().getUnresolvedInterfaces(false)[0];
        }
        if (this.completionOffset <= expression.getNameEnd() + 1) {
            this.createContext((ASTNode)constructorType, this.blockStack.getLast(), ContentAssistLocation.CONSTRUCTOR);
        }
        this.visitGenerics(constructorType.getGenericsTypes(), (ASTNode)expression);
        this.visitArguments(expression.getArguments(), (Expression)expression);
        if (expression.isUsingAnonymousInnerClass()) {
            this.visitClass(expression.getType());
        }
        if (this.completionEnd > expression.getArguments().getEnd()) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.STATEMENT);
        }
        this.createContextForCallContext((Expression)expression, (AnnotatedNode)constructorType, constructorType.getNameWithoutPackage(), expression.getNameEnd() + 1);
    }

    public void visitFieldExpression(FieldExpression expression) {
        if (this.check((ASTNode)expression)) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), this.expressionOrStatement());
        }
        super.visitFieldExpression(expression);
    }

    public void visitGStringExpression(GStringExpression expression) {
        this.visitExpressions(expression.getValues());
        for (ConstantExpression stringExpr : expression.getStrings()) {
            if (!this.check((ASTNode)stringExpr)) continue;
            throw new VisitCompleteException();
        }
    }

    public void visitListExpression(ListExpression expression) {
        super.visitListExpression(expression);
        if (this.check((ASTNode)expression)) {
            this.createContext((ASTNode)expression, (ASTNode)this.declarationStack.getLast(), ContentAssistLocation.EXPRESSION);
        }
    }

    public void visitMapExpression(MapExpression expression) {
        super.visitMapExpression(expression);
        if (this.check((ASTNode)expression) && !this.isArgument((Expression)expression)) {
            this.createContext((ASTNode)expression, (ASTNode)this.declarationStack.getLast(), ContentAssistLocation.EXPRESSION);
        }
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        if (this.check((ASTNode)expression.getValueExpression()) && this.isArgument((Expression)expression)) {
            this.lhsNode = expression.getKeyExpression();
        }
        super.visitMapEntryExpression(expression);
    }

    public void visitMethodCallExpression(MethodCallExpression expression) {
        if (this.supportingNodeEnd > 0 && this.supportingNodeEnd == expression.getEnd()) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.EXPRESSION);
        }
        if (this.completionOffset <= expression.getStart() || expression.getEnd() < this.completionOffset) {
            super.visitMethodCallExpression(expression);
            return;
        }
        this.visitAnnotations(expression.getAnnotations());
        Expression objectExpression = expression.getObjectExpression();
        Expression methodExpression = expression.getMethod();
        this.checkForCommandExpression(objectExpression, methodExpression);
        objectExpression.visit((GroovyCodeVisitor)this);
        if (objectExpression.getEnd() < this.completionOffset && this.completionOffset <= methodExpression.getStart()) {
            this.visitGenerics(expression.getGenericsTypes(), (ASTNode)expression);
            this.createContext((ASTNode)objectExpression, this.blockStack.getLast(), ContentAssistLocation.EXPRESSION);
        }
        methodExpression.visit((GroovyCodeVisitor)this);
        this.visitArguments(expression.getArguments(), (Expression)expression);
        if (this.completionEnd > expression.getArguments().getEnd()) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.STATEMENT);
        }
        this.createContextForCallContext((Expression)expression, (AnnotatedNode)methodExpression, expression.getMethodAsString());
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        if (!this.check((ASTNode)expression)) {
            return;
        }
        Expression objectExpression = expression.getObjectExpression();
        Expression propertyExpression = expression.getProperty();
        this.checkForCommandExpression(objectExpression, propertyExpression);
        if (this.completionOffset > objectExpression.getEnd() && this.completionOffset < propertyExpression.getStart()) {
            this.createContext((ASTNode)objectExpression, this.blockStack.getLast(), ContentAssistLocation.EXPRESSION);
        }
        super.visitPropertyExpression(expression);
        this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.EXPRESSION);
    }

    public void visitRangeExpression(RangeExpression expression) {
        super.visitRangeExpression(expression);
        if (this.completionOffset > expression.getStart() && this.completionOffset <= expression.getEnd()) {
            if (this.completionOffset <= expression.getFrom().getEnd() || this.completionOffset >= expression.getTo().getStart()) {
                this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.STATEMENT);
            }
            throw new VisitCompleteException();
        }
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression expression) {
        if (this.supportingNodeEnd > 0 && this.supportingNodeEnd == expression.getEnd()) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.EXPRESSION);
        }
        if (this.completionOffset <= expression.getStart() || expression.getEnd() < this.completionOffset) {
            super.visitStaticMethodCallExpression(expression);
            return;
        }
        this.visitAnnotations(expression.getAnnotations());
        if (expression.getNameStart() < this.completionOffset && this.completionOffset <= expression.getNameEnd() + 1) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.STATEMENT);
        }
        this.visitArguments(expression.getArguments(), (Expression)expression);
        if (this.completionEnd > expression.getArguments().getEnd()) {
            this.createContext((ASTNode)expression, this.blockStack.getLast(), ContentAssistLocation.STATEMENT);
        }
        this.createContextForCallContext((Expression)expression, (AnnotatedNode)expression, expression.getMethod(), expression.getNameEnd() + 1);
    }

    public void visitVariableExpression(VariableExpression expression) {
        ClassNode type;
        this.visitAnnotations(expression.getAnnotations());
        if (expression.getAccessedVariable() == expression && this.check((ASTNode)(type = expression.getOriginType()))) {
            this.createContext((ASTNode)type, this.blockStack.getLast(), this.expressionOrStatement());
        }
        if (this.check((ASTNode)expression)) {
            ContentAssistLocation loc = ContentAssistLocation.EXPRESSION;
            if (this.blockStack.getLast() instanceof AnnotationNode) {
                loc = ContentAssistLocation.ANNOTATION_BODY;
            } else if (this.supportingNodeEnd == -1) {
                loc = ContentAssistLocation.STATEMENT;
            }
            this.createContext((ASTNode)expression, this.blockStack.getLast(), loc);
        }
        this.visitExpression((Expression)expression);
    }

    private boolean check(ASTNode node) {
        if (node.getEnd() > 0) {
            ClassNode type;
            boolean containsSupportingOffset;
            boolean containsCompletionOffset = this.completionOffset > node.getStart() && this.completionOffset <= node.getEnd();
            boolean bl = containsSupportingOffset = this.supportingNodeEnd > node.getStart() && this.supportingNodeEnd <= node.getEnd();
            if (!containsCompletionOffset && !containsSupportingOffset && node instanceof ClassNode && (type = (ClassNode)node).isUsingGenerics()) {
                this.visitGenerics(type.getGenericsTypes(), (ASTNode)type);
            }
            return containsCompletionOffset || containsSupportingOffset;
        }
        return false;
    }

    private void checkForCommandExpression(Expression leftExpression, Expression rightExpression) {
        Expression leftMost = CompletionNodeFinder.getLeftMost(rightExpression);
        if (CompletionNodeFinder.isMethodCallWithOneArgument(leftExpression) && leftMost instanceof ConstantExpression && this.check((ASTNode)leftMost)) {
            this.createContext((ASTNode)leftExpression, this.blockStack.getLast(), ContentAssistLocation.EXPRESSION);
        }
    }

    private void createContext(ASTNode completionNode, ASTNode containingNode, ContentAssistLocation location) {
        this.context = new ContentAssistContext(this.completionOffset, this.completionExpression, this.fullCompletionExpression, completionNode, containingNode, this.lhsNode, location, this.unit, this.declarationStack.getLast(), this.completionEnd);
        throw new VisitCompleteException();
    }

    private void createContextForCallContext(Expression expression, AnnotatedNode methodExpr, String methodName) {
        this.createContextForCallContext(expression, methodExpr, methodName, methodExpr.getEnd());
    }

    private void createContextForCallContext(Expression expression, AnnotatedNode methodExpr, String methodName, int methodNameEnd) {
        this.context = new MethodInfoContentAssistContext(this.completionOffset, this.completionExpression, this.fullCompletionExpression, (ASTNode)expression, this.blockStack.getLast(), this.lhsNode, this.unit, this.declarationStack.getLast(), this.completionEnd, methodExpr, methodName, methodNameEnd);
        throw new VisitCompleteException();
    }

    private ContentAssistLocation expressionOrScript() {
        return this.supportingNodeEnd == -1 ? ContentAssistLocation.SCRIPT : ContentAssistLocation.EXPRESSION;
    }

    private ContentAssistLocation expressionOrStatement() {
        return this.supportingNodeEnd == -1 ? ContentAssistLocation.STATEMENT : ContentAssistLocation.EXPRESSION;
    }

    private boolean isArgument(Expression expr) {
        if (this.argumentListStack.isEmpty()) {
            return false;
        }
        TupleExpression tuple = this.argumentListStack.getLast();
        return this.isArgument(expr, tuple.getExpressions());
    }

    private boolean isArgument(Expression expr, List<? extends Expression> args) {
        if (CompletionNodeFinder.isNotEmpty(args)) {
            for (Expression expression : args) {
                if (expression == expr) {
                    return true;
                }
                if (!(expression instanceof NamedArgumentListExpression)) continue;
                return this.isArgument(expr, ((NamedArgumentListExpression)expression).getMapEntryExpressions());
            }
        }
        return false;
    }

    private static Expression getLeftMost(Expression expr) {
        if (expr instanceof ConstantExpression) {
            return expr;
        }
        if (expr instanceof PropertyExpression) {
            return CompletionNodeFinder.getLeftMost(((PropertyExpression)expr).getObjectExpression());
        }
        if (expr instanceof MethodCallExpression) {
            return CompletionNodeFinder.getLeftMost(((MethodCallExpression)expr).getObjectExpression());
        }
        if (expr instanceof BinaryExpression) {
            return CompletionNodeFinder.getLeftMost(((BinaryExpression)expr).getLeftExpression());
        }
        return null;
    }

    private static Expression getRightMost(Expression expr) {
        if (expr instanceof VariableExpression || expr instanceof ConstantExpression) {
            return expr;
        }
        if (expr instanceof PropertyExpression) {
            return CompletionNodeFinder.getRightMost(((PropertyExpression)expr).getProperty());
        }
        if (expr instanceof BinaryExpression) {
            return CompletionNodeFinder.getRightMost(((BinaryExpression)expr).getRightExpression());
        }
        return null;
    }

    private static boolean isMethodCallWithOneArgument(Expression expr) {
        if (expr instanceof MethodCallExpression) {
            Expression arguments = ((MethodCallExpression)expr).getArguments();
            return arguments instanceof TupleExpression && ((TupleExpression)arguments).getExpressions() != null && !((TupleExpression)arguments).getExpressions().isEmpty();
        }
        return false;
    }

    private static boolean isStringLiteral(ConstantExpression expr) {
        if (ClassHelper.STRING_TYPE.equals((Object)expr.getType())) {
            return expr.getLength() > expr.getText().length();
        }
        return false;
    }
}

