/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.creators.AbstractProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.FieldProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.MethodProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.factories.IGroovyCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.IGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.PackageCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.TypeCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.groovy.core.util.DepthFirstVisitor;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.TypeProposalInfo;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class AnnotationMemberValueCompletionProcessorFactory
implements IGroovyCompletionProcessorFactory {
    @Override
    public IGroovyCompletionProcessor createProcessor(final ContentAssistContext context, final JavaContentAssistInvocationContext javaContext, final SearchableEnvironment nameEnvironment) {
        return new AbstractGroovyCompletionProcessor(context, javaContext, nameEnvironment){

            @Override
            public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
                boolean memberFound;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Content assist in annotation", 3);
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                String memberName = this.getPerceivedCompletionMember();
                boolean bl = memberFound = !this.getAnnotation().getClassNode().getMethods(memberName).isEmpty();
                if (!memberFound || this.isImplicitValueExpression()) {
                    this.generateAnnotationMemberProposals(proposals);
                }
                monitor.worked(1);
                if (memberFound || this.isImplicitValueSupported() && this.getAnnotation().getMembers().isEmpty()) {
                    this.generateAnnotationMemberValueProposals(proposals, memberName != null ? memberName : "value", monitor);
                }
                monitor.worked(1);
                if ("enabled".equals(javaContext.getProject().getOption("org.eclipse.jdt.core.codeComplete.deprecationCheck", true))) {
                    Iterator it = proposals.iterator();
                    while (it.hasNext()) {
                        CompletionProposal proposal = 1.extractProposal((ICompletionProposal)it.next());
                        if (proposal == null || !Flags.isDeprecated((int)proposal.getFlags())) continue;
                        it.remove();
                    }
                }
                monitor.worked(1);
                return proposals;
            }

            private void generateAnnotationMemberProposals(List<ICompletionProposal> proposals) {
                Set currentMembers = this.getAnnotation().getMembers().keySet();
                if (this.isImplicitValueExpression()) {
                    currentMembers = new HashSet(currentMembers);
                    currentMembers.remove("value");
                }
                MethodProposalCreator methodProposalCreator = this.initProposalCreator(new MethodProposalCreator());
                List<IGroovyProposal> candidates = methodProposalCreator.findAllProposals(this.getAnnotation().getClassNode(), Collections.EMPTY_SET, context.completionExpression, false, true);
                for (IGroovyProposal candidate : candidates) {
                    GroovyMethodProposal gmp;
                    String src;
                    if (!(candidate instanceof GroovyMethodProposal) || "java.lang.Object".equals(src = (gmp = (GroovyMethodProposal)candidate).getMethod().getDeclaringClass().getName()) || "java.lang.annotation.Annotation".equals(src) || currentMembers.contains(gmp.getMethod().getName())) continue;
                    proposals.add((ICompletionProposal)gmp.createJavaProposal(context, javaContext));
                }
            }

            private void generateAnnotationMemberValueProposals(List<ICompletionProposal> proposals, String memberName, IProgressMonitor monitor) {
                ClassNode memberType;
                ModuleNodeMapper.ModuleNodeInfo moduleInfo = context.unit.getModuleInfo(true);
                MethodNode member = this.getAnnotation().getClassNode().getMethod(memberName, Parameter.EMPTY_ARRAY);
                IGroovyCompletionProcessor[] processors = new IGroovyCompletionProcessor[]{new TypeCompletionProcessor(context, javaContext, nameEnvironment), new PackageCompletionProcessor(context, javaContext, nameEnvironment)};
                SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)(processors.length + 1));
                IGroovyCompletionProcessor[] iGroovyCompletionProcessorArray = processors;
                int n = processors.length;
                int n2 = 0;
                while (n2 < n) {
                    IGroovyCompletionProcessor processor = iGroovyCompletionProcessorArray[n2];
                    if (processor instanceof ITypeResolver) {
                        ((ITypeResolver)processor).setResolverInformation(moduleInfo.module, moduleInfo.resolver);
                    }
                    proposals.addAll(processor.generateProposals((IProgressMonitor)submon.split(1)));
                    ++n2;
                }
                FieldProposalCreator fieldProposalCreator = this.initProposalCreator(new FieldProposalCreator());
                fieldProposalCreator.setFavoriteStaticMembers(context.getFavoriteStaticMembers());
                fieldProposalCreator.setCurrentScope(context.getPerceivedCompletionScope());
                ArrayList<ClassNode> completionTypes = new ArrayList<ClassNode>(2);
                if (context.containingDeclaration instanceof ClassNode) {
                    completionTypes.add((ClassNode)context.containingDeclaration);
                } else if (context.containingDeclaration.getDeclaringClass() != null) {
                    completionTypes.add(context.containingDeclaration.getDeclaringClass());
                }
                ClassNode classNode = memberType = member != null ? member.getReturnType() : ClassHelper.VOID_TYPE;
                if (memberType.isArray()) {
                    memberType = memberType.getComponentType();
                }
                if (memberType.isEnum()) {
                    completionTypes.add(memberType);
                    if (context.fullCompletionExpression.isEmpty()) {
                        proposals.add(this.newEnumTypeProposal(memberType));
                    }
                }
                ArrayList<IGroovyProposal> groovyProposals = new ArrayList<IGroovyProposal>();
                for (ClassNode completionType : completionTypes) {
                    groovyProposals.addAll(fieldProposalCreator.findAllProposals(completionType, Collections.EMPTY_SET, context.completionExpression, true, true));
                }
                for (IGroovyProposal groovyProposal : groovyProposals) {
                    FieldNode fieldNode;
                    if (!(groovyProposal instanceof GroovyFieldProposal) || !(fieldNode = ((GroovyFieldProposal)groovyProposal).getField()).isStatic() || !fieldNode.isFinal() || !memberType.equals((Object)fieldNode.getType())) continue;
                    if (fieldNode.isEnum() || fieldNode.getDeclaringClass().equals((Object)context.containingDeclaration) && this.isTypeAnnotation()) {
                        String declTypeName = fieldNode.getDeclaringClass().getName().replace('$', '.');
                        if (this.isNotStaticImported(fieldNode.getName(), declTypeName)) {
                            String staticImport = String.valueOf(declTypeName) + '.' + fieldNode.getName();
                            ((GroovyFieldProposal)groovyProposal).setRequiredStaticImport(staticImport);
                        }
                    }
                    proposals.add((ICompletionProposal)groovyProposal.createJavaProposal(context, javaContext));
                }
            }

            private AnnotationNode getAnnotation() {
                return (AnnotationNode)context.containingCodeBlock;
            }

            private String getPerceivedCompletionMember() {
                String maybe = null;
                for (Map.Entry member : this.getAnnotation().getMembers().entrySet()) {
                    Expression value = (Expression)member.getValue();
                    if (value.getStart() < context.completionLocation && context.completionLocation <= value.getEnd()) {
                        return (String)member.getKey();
                    }
                    if (value.getStart() > context.completionLocation) break;
                    if (value.getLineNumber() != -1) continue;
                    maybe = (String)member.getKey();
                }
                return maybe;
            }

            private <T extends AbstractProposalCreator> T initProposalCreator(T proposalCreator) {
                AssistOptions options = new AssistOptions(javaContext.getProject().getOptions(true));
                proposalCreator.setNameMatchingStrategy((pattern, candidate) -> ProposalUtils.matches(pattern, candidate, assistOptions.camelCaseMatch, assistOptions.substringMatch));
                return proposalCreator;
            }

            private boolean isImplicitValueExpression() {
                final boolean[] result = new boolean[1];
                AnnotationNode annotation = this.getAnnotation();
                Expression valueExpression = annotation.getMember("value");
                if (valueExpression != null && annotation.getMembers().keySet().size() == 1) {
                    valueExpression.visit((GroovyCodeVisitor)new DepthFirstVisitor(){

                        protected void visitExpression(Expression expression) {
                            if (expression == context.completionNode) {
                                result[0] = true;
                            }
                            super.visitExpression(expression);
                        }
                    });
                    if (result[0] && valueExpression.getStart() - annotation.getClassNode().getEnd() >= 7) {
                        int offset = annotation.getClassNode().getEnd();
                        int length = valueExpression.getStart() - offset;
                        String source = String.valueOf(context.unit.getContents(), offset, length);
                        result[0] = !Pattern.compile("\\bvalue\\s*=").matcher(source).find();
                    }
                }
                return result[0];
            }

            private boolean isImplicitValueSupported() {
                MethodNode valueMember = this.getAnnotation().getClassNode().getMethod("value", Parameter.EMPTY_ARRAY);
                return valueMember != null;
            }

            private boolean isNotStaticImported(String memberName, String declaringTypeName) {
                ModuleNode moduleNode = context.unit.getModuleNode();
                if (moduleNode.getStaticImports().containsKey(memberName)) {
                    ImportNode importNode = (ImportNode)moduleNode.getStaticImports().get(memberName);
                    return !importNode.getClassName().equals(declaringTypeName);
                }
                return !moduleNode.getStaticStarImports().containsKey(declaringTypeName);
            }

            private boolean isTypeAnnotation() {
                if (context.containingDeclaration instanceof ClassNode) {
                    return this.getAnnotation().getEnd() < ((ClassNode)context.containingDeclaration).getNameStart();
                }
                return false;
            }

            private ICompletionProposal newEnumTypeProposal(ClassNode enumType) {
                String signature = GroovyUtils.getTypeSignatureWithoutGenerics((ClassNode)enumType, (boolean)true, (boolean)true);
                CompletionProposal proposal = CompletionProposal.create((int)9, (int)0);
                proposal.setSignature(signature.toCharArray());
                proposal.setFlags(enumType.getModifiers());
                JavaTypeCompletionProposal javaProposal = new JavaTypeCompletionProposal(enumType.getName(), (ICompilationUnit)context.unit, context.completionLocation, 0, ProposalUtils.getImage(proposal), ProposalUtils.createDisplayString(proposal), Relevance.MEDIUM.getRelevance(), enumType.getName(), javaContext);
                javaProposal.setProposalInfo((ProposalInfo)new TypeProposalInfo(javaContext.getProject(), proposal));
                return javaProposal;
            }
        };
    }
}

