/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.jdt.groovy.model.JavaCoreUtil;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.InternalExtendedCompletionContext;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.SourceField;

public class GroovyExtendedCompletionContext
extends InternalExtendedCompletionContext {
    private final ContentAssistContext context;
    private final VariableScope currentScope;
    private IJavaElement enclosingElement;
    private final Map<String, IJavaElement[]> visibleElements;

    public GroovyExtendedCompletionContext(ContentAssistContext context, VariableScope currentScope) {
        super(null, null, null, null, null, null, null, null, null);
        this.context = context;
        this.currentScope = currentScope;
        this.visibleElements = new HashMap<String, IJavaElement[]>();
    }

    public boolean canUseDiamond(String[] parameterTypes, char[] fullyQualifiedTypeName) {
        return true;
    }

    public IJavaElement getEnclosingElement() {
        if (this.enclosingElement == null) {
            try {
                this.enclosingElement = this.context.unit.getElementAt(this.context.completionLocation);
            }
            catch (JavaModelException e) {
                GroovyContentAssist.logError("Exception computing content assist proposals", e);
            }
            if (this.enclosingElement == null) {
                this.enclosingElement = this.context.unit;
            }
        }
        return this.enclosingElement;
    }

    public IJavaElement[] getVisibleElements(String typeSignature) {
        return this.visibleElements.computeIfAbsent(Signature.getTypeErasure((String)typeSignature), this::computeVisibleElements);
    }

    private IJavaElement[] computeVisibleElements(String typeSignature) {
        int n;
        IType enclosingType;
        LinkedHashMap<String, IJavaElement> visibleElements = new LinkedHashMap<String, IJavaElement>();
        ClassNode targetType = this.toClassNode(typeSignature);
        if (this.currentScope != null) {
            for (VariableScope.VariableInfo varInfo : this.currentScope) {
                String varName = varInfo.name;
                if (varName.startsWith("get") || varName.startsWith("set") || varName.equals("this") || varName.equals("super") || varName.startsWith("<") || visibleElements.containsKey(varName)) continue;
                ClassNode type = varInfo.type;
                if (type == null) {
                    type = VariableScope.NULL_TYPE;
                }
                if (!GroovyUtils.isAssignable((ClassNode)type, (ClassNode)targetType)) continue;
                int start = 0;
                int until = varName.length() - 1;
                visibleElements.putIfAbsent(varName, (IJavaElement)new LocalVariable((JavaElement)this.getEnclosingElement(), varName, start, until, start, until, typeSignature, null, 0, false));
            }
        }
        if ((enclosingType = (IType)this.getEnclosingElement().getAncestor(7)) != null) {
            try {
                this.addFields(targetType, visibleElements, enclosingType);
                ITypeHierarchy typeHierarchy = enclosingType.newSupertypeHierarchy(null);
                IType[] iTypeArray = typeHierarchy.getAllSupertypes(enclosingType);
                n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType superType = iTypeArray[n2];
                    this.addFields(targetType, visibleElements, superType);
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                GroovyContentAssist.logError(e);
            }
        }
        if (targetType.isEnum()) {
            try {
                IType enumType = JavaCoreUtil.findType((String)targetType.getName(), (IJavaElement)this.enclosingElement);
                IField[] iFieldArray = enumType.getFields();
                n = iFieldArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IField enumField = iFieldArray[n3];
                    if (enumField.isEnumConstant()) {
                        visibleElements.putIfAbsent(enumField.getElementName(), (IJavaElement)enumField);
                    }
                    ++n3;
                }
            }
            catch (JavaModelException e) {
                GroovyContentAssist.logError(e);
            }
        }
        return visibleElements.values().toArray(new IJavaElement[0]);
    }

    protected void addFields(ClassNode targetType, Map<String, IJavaElement> visibleElements, IType type) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            ClassNode fieldTypeClassNode = this.toClassNode(field.getTypeSignature());
            if (GroovyUtils.isAssignable((ClassNode)fieldTypeClassNode, (ClassNode)targetType)) {
                visibleElements.putIfAbsent(field.getElementName(), (IJavaElement)field);
            }
            ++n2;
        }
        iFieldArray = type.getMethods();
        n = iFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            IField method = iFieldArray[n2];
            ClassNode methodReturnTypeClassNode = this.toClassNode(method.getReturnType());
            if (!VariableScope.VOID_CLASS_NODE.equals((Object)methodReturnTypeClassNode) && GroovyUtils.isAssignable((ClassNode)methodReturnTypeClassNode, (ClassNode)targetType) && (method.getParameterTypes() == null || method.getParameterTypes().length == 0) && (method.getElementName().startsWith("get") || method.getElementName().startsWith("is"))) {
                visibleElements.putIfAbsent(method.getElementName(), (IJavaElement)method);
                PropertyVariant field = new PropertyVariant((IMethod)method);
                visibleElements.putIfAbsent(field.getElementName(), (IJavaElement)field);
            }
            ++n2;
        }
    }

    protected ClassNode toClassNode(char[] typeSignature) {
        int dims = Signature.getArrayCount((char[])typeSignature);
        char[] base = Signature.getElementType((char[])typeSignature);
        char[] name = CharOperation.concat((char[])Signature.getSignatureQualifier((char[])base), (char[])Signature.getSignatureSimpleName((char[])base), (char)'.');
        ClassNode node = typeSignature.length == 1 + dims ? ClassHelper.make((String)String.valueOf(name)) : this.resolve(String.valueOf(name));
        while (dims-- > 0) {
            node = node.makeArray();
        }
        return node;
    }

    protected ClassNode toClassNode(String typeSignature) {
        int dims = Signature.getArrayCount((String)typeSignature);
        String base = Signature.getElementType((String)typeSignature);
        String name = Signature.getSignatureSimpleName((String)base);
        String qual = Signature.getSignatureQualifier((String)base);
        if (!qual.isEmpty()) {
            name = String.valueOf(qual) + '.' + name;
        }
        ClassNode node = typeSignature.length() == 1 + dims ? ClassHelper.make((String)name) : this.resolve(name);
        while (dims-- > 0) {
            node = node.makeArray();
        }
        return node;
    }

    protected ClassNode resolve(String fullyQualifiedTypeName) {
        ModuleNodeMapper.ModuleNodeInfo info = this.context.unit.getModuleInfo(false);
        return info.resolver.resolve(fullyQualifiedTypeName);
    }

    private static String toFieldName(IMethod method) {
        return ProposalUtils.createMockFieldName(method.getElementName());
    }

    private static class PropertyVariant
    extends SourceField
    implements IField {
        private final IMethod baseMethod;

        PropertyVariant(IMethod method) {
            super((JavaElement)method.getParent(), GroovyExtendedCompletionContext.toFieldName(method));
            this.baseMethod = method;
        }

        public boolean exists() {
            return true;
        }

        public String getTypeSignature() throws JavaModelException {
            return this.baseMethod.getReturnType();
        }

        public int getFlags() throws JavaModelException {
            return this.baseMethod.getFlags();
        }
    }
}

