/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.Load;

public class LoadInDays
implements Load {
    private final int days;
    private final int loadPerDay;

    private LoadInDays(int days, int loadPerDay) {
        this.days = days;
        this.loadPerDay = loadPerDay;
    }

    public static LoadInDays inDay(int days) {
        return new LoadInDays(days, 100);
    }

    public static Complement inDayWithLoad(int days, int loadPerDay) {
        int tmp = (int)Math.ceil((double)days * 100.0 / (double)loadPerDay);
        return new LoadInDays(tmp, loadPerDay);
    }

    @Override
    public int getFullLoad() {
        return this.days * this.loadPerDay;
    }

    @Override
    public int getLoadAt(Instant instant) {
        return this.loadPerDay;
    }
}

