/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.printskin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

class PrintSkin
extends AbstractPSystem {
    private static final UFont FONT1 = UFont.sansSerif(10);
    private final Skin skin = new Rose();
    private final List<String> toPrint;
    private UGraphic ug;
    private float xpos = 10.0f;
    private float ypos = 0.0f;
    private float maxYpos = 0.0f;

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormatOption, long seed) throws IOException {
        BufferedImage im = this.createImage();
        ImageDataSimple imageData = new ImageDataSimple(im.getWidth(), (int)this.maxYpos);
        PngIO.write((RenderedImage)im.getSubimage(0, 0, imageData.getWidth(), imageData.getHeight()), os, 96);
        return imageData;
    }

    private BufferedImage createImage() {
        EmptyImageBuilder builder = new EmptyImageBuilder(2000, 830, Color.WHITE);
        BufferedImage im = builder.getBufferedImage();
        Graphics2D g2d = builder.getGraphics2D();
        this.ug = new UGraphicG2d(new ColorMapperIdentity(), g2d, 1.0);
        for (ComponentType type : ComponentType.values()) {
            this.printComponent(type);
            this.ypos += 10.0f;
            this.maxYpos = Math.max(this.maxYpos, this.ypos);
            if (!(this.ypos > 620.0f)) continue;
            this.ypos = 0.0f;
            this.xpos += 200.0f;
        }
        g2d.dispose();
        return im;
    }

    private void printComponent(ComponentType type) {
        this.println(type.name());
        Component comp = this.skin.createComponent(type, ArrowConfiguration.withDirectionNormal(), SkinParam.noShadowing(null), Display.create(this.toPrint));
        if (comp == null) {
            this.println("null");
            return;
        }
        double height = comp.getPreferredHeight(this.ug.getStringBounder());
        double width = comp.getPreferredWidth(this.ug.getStringBounder());
        this.println("height = " + String.format("%4.2f", height));
        this.println("width = " + width);
        if (height == 0.0) {
            height = 42.0;
        }
        if (width == 0.0) {
            width = 42.0;
        }
        this.ug.apply(new UChangeBackColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(this.xpos - 1.0f, this.ypos - 1.0f)).draw(new URectangle(width + 2.0, height + 2.0));
        comp.drawU(this.ug.apply(new UTranslate(this.xpos, this.ypos)), new Area(new Dimension2DDouble(width, height)), new SimpleContext2D(false));
        this.ypos = (float)((double)this.ypos + height);
    }

    private void println(String s) {
        TextBlock textBlock = Display.create(s).create(FontConfiguration.blackBlueTrue(FONT1), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        textBlock.drawU(this.ug.apply(new UTranslate(this.xpos, this.ypos)));
        this.ypos = (float)((double)this.ypos + textBlock.calculateDimension(this.ug.getStringBounder()).getHeight());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Printing of " + this.skin.getClass().getName());
    }

    public PrintSkin(String className, List<String> toPrint) {
        this.toPrint = toPrint;
    }
}

