/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageMachine
extends AbstractEntityImage {
    private final TextBlock name;
    private final TextBlock stereo;
    private final Url url;

    public EntityImageMachine(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        this.name = TextBlockUtils.withMargin(entity.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.MACHINE, stereotype), HorizontalAlignment.CENTER, skinParam), 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel(false) == null ? null : Display.create(stereotype.getLabels(skinParam.useGuillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.MACHINE_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
    }

    private UStroke getStroke() {
        UStroke stroke = this.getSkinParam().getThickness(LineParam.machineBorder, this.getStereo());
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return stroke;
    }

    private Dimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private Dimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        Dimension2D nameDim = this.name.calculateDimension(stringBounder);
        Dimension2D stereoDim = this.stereo == null ? new Dimension2DDouble(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        Dimension2DDouble nameAndStereo = new Dimension2DDouble(Math.max(nameDim.getWidth(), stereoDim.getWidth()), nameDim.getHeight() + stereoDim.getHeight());
        return nameAndStereo;
    }

    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimTitle = this.getTitleDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal, 0.0, 0.0);
        URectangle rect2 = new URectangle(4.0, heightTotal, 0.0, 0.0);
        ug = ug.apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.machineBorder)));
        HtmlColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.machineBackground);
        }
        ug = ug.apply(new UChangeBackColor(backcolor));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UStroke stroke = this.getStroke();
        ug.apply(stroke).draw(rect);
        ug.apply(new UTranslate(4.0, 0.0)).apply(stroke).draw(rect2);
        ULayoutGroup header = new ULayoutGroup(new PlacementStrategyY1Y2(ug.getStringBounder()));
        header.add(this.name);
        header.drawU(ug.apply(new UTranslate(5.0, 0.0)), dimTotal.getWidth(), dimTitle.getHeight());
        if (this.url != null) {
            ug.closeAction();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimTitle = this.getTitleDimension(stringBounder);
        double width = dimTitle.getWidth();
        double height = dimTitle.getHeight();
        return new Dimension2DDouble(width + 10.0, height);
    }
}

