/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

public class ApolloniusSolver {
    public static Circle solveApollonius(Circle c1, Circle c2, Circle c3, int s1, int s2, int s3) {
        double x1 = c1.center[0];
        double y1 = c1.center[1];
        double r1 = c1.radius;
        double x2 = c2.center[0];
        double y2 = c2.center[1];
        double r2 = c2.radius;
        double x3 = c3.center[0];
        double y3 = c3.center[1];
        double r3 = c3.radius;
        double v11 = 2.0 * x2 - 2.0 * x1;
        double v12 = 2.0 * y2 - 2.0 * y1;
        double v13 = x1 * x1 - x2 * x2 + y1 * y1 - y2 * y2 - r1 * r1 + r2 * r2;
        double v14 = (double)(2 * s2) * r2 - (double)(2 * s1) * r1;
        double v21 = 2.0 * x3 - 2.0 * x2;
        double v22 = 2.0 * y3 - 2.0 * y2;
        double v23 = x2 * x2 - x3 * x3 + y2 * y2 - y3 * y3 - r2 * r2 + r3 * r3;
        double v24 = (double)(2 * s3) * r3 - (double)(2 * s2) * r2;
        double w12 = v12 / v11;
        double w13 = v13 / v11;
        double w14 = v14 / v11;
        double w22 = v22 / v21 - w12;
        double w23 = v23 / v21 - w13;
        double w24 = v24 / v21 - w14;
        double P = -w23 / w22;
        double Q = w24 / w22;
        double M = -w12 * P - w13;
        double N = w14 - w12 * Q;
        double a = N * N + Q * Q - 1.0;
        double b = 2.0 * M * N - 2.0 * N * x1 + 2.0 * P * Q - 2.0 * Q * y1 + (double)(2 * s1) * r1;
        double c = x1 * x1 + M * M - 2.0 * M * x1 + P * P + y1 * y1 - 2.0 * P * y1 - r1 * r1;
        double D = b * b - 4.0 * a * c;
        double rs = (-b - Math.sqrt(D)) / (2.0 * a);
        double xs = M + N * rs;
        double ys = P + Q * rs;
        return new Circle(new double[]{xs, ys}, rs);
    }

    public static void main(String[] args) {
        Circle c1 = new Circle(new double[]{0.0, 0.0}, 1.0);
        Circle c2 = new Circle(new double[]{4.0, 0.0}, 1.0);
        Circle c3 = new Circle(new double[]{2.0, 4.0}, 2.0);
        System.out.println(ApolloniusSolver.solveApollonius(c1, c2, c3, 1, 1, 1));
        System.out.println(ApolloniusSolver.solveApollonius(c1, c2, c3, -1, -1, -1));
    }

    static class Circle {
        public double[] center;
        public double radius;

        public Circle(double[] center, double radius) {
            this.center = center;
            this.radius = radius;
        }

        public String toString() {
            return String.format("Circle[x=%.2f,y=%.2f,r=%.2f]", this.center[0], this.center[1], this.radius);
        }
    }
}

