/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;

public class SkinLoader {
    public static final Pattern2 p1 = MyPattern.cmpile("^([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*)[%s]+(?:(\\{)|(.*))$|^\\}?$");
    private final List<String> context = new ArrayList<String>();
    private final UmlDiagram diagram;

    public SkinLoader(UmlDiagram diagram) {
        this.diagram = diagram;
    }

    private void push(String s) {
        this.context.add(s);
    }

    private void pop() {
        this.context.remove(this.context.size() - 1);
    }

    private String getFullParam() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.context) {
            sb.append(s);
        }
        return sb.toString();
    }

    public CommandExecutionResult execute(BlocLines lines, String group1) {
        if (group1 != null) {
            this.push(group1);
        }
        lines = lines.subExtract(1, 1);
        lines = lines.trim(true);
        for (CharSequence s : lines) {
            assert (s.length() > 0);
            if (s.toString().equals("}")) {
                this.pop();
                continue;
            }
            Matcher2 m = p1.matcher(s);
            if (!m.find()) {
                throw new IllegalStateException();
            }
            if (m.group(2) != null) {
                this.push(m.group(1));
                continue;
            }
            if (m.group(3) != null) {
                String key = this.getFullParam() + m.group(1);
                this.diagram.setParam(key, m.group(3));
                continue;
            }
            throw new IllegalStateException("." + s.toString() + ".");
        }
        return CommandExecutionResult.ok();
    }
}

