/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithDiamonds;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileIfWithLinks
extends FtileIfWithDiamonds {
    private final Rainbow arrowColor;

    public FtileIfWithLinks(Ftile diamond1, Ftile tile1, Ftile tile2, Ftile diamond2, Swimlane in, Rainbow arrowColor, StringBounder stringBounder) {
        super(diamond1, tile1, tile2, diamond2, in, stringBounder);
        this.arrowColor = arrowColor;
        if (arrowColor.size() == 0) {
            throw new IllegalArgumentException();
        }
    }

    public static Rainbow getInColor(Branch branch, Rainbow arrowColor) {
        Rainbow color;
        if (branch.isEmpty()) {
            return branch.getFtile().getOutLinkRendering().getRainbow(arrowColor);
        }
        LinkRendering linkIn = branch.getFtile().getInLinkRendering();
        Rainbow rainbow = color = linkIn == null ? arrowColor : linkIn.getRainbow();
        if (color.size() == 0) {
            return arrowColor;
        }
        return color;
    }

    public Ftile addLinks(Branch branch1, Branch branch2, StringBounder stringBounder) {
        ArrayList<Connection> conns = new ArrayList<Connection>();
        conns.add(new ConnectionHorizontalThenVertical(this.tile1, branch1));
        conns.add(new ConnectionHorizontalThenVertical(this.tile2, branch2));
        boolean hasPointOut1 = this.tile1.calculateDimension(stringBounder).hasPointOut();
        boolean hasPointOut2 = this.tile2.calculateDimension(stringBounder).hasPointOut();
        if (hasPointOut1 && hasPointOut2) {
            conns.add(new ConnectionVerticalThenHorizontal(this.tile1, branch1.getInlinkRenderingColorAndStyle(), branch1.isEmpty()));
            conns.add(new ConnectionVerticalThenHorizontal(this.tile2, branch2.getInlinkRenderingColorAndStyle(), branch2.isEmpty()));
        } else if (hasPointOut1 && !hasPointOut2) {
            conns.add(new ConnectionVerticalThenHorizontalDirect(this.tile1, branch1.getInlinkRenderingColorAndStyle(), branch1.isEmpty()));
        } else if (!hasPointOut1 && hasPointOut2) {
            conns.add(new ConnectionVerticalThenHorizontalDirect(this.tile2, branch2.getInlinkRenderingColorAndStyle(), branch2.isEmpty()));
        }
        return FtileUtils.addConnection((Ftile)this, conns);
    }

    class ConnectionHorizontalThenVertical
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow color;
        private final UPolygon usingArrow;

        public ConnectionHorizontalThenVertical(Ftile tile, Branch branch) {
            super(FtileIfWithLinks.this.diamond1, tile);
            this.color = FtileIfWithLinks.getInColor(branch, FtileIfWithLinks.this.arrowColor);
            if (this.color.size() == 0) {
                FtileIfWithLinks.getInColor(branch, FtileIfWithLinks.this.arrowColor);
                throw new IllegalArgumentException();
            }
            this.usingArrow = branch.isEmpty() ? null : Arrows.asToDown();
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, this.usingArrow);
            snake.addPoint(x1, y1);
            snake.addPoint(x2, y1);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            double x;
            FtileGeometry dimDiamond1 = FtileIfWithLinks.this.diamond1.calculateDimension(stringBounder);
            double diamondWidth = dimDiamond1.getWidth();
            if (this.getFtile2() == FtileIfWithLinks.this.tile1) {
                x = 0.0;
            } else if (this.getFtile2() == FtileIfWithLinks.this.tile2) {
                x = diamondWidth;
            } else {
                throw new IllegalStateException();
            }
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            return FtileIfWithLinks.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(x, dimDiamond1.getInY() + half));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return this.translate(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile2() == FtileIfWithLinks.this.tile1) {
                return FtileIfWithLinks.this.getTranslate1(stringBounder);
            }
            if (this.getFtile2() == FtileIfWithLinks.this.tile2) {
                return FtileIfWithLinks.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            Direction newDirection;
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            Direction originalDirection = Direction.leftOrRight(p1, p2);
            if (originalDirection != (newDirection = Direction.leftOrRight(p1 = translate1.getTranslated(p1), p2 = translate2.getTranslated(p2)))) {
                double delta = (double)(originalDirection == Direction.RIGHT ? -1 : 1) * 12.0;
                FtileGeometry dimDiamond1 = FtileIfWithLinks.this.diamond1.calculateDimension(stringBounder);
                Snake small = new Snake(this.arrowHorizontalAlignment(), this.color);
                small.addPoint(p1);
                small.addPoint(p1.getX() + delta, p1.getY());
                small.addPoint(p1.getX() + delta, p1.getY() + ((Dimension2D)dimDiamond1).getHeight() * 0.75);
                ug.draw(small);
                p1 = small.getLast();
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, this.usingArrow);
            snake.addPoint(p1);
            snake.addPoint(p2.getX(), p1.getY());
            snake.addPoint(p2);
            snake.goUnmergeable(MergeStrategy.LIMITED);
            ug.draw(snake);
        }
    }

    class ConnectionVerticalThenHorizontal
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow myArrowColor;
        private final boolean branchEmpty;

        public ConnectionVerticalThenHorizontal(Ftile tile, Rainbow myArrowColor, boolean branchEmpty) {
            super(tile, FtileIfWithLinks.this.diamond2);
            this.myArrowColor = myArrowColor == null || myArrowColor.size() == 0 ? FtileIfWithLinks.this.arrowColor : myArrowColor;
            this.branchEmpty = branchEmpty;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p1 = geo.translate(this.translate(stringBounder)).getPointOut();
            Point2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            UPolygon arrow = x2 > x1 ? Arrows.asToRight() : Arrows.asToLeft();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor, arrow);
            if (this.branchEmpty) {
                snake.emphasizeDirection(Direction.DOWN);
            }
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private Point2D getP2(StringBounder stringBounder) {
            double x;
            FtileGeometry dimDiamond2 = FtileIfWithLinks.this.diamond2.calculateDimension(stringBounder);
            double diamondWidth = ((Dimension2D)dimDiamond2).getWidth();
            if (this.getFtile1() == FtileIfWithLinks.this.tile1) {
                x = 0.0;
            } else if (this.getFtile1() == FtileIfWithLinks.this.tile2) {
                x = diamondWidth;
            } else {
                throw new IllegalStateException();
            }
            return FtileIfWithLinks.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(x, ((Dimension2D)dimDiamond2).getHeight() / 2.0));
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIfWithLinks.this.tile1) {
                return FtileIfWithLinks.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIfWithLinks.this.tile2) {
                return FtileIfWithLinks.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            UPolygon arrow;
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p2 = this.getP2(stringBounder);
            Point2D p1 = geo.translate(this.translate(stringBounder)).getPointOut();
            Direction originalDirection = Direction.leftOrRight(p1, p2);
            double x1 = p1.getX();
            double x2 = p2.getX();
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            Direction newDirection = Direction.leftOrRight(mp1a, mp2b);
            UPolygon uPolygon = arrow = x2 > x1 ? Arrows.asToRight() : Arrows.asToLeft();
            if (originalDirection == newDirection) {
                double delta = (double)(x2 > x1 ? -1 : 1) * 1.5 * 12.0;
                Point2D.Double mp2bc = new Point2D.Double(mp2b.getX() + delta, mp2b.getY());
                Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor);
                double middle = (mp1a.getY() + mp2b.getY()) / 2.0;
                snake.addPoint(mp1a);
                snake.addPoint(mp1a.getX(), middle);
                snake.addPoint(((Point2D)mp2bc).getX(), middle);
                snake.addPoint(mp2bc);
                snake.goUnmergeable(MergeStrategy.LIMITED);
                ug.draw(snake);
                Snake small = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor, arrow);
                small.addPoint(mp2bc);
                small.addPoint(((Point2D)mp2bc).getX(), mp2b.getY());
                small.addPoint(mp2b);
                small.goUnmergeable(MergeStrategy.LIMITED);
                ug.draw(small);
            } else {
                double delta = (double)(x2 > x1 ? -1 : 1) * 1.5 * 12.0;
                Point2D.Double mp2bb = new Point2D.Double(mp2b.getX() + delta, mp2b.getY() - 18.0);
                Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor);
                snake.addPoint(mp1a);
                snake.addPoint(mp1a.getX(), ((Point2D)mp2bb).getY());
                snake.addPoint(mp2bb);
                snake.goUnmergeable(MergeStrategy.LIMITED);
                ug.draw(snake);
                Snake small = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor, arrow);
                small.addPoint(mp2bb);
                small.addPoint(((Point2D)mp2bb).getX(), mp2b.getY());
                small.addPoint(mp2b);
                small.goUnmergeable(MergeStrategy.LIMITED);
                ug.draw(small);
            }
        }
    }

    class ConnectionVerticalThenHorizontalDirect
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow myArrowColor;
        private final boolean branchEmpty;

        public ConnectionVerticalThenHorizontalDirect(Ftile tile, Rainbow myArrowColor, boolean branchEmpty) {
            super(tile, FtileIfWithLinks.this.diamond2);
            this.myArrowColor = myArrowColor == null || myArrowColor.size() == 0 ? FtileIfWithLinks.this.arrowColor : myArrowColor;
            this.branchEmpty = branchEmpty;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry dimTotal = FtileIfWithLinks.this.calculateDimensionInternal(stringBounder);
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p1 = geo.translate(this.translate(stringBounder)).getPointOut();
            Point2D.Double p2 = new Point2D.Double(dimTotal.getLeft(), dimTotal.getHeight());
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = ((Point2D)p2).getX();
            double y2 = ((Point2D)p2).getY();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor);
            if (this.branchEmpty) {
                snake.emphasizeDirection(Direction.DOWN);
            }
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            snake.addPoint(x2, dimTotal.getHeight());
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry dimTotal = FtileIfWithLinks.this.calculateDimensionInternal(stringBounder);
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p1 = geo.translate(this.translate(stringBounder)).getPointOut();
            Point2D.Double p2 = new Point2D.Double(dimTotal.getLeft(), dimTotal.getHeight() - 12.0);
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.myArrowColor);
            double x1 = mp1a.getX();
            double x2 = mp2b.getX();
            double y2 = mp2b.getY();
            snake.addPoint(mp1a);
            snake.addPoint(x1, y2);
            snake.addPoint(mp2b);
            snake.addPoint(x2, dimTotal.getHeight());
            snake.goUnmergeable(MergeStrategy.LIMITED);
            ug.draw(snake);
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIfWithLinks.this.tile1) {
                return FtileIfWithLinks.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIfWithLinks.this.tile2) {
                return FtileIfWithLinks.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }
    }
}

