/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileIfDown;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfNude;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithDiamonds;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithLinks;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;

public class ConditionalBuilder {
    private final Swimlane swimlane;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final Rainbow arrowColor;
    private final FtileFactory ftileFactory;
    private final ConditionStyle conditionStyle;
    private final Branch branch1;
    private final Branch branch2;
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final FontConfiguration fontArrow;
    private final FontConfiguration fontTest;
    private final Ftile tile1;
    private final Ftile tile2;

    public ConditionalBuilder(Swimlane swimlane, HtmlColor borderColor, HtmlColor backColor, Rainbow arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch1, Branch branch2, ISkinParam skinParam, StringBounder stringBounder, FontConfiguration fontArrow, FontConfiguration fontTest) {
        this.swimlane = swimlane;
        this.borderColor = borderColor;
        this.backColor = backColor;
        this.arrowColor = arrowColor;
        this.ftileFactory = ftileFactory;
        this.conditionStyle = conditionStyle;
        this.branch1 = branch1;
        this.branch2 = branch2;
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
        this.fontArrow = fontArrow;
        this.fontTest = fontTest;
        this.tile1 = new FtileMinWidth(branch1.getFtile(), 30.0);
        this.tile2 = new FtileMinWidth(branch2.getFtile(), 30.0);
    }

    public static Ftile create(Swimlane swimlane, HtmlColor borderColor, HtmlColor backColor, Rainbow arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch1, Branch branch2, ISkinParam skinParam, StringBounder stringBounder, FontConfiguration fcArrow, FontConfiguration fcTest) {
        ConditionalBuilder builder = new ConditionalBuilder(swimlane, borderColor, backColor, arrowColor, ftileFactory, conditionStyle, branch1, branch2, skinParam, stringBounder, fcArrow, fcTest);
        if (ConditionalBuilder.isEmptyOrOnlySingleStopOrSpot(branch2) && !ConditionalBuilder.isEmptyOrOnlySingleStopOrSpot(branch1)) {
            return builder.createDown(builder.branch1, builder.branch2);
        }
        if (branch1.isEmpty() && branch2.isOnlySingleStopOrSpot()) {
            return builder.createDown(builder.branch1, builder.branch2);
        }
        if (ConditionalBuilder.isEmptyOrOnlySingleStopOrSpot(branch1) && !ConditionalBuilder.isEmptyOrOnlySingleStopOrSpot(branch2)) {
            return builder.createDown(builder.branch2, builder.branch1);
        }
        if (branch2.isEmpty() && branch1.isOnlySingleStopOrSpot()) {
            return builder.createDown(builder.branch2, builder.branch1);
        }
        return builder.createWithLinks();
    }

    private static boolean isEmptyOrOnlySingleStopOrSpot(Branch branch) {
        return branch.isEmpty() || branch.isOnlySingleStopOrSpot();
    }

    private Ftile createDown(Branch branch1, Branch branch2) {
        FtileMinWidth tile1 = new FtileMinWidth(branch1.getFtile(), 30.0);
        FtileMinWidth tile2 = new FtileMinWidth(branch2.getFtile(), 30.0);
        TextBlock tb1 = this.getLabelPositive(branch1);
        TextBlock tb2 = this.getLabelPositive(branch2);
        Ftile diamond1 = this.getDiamond1(false, tb1, tb2);
        Ftile diamond2 = this.getDiamond2(branch1, branch2, true);
        if (branch2.isOnlySingleStopOrSpot()) {
            return FtileIfDown.create(diamond1, diamond2, this.swimlane, FtileUtils.addHorizontalMargin(tile1, 10.0), this.arrowColor, this.ftileFactory, branch2.getFtile(), branch2.getInlinkRenderingColorAndStyle());
        }
        if (branch1.isOnlySingleStopOrSpot()) {
            return FtileIfDown.create(diamond1, diamond2, this.swimlane, FtileUtils.addHorizontalMargin(tile2, 10.0), this.arrowColor, this.ftileFactory, branch1.getFtile(), branch1.getInlinkRenderingColorAndStyle());
        }
        if (branch1.isEmpty()) {
            return FtileIfDown.create(diamond1, diamond2, this.swimlane, FtileUtils.addHorizontalMargin(tile2, 10.0), this.arrowColor, this.ftileFactory, null, null);
        }
        return FtileIfDown.create(diamond1, diamond2, this.swimlane, FtileUtils.addHorizontalMargin(tile1, 10.0), this.arrowColor, this.ftileFactory, null, branch2.getInlinkRenderingColorAndStyle());
    }

    private Ftile createNude() {
        return new FtileIfNude(this.tile1, this.tile2, this.swimlane);
    }

    private Ftile createWithDiamonds() {
        Ftile diamond1 = this.getDiamond1(true);
        Ftile diamond2 = this.getDiamond2(this.branch1, this.branch2, false);
        FtileIfWithDiamonds ftile = new FtileIfWithDiamonds(diamond1, this.tile1, this.tile2, diamond2, this.swimlane, this.stringBounder);
        Dimension2D label1 = this.getLabelPositive(this.branch1).calculateDimension(this.stringBounder);
        Dimension2D label2 = this.getLabelPositive(this.branch2).calculateDimension(this.stringBounder);
        double diff1 = ftile.computeMarginNeedForBranchLabe1(this.stringBounder, label1);
        double diff2 = ftile.computeMarginNeedForBranchLabe2(this.stringBounder, label2);
        Ftile result = FtileUtils.addHorizontalMargin(ftile, diff1, diff2);
        double suppHeight = ftile.computeVerticalMarginNeedForBranchs(this.stringBounder, label1, label2);
        result = FtileUtils.addVerticalMargin(result, suppHeight, 0.0);
        return result;
    }

    private Ftile createWithLinks() {
        Ftile diamond1 = this.getDiamond1(true);
        Ftile diamond2 = this.getDiamond2(this.branch1, this.branch2, false);
        Ftile tmp1 = FtileUtils.addHorizontalMargin(this.tile1, 10.0);
        Ftile tmp2 = FtileUtils.addHorizontalMargin(this.tile2, 10.0);
        FtileIfWithLinks ftile = new FtileIfWithLinks(diamond1, tmp1, tmp2, diamond2, this.swimlane, this.arrowColor, this.stringBounder);
        Dimension2D label1 = this.getLabelPositive(this.branch1).calculateDimension(this.stringBounder);
        Dimension2D label2 = this.getLabelPositive(this.branch2).calculateDimension(this.stringBounder);
        double diff1 = ftile.computeMarginNeedForBranchLabe1(this.stringBounder, label1);
        double diff2 = ftile.computeMarginNeedForBranchLabe2(this.stringBounder, label2);
        double suppHeight = ftile.computeVerticalMarginNeedForBranchs(this.stringBounder, label1, label2);
        Ftile result = ftile.addLinks(this.branch1, this.branch2, this.stringBounder);
        result = FtileUtils.addHorizontalMargin(result, diff1, diff2);
        result = FtileUtils.addVerticalMargin(result, suppHeight, 0.0);
        return result;
    }

    private Ftile getDiamond1(boolean eastWest) {
        return this.getDiamond1(eastWest, this.getLabelPositive(this.branch1), this.getLabelPositive(this.branch2));
    }

    private Ftile getDiamond1(boolean eastWest, TextBlock tb1, TextBlock tb2) {
        Ftile diamond1;
        Display labelTest = this.branch1.getLabelTest();
        Sheet sheet = new CreoleParser(this.fontTest, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.skinParam, CreoleMode.FULL).createSheet(labelTest);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        SheetBlock2 tbTest = new SheetBlock2(sheetBlock1, Diamond.asStencil(sheetBlock1), this.tile1.getThickness());
        if (this.conditionStyle == ConditionStyle.INSIDE) {
            diamond1 = eastWest ? new FtileDiamondInside(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane, tbTest).withWestAndEast(tb1, tb2) : new FtileDiamondInside(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane, tbTest).withSouth(tb1).withEast(tb2);
        } else if (this.conditionStyle == ConditionStyle.DIAMOND) {
            diamond1 = eastWest ? new FtileDiamond(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withNorth(tbTest).withWestAndEast(tb1, tb2) : new FtileDiamond(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withNorth(tbTest).withSouth(tb1).withEast(tb2);
        } else {
            throw new IllegalStateException();
        }
        return diamond1;
    }

    private TextBlock getLabelPositive(Branch branch) {
        return branch.getLabelPositive().create(this.fontArrow, HorizontalAlignment.LEFT, (ISkinSimple)this.ftileFactory.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    private Ftile getDiamond2(Branch branch1, Branch branch2, boolean useNorth) {
        AbstractFtile diamond2;
        if (this.hasTwoBranches()) {
            Display out1 = branch1.getFtile().getOutLinkRendering().getDisplay();
            TextBlock tbout1 = out1 == null ? null : out1.create(this.fontArrow, HorizontalAlignment.LEFT, (ISkinSimple)this.ftileFactory.skinParam(), CreoleMode.SIMPLE_LINE);
            Display out2 = branch2.getFtile().getOutLinkRendering().getDisplay();
            TextBlock tbout2 = out2 == null ? null : out2.create(this.fontArrow, HorizontalAlignment.LEFT, (ISkinSimple)this.ftileFactory.skinParam(), CreoleMode.SIMPLE_LINE);
            FtileDiamond tmp = new FtileDiamond(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane);
            tmp = useNorth ? tmp.withNorth(tbout1) : tmp.withWest(tbout1);
            tmp = tmp.withEast(tbout2);
            diamond2 = tmp;
        } else {
            diamond2 = new FtileEmpty(this.tile1.skinParam(), 0.0, 6.0, this.swimlane, this.swimlane);
        }
        return diamond2;
    }

    public boolean hasTwoBranches() {
        return this.tile1.calculateDimension(this.stringBounder).hasPointOut() && this.tile2.calculateDimension(this.stringBounder).hasPointOut();
    }
}

